/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clipboard;

import org.eclipse.egit.ui.internal.clone.GitUrlChecker;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ClipboardPropertyTester
extends AbstractPropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean value = this.internalTest(property);
        if (GitTraceLocation.CLIPBOARD.isActive()) {
            String clipboardText = this.getClipboardTextContent();
            Control ctrl = this.getFocusedControl();
            GitTraceLocation.getTrace().trace(GitTraceLocation.CLIPBOARD.getLocation(), "prop " + property + " The clipboard text value is " + (String)(clipboardText == null ? " No text value in clipboard " : "'" + clipboardText + "'") + " = " + value + (String)(ctrl == null ? "" : ", current Control class = " + ctrl.getClass().getName()) + ", expected = " + String.valueOf(expectedValue));
        }
        return this.computeResult(expectedValue, value);
    }

    private boolean internalTest(String property) {
        String sanitized;
        String content;
        if (property.equals("containsGitURL") && (content = this.getClipboardTextContent()) != null && GitUrlChecker.isValidGitUrl(sanitized = GitUrlChecker.sanitizeAsGitUrl(content))) {
            Control c = this.getFocusedControl();
            return c != null && !(c instanceof StyledText) && !(c instanceof Text);
        }
        return false;
    }

    @Nullable
    private String getClipboardTextContent() {
        Clipboard clipboard = new Clipboard(null);
        Object content = clipboard.getContents((Transfer)TextTransfer.getInstance());
        clipboard.dispose();
        return content == null ? null : content.toString();
    }

    private Control getFocusedControl() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display != null ? display.getFocusControl() : null;
    }
}

