/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.surround.ExceptionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.SurroundWithAnalyzer;

public class SurroundWithTryWithResourcesAnalyzer
extends SurroundWithAnalyzer {
    private ITypeBinding[] fExceptions;
    private ASTNode fEnclosingNode;
    private CompilationUnit fCompilationUnit;

    public SurroundWithTryWithResourcesAnalyzer(ICompilationUnit unit, Selection selection) throws CoreException {
        super(unit, selection, true);
    }

    public ITypeBinding[] getExceptions(Selection selection) {
        this.fExceptions = new ITypeBinding[0];
        if (this.fEnclosingNode != null && !this.getStatus().hasFatalError()) {
            this.fExceptions = ExceptionAnalyzer.perform(this.fEnclosingNode, selection, false);
            if (this.fExceptions == null || this.fExceptions.length == 0) {
                if (this.fEnclosingNode instanceof MethodReference) {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_doesNotContain);
                } else {
                    List<ASTNode> autoClosableNodes = this.getCoveredAutoClosableNodes();
                    this.fExceptions = autoClosableNodes.isEmpty() ? new ITypeBinding[]{this.fCompilationUnit.getAST().resolveWellKnownType("java.lang.Exception")} : new ITypeBinding[0];
                }
            }
        }
        return this.fExceptions;
    }

    public ITypeBinding[] getCaughtExceptions() {
        ArrayList<ITypeBinding> exceptions = new ArrayList<ITypeBinding>();
        TryStatement enclosingTry = (TryStatement)ASTResolving.findAncestor(this.getFirstSelectedNode(), 54);
        while (enclosingTry != null) {
            List catchClauses = enclosingTry.catchClauses();
            block1: for (CatchClause catchClause : catchClauses) {
                SingleVariableDeclaration sdv = catchClause.getException();
                Type type = sdv.getType();
                if (type instanceof UnionType) {
                    UnionType unionType = (UnionType)type;
                    List types = unionType.types();
                    for (Type t : types) {
                        ITypeBinding binding = t.resolveBinding();
                        if (binding == null) continue block1;
                        exceptions.add(binding);
                    }
                    continue;
                }
                ITypeBinding binding = type.resolveBinding();
                if (binding == null) continue;
                exceptions.add(binding);
            }
            enclosingTry = (TryStatement)ASTResolving.findAncestor(enclosingTry.getParent(), 54);
        }
        return exceptions.toArray(new ITypeBinding[0]);
    }

    public ITypeBinding[] getThrownExceptions() {
        ArrayList<ITypeBinding> exceptions = new ArrayList<ITypeBinding>();
        if (this.fEnclosingNode != null) {
            if (this.fEnclosingNode.getNodeType() == 31) {
                List thrownExceptions = ((MethodDeclaration)this.fEnclosingNode).thrownExceptionTypes();
                for (Type type : thrownExceptions) {
                    ITypeBinding thrownException = type.resolveBinding();
                    if (thrownException == null) continue;
                    exceptions.add(thrownException);
                }
            } else {
                IMethodBinding methodBinding;
                ITypeBinding typeBinding = null;
                if (this.fEnclosingNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
                    typeBinding = ((LambdaExpression)this.fEnclosingNode.getParent()).resolveTypeBinding();
                } else if (this.fEnclosingNode instanceof MethodReference) {
                    typeBinding = ((MethodReference)this.fEnclosingNode).resolveTypeBinding();
                }
                if (typeBinding != null && (methodBinding = typeBinding.getFunctionalInterfaceMethod()) != null) {
                    Collections.addAll(exceptions, methodBinding.getExceptionTypes());
                }
            }
        }
        return exceptions.toArray(new ITypeBinding[0]);
    }

    public List<ITypeBinding> calculateCatchesAndRethrows(List<ITypeBinding> exceptions, List<ITypeBinding> mustRethrowList) {
        ITypeBinding[] iTypeBindingArray;
        int n;
        ArrayList<ITypeBinding> exceptionList = new ArrayList<ITypeBinding>(exceptions);
        ITypeBinding[] caughtExceptions = this.getCaughtExceptions();
        if (caughtExceptions.length > 0) {
            ITypeBinding caughtException;
            int n2;
            ITypeBinding[] iTypeBindingArray2;
            Iterator iter = exceptionList.iterator();
            block0: while (iter.hasNext()) {
                ITypeBinding binding = (ITypeBinding)iter.next();
                iTypeBindingArray2 = caughtExceptions;
                n = caughtExceptions.length;
                n2 = 0;
                while (n2 < n) {
                    caughtException = iTypeBindingArray2[n2];
                    if (binding.isAssignmentCompatible(caughtException)) {
                        iter.remove();
                        continue block0;
                    }
                    ++n2;
                }
            }
            block2: for (ITypeBinding binding : exceptionList) {
                iTypeBindingArray2 = caughtExceptions;
                n = caughtExceptions.length;
                n2 = 0;
                while (n2 < n) {
                    caughtException = iTypeBindingArray2[n2];
                    if (caughtException.isAssignmentCompatible(binding)) {
                        mustRethrowList.add(caughtException);
                        continue block2;
                    }
                    ++n2;
                }
            }
        }
        ITypeBinding[] thrownExceptions = this.getThrownExceptions();
        Iterator iter = exceptionList.iterator();
        block4: while (iter.hasNext()) {
            ITypeBinding binding = (ITypeBinding)iter.next();
            iTypeBindingArray = thrownExceptions;
            int n3 = thrownExceptions.length;
            n = 0;
            while (n < n3) {
                ITypeBinding thrownException = iTypeBindingArray[n];
                if (binding.isAssignmentCompatible(thrownException)) {
                    iter.remove();
                    continue block4;
                }
                ++n;
            }
        }
        block6: for (ITypeBinding binding : exceptionList) {
            iTypeBindingArray = thrownExceptions;
            int n4 = thrownExceptions.length;
            n = 0;
            while (n < n4) {
                ITypeBinding thrownException = iTypeBindingArray[n];
                if (thrownException.isAssignmentCompatible(binding)) {
                    if (mustRethrowList.contains(thrownException)) continue block6;
                    mustRethrowList.add(thrownException);
                    continue block6;
                }
                ++n;
            }
        }
        return exceptionList;
    }

    public ASTNode getEnclosingNode() {
        return this.fEnclosingNode;
    }

    @Override
    public void endVisit(CompilationUnit node) {
        this.fEnclosingNode = null;
        this.fCompilationUnit = node;
        if (!this.getStatus().hasFatalError() && this.hasSelectedNodes()) {
            this.fEnclosingNode = SurroundWithAnalyzer.getEnclosingNode(this.getFirstSelectedNode());
        }
        super.endVisit(node);
    }

    public List<ASTNode> getCoveredAutoClosableNodes() {
        ASTNode[] astNodes = this.getSelectedNodes();
        ArrayList<ASTNode> autoClosableNodes = new ArrayList<ASTNode>();
        ASTNode[] aSTNodeArray = astNodes;
        int n = astNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode astNode = aSTNodeArray[n2];
            if (!this.isAutoClosable(astNode)) {
                return autoClosableNodes;
            }
            autoClosableNodes.add(astNode);
            ++n2;
        }
        return autoClosableNodes;
    }

    private boolean isAutoClosable(ASTNode astNode) {
        Map<SimpleName, IVariableBinding> simpleNames = this.getVariableStatementBinding(astNode);
        block3: for (Map.Entry<SimpleName, IVariableBinding> entry : simpleNames.entrySet()) {
            ITypeBinding typeBinding = null;
            switch (entry.getKey().getParent().getNodeType()) {
                case 7: 
                case 59: 
                case 60: {
                    typeBinding = entry.getValue().getType();
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (typeBinding == null) continue;
            ITypeBinding[] iTypeBindingArray = Bindings.getAllSuperTypes(typeBinding);
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding superType = iTypeBindingArray[n2];
                if ("java.lang.AutoCloseable".equals(superType.getQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Map<SimpleName, IVariableBinding> getVariableStatementBinding(ASTNode astNode) {
        final HashMap<SimpleName, IVariableBinding> variableBindings = new HashMap<SimpleName, IVariableBinding>();
        astNode.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                for (Object o : node.fragments()) {
                    VariableDeclarationFragment vdf;
                    SimpleName name;
                    IBinding binding;
                    if (!(o instanceof VariableDeclarationFragment) || !((binding = (name = (vdf = (VariableDeclarationFragment)o).getName()).resolveBinding()) instanceof IVariableBinding)) continue;
                    variableBindings.put(name, (IVariableBinding)binding);
                    break;
                }
                return false;
            }
        });
        return variableBindings;
    }
}

