/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.interop.internal.commands;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.interop.InvokeStatic;
import org.eclipse.rcptt.ecl.interop.internal.EclInteropPlugin;
import org.eclipse.rcptt.ecl.interop.internal.commands.InvokeService;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.osgi.framework.Bundle;

public class InvokeStaticService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Class class_;
        InvokeStatic invokeStatic = (InvokeStatic)command;
        Bundle bundle = Platform.getBundle((String)invokeStatic.getPluginId());
        if (bundle == null) {
            return EclInteropPlugin.error("Can't find plugin %s", invokeStatic.getPluginId());
        }
        try {
            class_ = bundle.loadClass(invokeStatic.getClassName());
        }
        catch (ClassNotFoundException e) {
            return EclInteropPlugin.error(e, "Can't load class %s", invokeStatic.getClassName());
        }
        Object[] args = invokeStatic.getArgs().toArray();
        String name = invokeStatic.getMethodName();
        Object result = null;
        try {
            Method method = InvokeService.matchMethod(class_, name, args);
            if (method == null) {
                if (args.length > 0) {
                    return EclInteropPlugin.error("Method not found.");
                }
                result = InvokeStaticService.getFieldValue(class_, name);
            } else {
                if ((method.getModifiers() & 8) == 0) {
                    return EclInteropPlugin.error("Method %s is not static", name);
                }
                result = method.invoke(null, args);
            }
        }
        catch (Exception e) {
            return EclInteropPlugin.error("%s: %s", e.getClass().getName(), e.getMessage());
        }
        if (result != null) {
            context.getOutput().write(result);
        }
        return Status.OK_STATUS;
    }

    private static Object getFieldValue(Class<?> class_, String name) throws CoreException {
        if (class_ == null) {
            throw new CoreException((IStatus)EclInteropPlugin.error("method or field not found"));
        }
        try {
            Field field = class_.getDeclaredField(name);
            if ((field.getModifiers() & 8) == 0) {
                throw new CoreException((IStatus)EclInteropPlugin.error("Field %s is not static", name));
            }
            field.setAccessible(true);
            return field.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new CoreException(EclInteropPlugin.error(e, "Unexpected error getting field %s", name));
        }
        catch (SecurityException e) {
            throw new CoreException(EclInteropPlugin.error(e, "Unexpected error getting field %s", name));
        }
        catch (IllegalAccessException e) {
            throw new CoreException(EclInteropPlugin.error(e, "Unexpected error getting field %s", name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return InvokeStaticService.getFieldValue(class_.getSuperclass(), name);
        }
    }
}

