/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.client.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.client.tcp.EclTcpClientPlugin;
import org.eclipse.rcptt.ecl.client.tcp.EclTcpSocketStatus;
import org.eclipse.rcptt.ecl.client.tcp.NetworkUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.internal.core.Pipe;
import org.eclipse.rcptt.ecl.internal.core.Process;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class EclTcpSession
implements ISession {
    private static final ExecutionNode CLOSE_NODE = new ExecutionNode();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InetAddress address;
    private int port;
    private Socket socket;
    private String sessionID;
    private BlockingQueue<ExecutionNode> commands = new LinkedBlockingQueue<ExecutionNode>(10);
    private Thread processingThread;

    public EclTcpSession(InetAddress address, int port) throws IOException {
        NetworkUtil.initTimeouts();
        this.address = address;
        this.port = port;
        try {
            this.initSocket(address, port, true);
        }
        catch (IOException e) {
            this.initSocket(address, port, false);
            EclTcpClientPlugin.logInfo("Could not open a session with NO_DELAY and SO_REUSEADDR, succeeded with default socket", new Object[0]);
        }
        this.processingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        if (EclTcpSession.access$1(EclTcpSession.this).get()) {
                            return;
                        }
                        node = null;
                        pipe = null;
                        try {
                            node = (ExecutionNode)EclTcpSession.access$2(EclTcpSession.this).take();
                            if (EclTcpSession.access$3().equals(node)) {
                                if (pipe == null) return;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable t) {
                            try {
                                if (node != null) {
                                    status = t instanceof CoreException != false ? ((CoreException)t).getStatus() : CorePlugin.err((Throwable)t);
                                    node.process.setStatus((IStatus)new EclTcpSocketStatus(status));
                                }
                            }
                            catch (CoreException e1) {
                                CorePlugin.log((Throwable)e1);
                            }
                            if (pipe == null) continue;
                            pipe.closeNoWait();
                            continue;
                        }
                        catch (Throwable var5_10) {
                            if (pipe == null) throw var5_10;
                            pipe.closeNoWait();
                            throw var5_10;
                        }
                        pipe.closeNoWait();
                        return;
lbl-1000:
                        // 1 sources

                        {
                            pipe = CoreUtils.createEMFPipe((InputStream)EclTcpSession.access$4(EclTcpSession.this).getInputStream(), (OutputStream)EclTcpSession.access$4(EclTcpSession.this).getOutputStream());
                            pipe.write((Object)node.command);
                            EclTcpSession.access$5(EclTcpSession.this, node.input, (IPipe)pipe);
                            pipe.writeCloseMarker();
                            result = EclTcpSession.access$6(EclTcpSession.this, node.output, (IPipe)pipe);
                            node.process.setStatus(result);
                        }
                        if (pipe == null) continue;
                        pipe.closeNoWait();
                    }
                }
                finally {
                    try {
                        EclTcpSession.access$0(EclTcpSession.this);
                    }
                    catch (Throwable e) {
                        CorePlugin.log((Throwable)e);
                    }
                }
            }
        }, "ECL TCP session execute: " + this.sessionID);
        this.processingThread.start();
    }

    private void initSocket(InetAddress address, int port, boolean nonDefaultSocket) throws SocketException, IOException {
        this.socket = new Socket();
        if (nonDefaultSocket) {
            this.socket.setReuseAddress(true);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (SocketException e) {
                EclTcpClientPlugin.log((IStatus)new Status(4, "org.eclipse.rcptt.ecl.client.tcp", "Error setting TCP_NODELAY on client socket"));
            }
        }
        this.socket.connect(new InetSocketAddress(address, port));
        this.initSessionId(this.socket);
    }

    private void initSessionId(Socket socket) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        DataOutputStream dout = new DataOutputStream(outputStream);
        DataInputStream din = new DataInputStream(inputStream);
        dout.writeUTF("newsession");
        dout.flush();
        this.sessionID = din.readUTF();
    }

    public IPipe createPipe() {
        return new Pipe();
    }

    public IProcess execute(Command command) throws CoreException {
        return this.execute(command, null, null);
    }

    public IProcess execute(Command command, IPipe in, IPipe out) throws CoreException {
        ExecutionNode node = new ExecutionNode();
        node.command = (Command)EcoreUtil.copy((EObject)command);
        node.input = in == null ? this.createPipe().close(Status.OK_STATUS) : in;
        node.output = out == null ? this.createPipe() : out;
        node.process = new Process((ISession)this, node.input, node.output);
        try {
            this.commands.put(node);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.client.tcp", "Failed to execute ecl command: " + command.getClass().getName(), (Throwable)e));
        }
        return node.process;
    }

    private void readInput(IPipe input, IPipe pipe) throws CoreException {
        Object object;
        while (true) {
            if ((object = input.take(Long.MAX_VALUE)) instanceof IStatus) break;
            pipe.write(object);
        }
        pipe.write(object);
    }

    private IStatus writeOutput(IPipe output, IPipe pipe) throws CoreException {
        Object object;
        while (!((object = pipe.take(Long.MAX_VALUE)) instanceof IStatus)) {
            output.write(object);
        }
        return (IStatus)object;
    }

    public void close() throws CoreException {
        this.closed.compareAndSet(false, true);
        try {
            if (!Thread.currentThread().isInterrupted()) {
                this.commands.put(CLOSE_NODE);
            } else {
                this.processingThread.interrupt();
            }
            this.closeSocket();
        }
        catch (Throwable e) {
            CorePlugin.log((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    private synchronized void closeSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public synchronized void putProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public synchronized Object getProperty(String key) {
        return this.properties.get(key);
    }

    static /* synthetic */ void access$0(EclTcpSession eclTcpSession) throws IOException {
        eclTcpSession.closeSocket();
    }

    static /* synthetic */ AtomicBoolean access$1(EclTcpSession eclTcpSession) {
        return eclTcpSession.closed;
    }

    static /* synthetic */ BlockingQueue access$2(EclTcpSession eclTcpSession) {
        return eclTcpSession.commands;
    }

    static /* synthetic */ ExecutionNode access$3() {
        return CLOSE_NODE;
    }

    static /* synthetic */ Socket access$4(EclTcpSession eclTcpSession) {
        return eclTcpSession.socket;
    }

    static /* synthetic */ void access$5(EclTcpSession eclTcpSession, IPipe iPipe, IPipe iPipe2) throws CoreException {
        eclTcpSession.readInput(iPipe, iPipe2);
    }

    static /* synthetic */ IStatus access$6(EclTcpSession eclTcpSession, IPipe iPipe, IPipe iPipe2) throws CoreException {
        return eclTcpSession.writeOutput(iPipe, iPipe2);
    }

    private static class ExecutionNode {
        Command command;
        IPipe input;
        IPipe output;
        Process process;

        private ExecutionNode() {
        }
    }
}

