/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import org.eclipse.core.commands.Command;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.commands.QueryControl;
import org.eclipse.pde.internal.ui.commands.TagManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class QueryByTag
extends QueryControl {
    private TagManager fTagManager;
    private Combo fTagsCombo;
    private TagManager.Listener fTagManagerListener;

    public QueryByTag(CommandComposerPart csp, Composite comp) {
        super(csp, comp);
    }

    @Override
    protected void createGroupContents(Group parent) {
        this.fTagManager = this.fCSP.getTagManager();
        this.fTagsCombo = new Combo((Composite)parent, 12);
        this.fTagsCombo.setLayoutData((Object)new GridData(768));
        this.fToolkit.adapt((Control)this.fTagsCombo, true, true);
        this.fTagManagerListener = new TagManagerListener();
        this.fCSP.getTagManager().addListener(this.fTagManagerListener);
        parent.addDisposeListener(e -> {
            if (this.fTagManagerListener != null) {
                this.fTagManager.removeListener(this.fTagManagerListener);
            }
        });
    }

    @Override
    protected String getName() {
        return "Query Commands by Tags";
    }

    private void refreshTags() {
        String[] tags;
        this.fTagsCombo.removeAll();
        String[] stringArray = tags = this.fTagManager.getTags();
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.fTagsCombo.add(tag);
            ++n2;
        }
    }

    @Override
    protected Command[] getCommands() {
        String tagText = this.fTagsCombo.getText();
        return this.fCSP.getTagManager().getCommands(tagText);
    }

    @Override
    protected void enable(boolean enable) {
        this.fGroup.setEnabled(enable);
        this.fTagsCombo.setEnabled(enable);
    }

    private class TagManagerListener
    implements TagManager.Listener {
        private TagManagerListener() {
        }

        @Override
        public void tagManagerChanged() {
            QueryByTag.this.refreshTags();
        }
    }
}

