/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rcptt.ui.editors.ecl.ColorManager;
import org.eclipse.rcptt.ui.editors.ecl.EditorToolkit;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class EnhancedRuleScanner
extends BufferedRuleBasedScanner {
    public static final String boldSuffix = "_bold";
    public static final String italicSuffix = "_italic";
    public static final String strikethroughSuffix = "_strikethrough";
    public static final String underlineSuffix = "_underline";
    protected final ColorManager colorManager;
    protected final IPreferenceStore preferenceStore;
    protected Map<String, Token> tokenMap = new HashMap<String, Token>();
    protected Map<String, Integer> properties = new HashMap<String, Integer>();
    protected String[] color;
    protected String[] bold;
    protected String[] italic;
    protected String[] strikethrough;
    protected String[] underline;
    protected boolean needsLazyColorLoading;

    protected abstract String[] getProperties();

    protected abstract List<IRule> createRules();

    public EnhancedRuleScanner(EditorToolkit toolkit) {
        this.preferenceStore = toolkit.getPreferenceStore();
        this.colorManager = toolkit.getColorManager();
    }

    public final void initialize() {
        this.color = this.getProperties();
        this.bold = new String[this.color.length];
        this.italic = new String[this.color.length];
        this.strikethrough = new String[this.color.length];
        this.underline = new String[this.color.length];
        int i = 0;
        while (i < this.color.length) {
            this.bold[i] = this.getBoldKey(this.color[i]);
            this.italic[i] = this.getItalicKey(this.color[i]);
            this.strikethrough[i] = this.getStrikethroughKey(this.color[i]);
            this.underline[i] = this.getUnderlineKey(this.color[i]);
            this.properties.put(this.bold[i], i);
            this.properties.put(this.italic[i], i);
            this.properties.put(this.strikethrough[i], i);
            this.properties.put(this.underline[i], i);
            ++i;
        }
        this.needsLazyColorLoading = Display.getCurrent() == null;
        i = 0;
        while (i < this.color.length) {
            if (this.needsLazyColorLoading) {
                this.addTokenWithProxyAttribute(this.color[i], this.bold[i], this.italic[i], this.strikethrough[i], this.underline[i]);
            } else {
                this.addToken(this.color[i], this.bold[i], this.italic[i], this.strikethrough[i], this.underline[i]);
            }
            ++i;
        }
        this.initializeRules();
    }

    protected String getBoldKey(String colorKey) {
        return colorKey + boldSuffix;
    }

    protected String getItalicKey(String colorKey) {
        return colorKey + italicSuffix;
    }

    protected String getStrikethroughKey(String colorKey) {
        return colorKey + strikethroughSuffix;
    }

    protected String getUnderlineKey(String colorKey) {
        return colorKey + underlineSuffix;
    }

    public IToken nextToken() {
        if (this.needsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return super.nextToken();
    }

    private void resolveProxyAttributes() {
        if (this.needsLazyColorLoading && Display.getCurrent() != null) {
            int i = 0;
            while (i < this.color.length) {
                this.addToken(this.color[i], this.bold[i], this.italic[i], this.strikethrough[i], this.underline[i]);
                ++i;
            }
            this.needsLazyColorLoading = false;
        }
    }

    private void addTokenWithProxyAttribute(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        this.tokenMap.put(colorKey, new Token((Object)this.createTextAttribute(null, boldKey, italicKey, strikethroughKey, underlineKey)));
    }

    private void addToken(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        if (this.colorManager != null && colorKey != null && this.colorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)colorKey);
            this.colorManager.unbindColor(colorKey);
            this.colorManager.bindColor(colorKey, rgb);
        }
        if (!this.needsLazyColorLoading) {
            this.tokenMap.put(colorKey, new Token((Object)this.createTextAttribute(colorKey, boldKey, italicKey, strikethroughKey, underlineKey)));
        } else {
            Token token = this.tokenMap.get(colorKey);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(colorKey, boldKey, italicKey, strikethroughKey, underlineKey));
            }
        }
    }

    private TextAttribute createTextAttribute(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        int style;
        Color color = null;
        if (colorKey != null) {
            color = this.colorManager.getColor(colorKey);
        }
        int n = style = this.preferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.preferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.preferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.preferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, null, style);
    }

    protected Token getToken(String key) {
        if (this.needsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
        return this.tokenMap.get(key);
    }

    private void initializeRules() {
        List<IRule> rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    private int indexOf(String property) {
        if (property != null) {
            int i = 0;
            while (i < this.color.length) {
                if (property.equals(this.color[i]) || property.equals(this.bold[i]) || property.equals(this.italic[i]) || property.equals(this.strikethrough[i]) || property.equals(this.underline[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.color[index]);
        if (this.color[index].equals(p)) {
            this.adaptToColorChange(token, event);
        } else if (this.bold[index].equals(p)) {
            this.adaptToStyleChange(token, event, 1);
        } else if (this.italic[index].equals(p)) {
            this.adaptToStyleChange(token, event, 2);
        } else if (this.strikethrough[index].equals(p)) {
            this.adaptToStyleChange(token, event, 0x20000000);
        } else if (this.underline[index].equals(p)) {
            this.adaptToStyleChange(token, event, 0x40000000);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            Object data;
            String property = event.getProperty();
            Color color = this.colorManager.getColor(property);
            if (color == null || !rgb.equals((Object)color.getRGB())) {
                this.colorManager.unbindColor(property);
                this.colorManager.bindColor(property, rgb);
                color = this.colorManager.getColor(property);
            }
            if ((data = token.getData()) instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }
}

