/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.recording.core.ecl.EclRecorder;

public class Scenarios {
    public static final String ECL_SCENARIO_TYPE = "ecl";
    public static final String TESLA_SCENARIO_TYPE = "tesla";

    public static boolean isEclMode(Scenario scenario) {
        return ECL_SCENARIO_TYPE.equals(Scenarios.getScenarioType(scenario, ECL_SCENARIO_TYPE));
    }

    public static boolean isTeslaMode(Scenario scenario) {
        return TESLA_SCENARIO_TYPE.equals(Scenarios.getScenarioType(scenario, ECL_SCENARIO_TYPE));
    }

    public static String getScenarioType(Scenario scenario, String def) {
        String type = scenario.getType();
        if (type != null) {
            return type;
        }
        EObject content = scenario.getContent();
        if (content != null) {
            return content instanceof Script ? ECL_SCENARIO_TYPE : TESLA_SCENARIO_TYPE;
        }
        return def;
    }

    public static boolean setTypeToEcl(Scenario scenario) {
        switch (Scenarios.getScenarioMode(scenario)) {
            case strictTesla: {
                scenario.setTeslaContent(scenario.getContent());
            }
            case tesla: {
                scenario.setType(ECL_SCENARIO_TYPE);
                scenario.setContent(null);
                return true;
            }
        }
        return false;
    }

    public static boolean setTypeToTesla(Scenario scenario, boolean discardUserChanges) {
        ScenarioMode mode = Scenarios.getScenarioMode(scenario);
        switch (mode) {
            case strictEcl: {
                throw new ObsoleteEclFormatException();
            }
            case ecl: {
                if (scenario.getContent() != null && !discardUserChanges) {
                    throw new UserModificationException();
                }
                scenario.setType(TESLA_SCENARIO_TYPE);
                scenario.setContent(null);
                return true;
            }
        }
        return false;
    }

    public static boolean hasUserModifications(Scenario scenario) {
        ScenarioMode mode = Scenarios.getScenarioMode(scenario);
        switch (mode) {
            case strictEcl: {
                return true;
            }
            case ecl: {
                return scenario.getContent() != null;
            }
        }
        return false;
    }

    public static boolean hasObsoleteEclFormat(Scenario scenario) {
        return Scenarios.getScenarioMode(scenario) == ScenarioMode.strictEcl;
    }

    public static boolean hasObsoleteTeslaFormat(Scenario scenario) {
        return Scenarios.getScenarioMode(scenario) == ScenarioMode.strictTesla;
    }

    public static boolean hasTesla(Scenario scenario) {
        if (scenario.getContent() instanceof TeslaScenario) {
            return true;
        }
        return scenario.getTeslaContent() instanceof TeslaScenario;
    }

    public static TeslaScenario getTesla(Scenario scenario) {
        if (scenario.getContent() instanceof TeslaScenario) {
            return (TeslaScenario)scenario.getContent();
        }
        if (scenario.getTeslaContent() instanceof TeslaScenario) {
            return (TeslaScenario)scenario.getTeslaContent();
        }
        return null;
    }

    public static TeslaScenario getTesla(ITestCase scenario) throws ModelException {
        if (scenario.getContent() instanceof TeslaScenario) {
            return (TeslaScenario)scenario.getContent();
        }
        if (scenario.getTesla() instanceof TeslaScenario) {
            return (TeslaScenario)scenario.getTesla();
        }
        return null;
    }

    public static void setTesla(Scenario scenario, TeslaScenario tesla) {
        if (Scenarios.hasObsoleteTeslaFormat(scenario)) {
            scenario.setContent((EObject)tesla);
        } else {
            scenario.setTeslaContent((EObject)tesla);
        }
    }

    public static boolean hasEcl(Scenario scenario) {
        return scenario.getContent() instanceof Script;
    }

    public static boolean isEmpty(ITestCase test) {
        try {
            Boolean value = Q7SearchCore.findIsEmptyByDocument(test);
            if (value != null) {
                return value;
            }
            if (test.getNamedElement() instanceof Scenario) {
                Scenario scenario = (Scenario)test.getNamedElement();
                return Scenarios.isEmpty(scenario);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isEmpty(Scenario scenario) {
        String content;
        Script script = Scenarios.getEcl(scenario);
        return script == null || (content = script.getContent()) == null || content.length() <= 0;
    }

    public static Script getEcl(Scenario scenario) {
        if (scenario.getContent() instanceof Script) {
            return (Script)scenario.getContent();
        }
        TeslaScenario tesla = Scenarios.getTesla(scenario);
        if (tesla == null) {
            return null;
        }
        Script script = CoreFactory.eINSTANCE.createScript();
        script.setContent(new EclRecorder().generateCode(tesla));
        return script;
    }

    public static Script getEcl(ITestCase scenario) throws ModelException {
        if (scenario.getContent() instanceof Script) {
            return (Script)scenario.getContent();
        }
        TeslaScenario tesla = Scenarios.getTesla(scenario);
        if (tesla == null) {
            return null;
        }
        Script script = CoreFactory.eINSTANCE.createScript();
        script.setContent(new EclRecorder().generateCode(tesla));
        return script;
    }

    public static void setEcl(Scenario scenario, Script script) {
        if (Scenarios.isEclMode(scenario)) {
            if (!EcoreUtil.equals((EObject)script, (EObject)scenario.getContent())) {
                scenario.setContent((EObject)script);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setEclContent(Scenario scenario, String content) {
        if (Scenarios.isEclMode(scenario)) {
            String previous = Scenarios.getScriptContent(scenario);
            if (previous != null && previous.equals(content)) {
                return;
            }
        } else {
            Scenarios.setTypeToEcl(scenario);
        }
        if (content == null) {
            scenario.setContent(null);
            return;
        }
        Script script = CoreFactory.eINSTANCE.createScript();
        script.setContent(content);
        scenario.setContent((EObject)script);
    }

    public static void setEclContent(ITestCase scenario, String content) throws ModelException {
        if (content == null || content.length() == 0) {
            scenario.setContent(null);
            return;
        }
        Script script = CoreFactory.eINSTANCE.createScript();
        script.setContent(content);
        scenario.setContent((EObject)script);
    }

    private static ScenarioMode getScenarioMode(Scenario scenario) {
        String type = Scenarios.getScenarioType(scenario, ECL_SCENARIO_TYPE);
        if (ECL_SCENARIO_TYPE.equals(type)) {
            Script script;
            if (scenario.getTeslaContent() == null ? (script = (Script)scenario.getContent()) == null || script.getContent() == null || script.getContent().trim().length() == 0 : scenario.getTeslaContent() == null || scenario.getTeslaContent() instanceof TeslaScenario) {
                return ScenarioMode.ecl;
            }
            return ScenarioMode.strictEcl;
        }
        return scenario.getContent() instanceof TeslaScenario ? ScenarioMode.strictTesla : ScenarioMode.tesla;
    }

    public static String getScriptContent(Scenario scenario) {
        if (Scenarios.isEclMode(scenario) && (Scenarios.hasObsoleteEclFormat(scenario) || Scenarios.hasUserModifications(scenario))) {
            Script script = Scenarios.getEcl(scenario);
            if (script == null) {
                return "";
            }
            return script.getContent();
        }
        TeslaScenario tesla = Scenarios.getTesla(scenario);
        if (tesla == null) {
            return "";
        }
        return new EclRecorder().generateCode(tesla);
    }

    private Scenarios() {
    }

    public static class ObsoleteEclFormatException
    extends RuntimeException {
        private static final long serialVersionUID = 6956202972837349383L;
    }

    private static enum ScenarioMode {
        ecl,
        tesla,
        strictEcl,
        strictTesla;

    }

    public static class ScenarioTypeWatcher
    extends EContentAdapter {
        static final ScenarioTypeWatcher INSTANCE = new ScenarioTypeWatcher();
        private static final EAttribute feature = ScenarioPackage.eINSTANCE.getScenario_Type();

        private ScenarioTypeWatcher() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() == 8) {
                return;
            }
            if (feature.equals(notification.getFeature())) {
                Scenario scenario = (Scenario)notification.getNotifier();
                String value = notification.getNewStringValue();
                if (Scenarios.ECL_SCENARIO_TYPE.equals(value)) {
                    Scenarios.setTypeToEcl(scenario);
                } else if (Scenarios.TESLA_SCENARIO_TYPE.equals(value)) {
                    Scenarios.setTypeToEcl(scenario);
                }
            }
        }
    }

    public static class UserModificationException
    extends RuntimeException {
        private static final long serialVersionUID = 825351484816358064L;
    }
}

