/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;

public final class FileSystemUtil {
    private FileSystemUtil() {
    }

    public static boolean deleteDerivedResources(IResource resource) throws CoreException {
        if (resource == null) {
            return false;
        }
        if (resource.getType() == 2) {
            boolean deleteFolder = resource.isDerived();
            IResource[] members = ((IFolder)resource).members();
            int i = 0;
            int len = members.length;
            while (i < len) {
                deleteFolder &= FileSystemUtil.deleteDerivedResources(members[i]);
                ++i;
            }
            if (deleteFolder) {
                FileSystemUtil.deleteResource(resource);
                return true;
            }
            return false;
        }
        if (resource.getType() == 1) {
            if (resource.isDerived()) {
                FileSystemUtil.deleteResource(resource);
                return true;
            }
            return false;
        }
        return false;
    }

    private static void deleteResource(IResource resource) {
        block2: {
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                if (!resource.exists()) break block2;
                AptPlugin.log(e, "Unable to delete derived resource " + String.valueOf(resource));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mkdirs(File parent) {
        if (parent == null) {
            return;
        }
        Class<FileSystemUtil> clazz = FileSystemUtil.class;
        synchronized (FileSystemUtil.class) {
            if (!parent.exists()) {
                boolean succeed = false;
                int i = 0;
                while (!succeed && i < 5) {
                    succeed = parent.mkdirs();
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void makeDerivedParentFolders(IContainer container) throws CoreException {
        if (container instanceof IFolder && !container.exists()) {
            block3: {
                FileSystemUtil.makeDerivedParentFolders(container.getParent());
                try {
                    ((IFolder)container).create(true, true, null);
                }
                catch (CoreException e) {
                    if (container.exists()) break block3;
                    throw e;
                }
            }
            container.setDerived(true, null);
        }
    }

    public static void saveToDisk(IFile file, byte[] toSave) throws IOException {
        block2: {
            try {
                FileSystemUtil.makeDerivedParentFolders(file.getParent());
                file.write(toSave, true, true, false, null);
            }
            catch (CoreException ce) {
                if (file.exists()) break block2;
                AptPlugin.log(ce, "Could not create generated file");
                throw new IOException(ce.getMessage(), ce);
            }
        }
    }

    public static String getContentsOfIFile(IFile file) throws IOException, CoreException {
        return new String(file.readAllBytes(), StandardCharsets.UTF_8);
    }

    public static String getContentsOfFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static void writeStringToIFile(IFile file, String contents) throws IOException, CoreException {
        byte[] data = contents.getBytes(StandardCharsets.UTF_8);
        try {
            file.write(data, true, false, false, null);
        }
        catch (CoreException e) {
            if (file.exists() && file.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null);
                file.write(data, true, false, false, null);
            }
            throw e;
        }
    }

    public static void writeStringToFile(File file, String contents) throws IOException {
        byte[] data = contents.getBytes(StandardCharsets.UTF_8);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                ((OutputStream)out).write(b);
                ++n2;
            }
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareStreams(InputStream is1, InputStream is2) {
        try {
            int b1 = is1.read();
            while (true) {
                int b2;
                if (b1 == -1) {
                    b2 = is2.read();
                    return -1 == b2;
                }
                b2 = is2.read();
                if (b1 != b2) {
                    return false;
                }
                b1 = is1.read();
            }
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

