/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;

public class ReportRendererManager {
    private List<ReportRenderer> managers = null;
    private static ReportRendererManager instance = null;

    private ReportRendererManager() {
    }

    private synchronized void initialize() {
        IConfigurationElement[] elements;
        if (this.managers != null) {
            return;
        }
        this.managers = new ArrayList<ReportRenderer>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.reporting.reportRenderer");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            try {
                String name = cfg.getAttribute("name");
                String extension = cfg.getAttribute("extension");
                String description = cfg.getAttribute("description");
                String id = cfg.getAttribute("id");
                IReportRenderer provider = (IReportRenderer)cfg.createExecutableExtension("class");
                this.managers.add(new ReportRenderer(name, extension, description, provider, id));
            }
            catch (CoreException e) {
                Q7ReportingPlugin.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    public ReportRenderer[] getExtensions() {
        this.initialize();
        return this.managers.toArray(new ReportRenderer[this.managers.size()]);
    }

    public static synchronized ReportRendererManager getInstance() {
        if (instance == null) {
            instance = new ReportRendererManager();
        }
        return instance;
    }

    public static class ReportRenderer {
        private String name;
        private String description;
        private IReportRenderer renderer;
        private String extension;
        private String id;

        public ReportRenderer(String name, String extension, String description, IReportRenderer renderer, String id) {
            this.name = name;
            this.extension = extension;
            this.description = description;
            this.renderer = renderer;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public IReportRenderer getRenderer() {
            return this.renderer;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getId() {
            return this.id;
        }
    }
}

