/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.animation.BaseAnimationNode;
import com.github.weisj.jsvg.nodes.prototype.Container;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.CharacterDataParser;
import com.github.weisj.jsvg.parser.ParsedDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParsedElement {
    @Nullable
    private final String id;
    @NotNull
    private final ParsedDocument document;
    @Nullable
    private final ParsedElement parent;
    @NotNull
    private final AttributeNode attributeNode;
    @NotNull
    private final SVGNode node;
    @NotNull
    private final @NotNull List<@NotNull ParsedElement> children = new ArrayList<ParsedElement>();
    @NotNull
    private final @NotNull List<@NotNull ParsedElement> indirectChildren = new ArrayList<ParsedElement>();
    @NotNull
    private final @NotNull Map<String, @NotNull List<@NotNull ParsedElement>> animationElements = new HashMap<String, List<ParsedElement>>();
    final CharacterDataParser characterDataParser;
    @NotNull
    private BuildStatus buildStatus = BuildStatus.NOT_BUILT;
    private int outgoingPaths = -1;

    ParsedElement(@Nullable String id, @NotNull ParsedDocument document, @Nullable ParsedElement parent, @NotNull AttributeNode element, @NotNull SVGNode node) {
        this.document = document;
        this.parent = parent;
        this.attributeNode = element;
        this.node = node;
        this.id = id;
        PermittedContent permittedContent = node.getClass().getAnnotation(PermittedContent.class);
        if (permittedContent == null) {
            throw new IllegalStateException("Element <" + node.tagName() + "> doesn't specify permitted content");
        }
        this.characterDataParser = permittedContent.charData() ? new CharacterDataParser() : null;
    }

    public void registerNamedElement(@NotNull String name, @NotNull Object element) {
        this.attributeNode.document().registerNamedElement(name, element);
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @NotNull
    public ParsedDocument document() {
        return this.document;
    }

    @NotNull
    public List<ParsedElement> children() {
        return this.children;
    }

    @NotNull
    public Map<String, List<ParsedElement>> animationElements() {
        return this.animationElements;
    }

    @Nullable
    public ParsedElement parent() {
        return this.parent;
    }

    @NotNull
    public SVGNode node() {
        return this.node;
    }

    @NotNull
    public SVGNode nodeEnsuringBuildStatus(int depth) {
        if (this.buildStatus == BuildStatus.IN_PROGRESS) {
            this.cyclicDependencyDetected();
        } else if (this.buildStatus == BuildStatus.NOT_BUILT) {
            this.build(depth);
        }
        return this.node;
    }

    @NotNull
    public AttributeNode attributeNode() {
        return this.attributeNode;
    }

    void addChild(@NotNull ParsedElement parsedElement) {
        if (Category.hasCategory(parsedElement.node, Category.Animation)) {
            String attributeName = BaseAnimationNode.attributeName(parsedElement.attributeNode());
            this.animationElements.computeIfAbsent(attributeName, k -> new ArrayList()).add(parsedElement);
        }
        this.children.add(parsedElement);
        if (this.node instanceof Container) {
            ((Container)((Object)this.node)).addChild(parsedElement.id, parsedElement.node);
        }
    }

    void addIndirectChild(@NotNull ParsedElement parsedElement) {
        this.indirectChildren.add(parsedElement);
    }

    void build(int depth) {
        if (this.buildStatus == BuildStatus.FINISHED) {
            return;
        }
        if (this.buildStatus == BuildStatus.IN_PROGRESS) {
            this.cyclicDependencyDetected();
            return;
        }
        this.buildStatus = BuildStatus.IN_PROGRESS;
        if (depth >= this.attributeNode.document().loaderContext().documentLimits().maxNestingDepth()) {
            throw new IllegalStateException("Maximum nesting depth reached.");
        }
        this.attributeNode.prepareForNodeBuilding();
        for (ParsedElement child : this.children) {
            child.build(depth + 1);
        }
        this.document().setCurrentNestingDepth(depth);
        this.node.build(this.attributeNode);
        this.buildStatus = BuildStatus.FINISHED;
    }

    int outgoingPaths() {
        if (this.outgoingPaths == -1) {
            this.outgoingPaths = 0;
            for (ParsedElement child : this.children) {
                this.outgoingPaths += child.outgoingPaths();
            }
            for (ParsedElement child : this.indirectChildren) {
                this.outgoingPaths += child.outgoingPaths();
            }
            this.outgoingPaths = Math.max(this.outgoingPaths, 1);
        }
        return this.outgoingPaths;
    }

    public String toString() {
        return "ParsedElement{node=" + this.node + '}';
    }

    private void cyclicDependencyDetected() {
        throw new IllegalStateException("Cyclic dependency involving node '" + this.id + "' detected.");
    }

    private static enum BuildStatus {
        NOT_BUILT,
        IN_PROGRESS,
        FINISHED;

    }
}

