/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static String toSPARQL(Value theValue) {
        StringBuilder aBuffer = RenderUtils.toSPARQL(theValue, new StringBuilder());
        return aBuffer.toString();
    }

    public static StringBuilder toSPARQL(Value value, StringBuilder builder) {
        if (value instanceof IRI) {
            IRI aURI = (IRI)value;
            builder.append("<").append(aURI.toString()).append(">");
        } else if (value instanceof BNode) {
            builder.append("_:").append(((BNode)value).getID());
        } else if (value instanceof Literal) {
            Literal aLit = (Literal)value;
            builder.append("\"\"\"").append(RenderUtils.escape(aLit.getLabel())).append("\"\"\"");
            if (Literals.isLanguageLiteral(aLit)) {
                aLit.getLanguage().ifPresent(lang -> builder.append("@").append((String)lang));
            } else {
                builder.append("^^<").append(aLit.getDatatype().toString()).append(">");
            }
        }
        return builder;
    }

    public static String escape(String theString) {
        theString = theString.replaceAll("\"", "\\\\\"");
        StringBuffer aBuffer = new StringBuffer();
        Matcher aMatcher = Pattern.compile("\\\\([^tnrbf\"'\\\\])").matcher(theString);
        while (aMatcher.find()) {
            aMatcher.appendReplacement(aBuffer, String.format("\\\\\\\\%s", aMatcher.group(1)));
        }
        aMatcher.appendTail(aBuffer);
        return aBuffer.toString();
    }
}

