/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfxml.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;

public class RDFXMLPrettyWriter
extends RDFXMLWriter
implements Closeable,
Flushable {
    private final Stack<Node> nodeStack = new Stack();
    private final Stack<IRI> predicateStack = new Stack();
    private boolean writingEnded;

    public RDFXMLPrettyWriter(OutputStream out) {
        super(out);
    }

    public RDFXMLPrettyWriter(OutputStream out, ParsedIRI baseIRI) {
        super(out, baseIRI);
    }

    public RDFXMLPrettyWriter(Writer out) {
        super(out);
    }

    public RDFXMLPrettyWriter(Writer writer, ParsedIRI baseIRI) {
        super(writer, baseIRI);
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        if (!this.writingEnded) {
            super.endRDF();
            this.writingEnded = true;
        }
    }

    @Override
    protected void writeHeader() throws IOException {
        this.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        super.writeHeader();
    }

    @Override
    public void flush() throws IOException {
        if (this.isWritingStarted()) {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            try {
                this.flushPendingStatements();
            }
            catch (RDFHandlerException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
            this.writer.flush();
        }
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet settings = new HashSet(super.getSupportedSettings());
        settings.add(BasicWriterSettings.INLINE_BLANK_NODES);
        return settings;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isWritingStarted() && !this.writingEnded) {
                this.endRDF();
            }
        }
        catch (RDFHandlerException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        finally {
            this.nodeStack.clear();
            this.predicateStack.clear();
            this.writer.close();
        }
    }

    @Override
    protected void flushPendingStatements() throws IOException, RDFHandlerException {
        if (!this.nodeStack.isEmpty()) {
            this.popStacks(null);
        }
    }

    private void popStacks(Resource newSubject) throws IOException, RDFHandlerException {
        Node nextElement;
        for (int i = 0; i < this.nodeStack.size() - 1; ++i) {
            Node node = (Node)this.nodeStack.get(i);
            if (node.isWritten()) continue;
            if (i > 0) {
                this.writeIndents(i * 2 - 1);
                IRI predicate = (IRI)this.predicateStack.get(i - 1);
                QName predicateQName = new QName(predicate);
                this.writeStartTag(predicateQName.getNamespace(), predicateQName.getLocalName());
                this.writeNewLine();
            }
            this.writeIndents(i * 2);
            this.writeNodeStartTag(node);
            node.setIsWritten(true);
        }
        Node topNode = this.nodeStack.pop();
        if (this.predicateStack.isEmpty()) {
            this.writeIndents(this.nodeStack.size() * 2);
            this.writeNodeEmptyTag(topNode);
            this.writeNewLine();
        } else {
            IRI topPredicate = this.predicateStack.pop();
            QName topPredicateQName = new QName(topPredicate);
            if (!topNode.hasType()) {
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeAbbreviatedPredicate(topPredicate, topNode.getValue());
            } else {
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeStartTag(topPredicateQName.getNamespace(), topPredicateQName.getLocalName());
                this.writeNewLine();
                this.writeIndents(this.nodeStack.size() * 2);
                this.writeNodeEmptyTag(topNode);
                this.writeNewLine();
                this.writeIndents(this.nodeStack.size() * 2 - 1);
                this.writeEndTag(topPredicateQName.getNamespace(), topPredicateQName.getLocalName());
                this.writeNewLine();
            }
        }
        while (!this.nodeStack.isEmpty() && !(nextElement = this.nodeStack.peek()).getValue().equals(newSubject)) {
            this.nodeStack.pop();
            this.writeIndents(this.predicateStack.size() + this.nodeStack.size());
            this.writeNodeEndTag(nextElement);
            if (this.predicateStack.isEmpty()) continue;
            IRI nextPredicate = this.predicateStack.pop();
            QName nextPredicateQName = new QName(nextPredicate);
            this.writeIndents(this.predicateStack.size() + this.nodeStack.size());
            this.writeEndTag(nextPredicateQName.getNamespace(), nextPredicateQName.getLocalName());
            this.writeNewLine();
        }
    }

    @Override
    public void consumeStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!this.nodeStack.isEmpty() && !subj.equals(this.nodeStack.peek().getValue())) {
                this.popStacks(subj);
            }
            if (this.nodeStack.isEmpty()) {
                this.nodeStack.push(new Node(subj));
            }
            Node topSubject = this.nodeStack.peek();
            if (pred.equals(RDF.TYPE) && obj instanceof IRI && !topSubject.hasType() && !topSubject.isWritten()) {
                topSubject.setType((IRI)obj);
            } else {
                if (!this.nodeStack.isEmpty() && pred.equals(this.nodeStack.peek().nextLi())) {
                    pred = RDF.LI;
                    this.nodeStack.peek().incrementNextLi();
                }
                this.predicateStack.push(pred);
                this.nodeStack.push(new Node(obj));
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    private void writeNodeStartOfStartTag(Node node) throws IOException, RDFHandlerException {
        Boolean inlineBlankNodes = this.getWriterConfig().get(BasicWriterSettings.INLINE_BLANK_NODES);
        Value value = node.getValue();
        if (node.hasType()) {
            QName nodeTypeQName = new QName(node.getType());
            this.writeStartOfStartTag(nodeTypeQName.getNamespace(), nodeTypeQName.getLocalName());
        } else {
            this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        if (value instanceof IRI) {
            IRI uri = (IRI)value;
            this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
        } else {
            BNode bNode = (BNode)value;
            if (!inlineBlankNodes.booleanValue()) {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
            }
        }
    }

    private void writeNodeStartTag(Node node) throws IOException, RDFHandlerException {
        this.writeNodeStartOfStartTag(node);
        this.writeEndOfStartTag();
        this.writeNewLine();
    }

    private void writeNodeEndTag(Node node) throws IOException {
        if (node.getType() != null) {
            QName nodeTypeQName = new QName(node.getType());
            this.writeEndTag(nodeTypeQName.getNamespace(), nodeTypeQName.getLocalName());
        } else {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        this.writeNewLine();
    }

    private void writeNodeEmptyTag(Node node) throws IOException, RDFHandlerException {
        this.writeNodeStartOfStartTag(node);
        this.writeEndOfEmptyTag();
    }

    private void writeAbbreviatedPredicate(IRI pred, Value obj) throws IOException, RDFHandlerException {
        QName predQName = new QName(pred);
        this.writeStartOfStartTag(predQName.getNamespace(), predQName.getLocalName());
        if (obj instanceof Resource) {
            Resource objRes = (Resource)obj;
            if (objRes instanceof IRI) {
                IRI uri = (IRI)objRes;
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
            } else {
                BNode bNode = (BNode)objRes;
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
            }
            this.writeEndOfEmptyTag();
        } else if (obj instanceof Literal) {
            boolean isXmlLiteral;
            Literal objLit = (Literal)obj;
            CoreDatatype datatype = objLit.getCoreDatatype();
            boolean bl = isXmlLiteral = datatype == CoreDatatype.RDF.XMLLITERAL;
            if (Literals.isLanguageLiteral(objLit)) {
                this.writeAttribute("xml:lang", objLit.getLanguage().get());
            } else if (isXmlLiteral) {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
            } else {
                this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", objLit.getDatatype().toString());
            }
            this.writeEndOfStartTag();
            if (isXmlLiteral) {
                this.writer.write(objLit.getLabel());
            } else {
                this.writeCharacterData(objLit.getLabel());
            }
            this.writeEndTag(predQName.getNamespace(), predQName.getLocalName());
        }
        this.writeNewLine();
    }

    protected void writeStartTag(String namespace, String localName) throws IOException {
        this.writeStartOfStartTag(namespace, localName);
        this.writeEndOfStartTag();
    }

    protected void writeIndents(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeIndent();
        }
    }

    private static class Node {
        private int nextLiIndex = 1;
        private Resource nextLi;
        private final Value value;
        private IRI type = null;
        private boolean isWritten = false;

        public Node(Value value) {
            this.value = value;
        }

        Resource nextLi() {
            if (this.nextLi == null) {
                this.nextLi = SimpleValueFactory.getInstance().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this.nextLiIndex);
            }
            return this.nextLi;
        }

        public void incrementNextLi() {
            ++this.nextLiIndex;
            this.nextLi = null;
        }

        public Value getValue() {
            return this.value;
        }

        public void setType(IRI type) {
            this.type = type;
        }

        public IRI getType() {
            return this.type;
        }

        public boolean hasType() {
            return this.type != null;
        }

        public void setIsWritten(boolean isWritten) {
            this.isWritten = isWritten;
        }

        public boolean isWritten() {
            return this.isWritten;
        }
    }

    private static class QName {
        private static final Pattern VALID_XML_ELEMENT_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_\\-\\.]*");
        private final String namespace;
        private final String localName;

        public QName(IRI resource) {
            if (!VALID_XML_ELEMENT_NAME.matcher(resource.getLocalName()).matches()) {
                String iriString = resource.getNamespace() + resource.getLocalName();
                int sep = XMLUtil.findURISplitIndex(iriString);
                this.namespace = iriString.substring(0, sep);
                this.localName = iriString.substring(sep);
            } else {
                this.localName = resource.getLocalName();
                this.namespace = resource.getNamespace();
            }
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

