/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class GroupUnionOfSameGraphBranchesTransform
extends BaseTransform {
    private GroupUnionOfSameGraphBranchesTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode n : bgp.getLines()) {
            if (n instanceof IrUnion) {
                out.add(GroupUnionOfSameGraphBranchesTransform.rewriteUnion((IrUnion)n));
                continue;
            }
            IrNode m = n.transformChildren(child -> {
                if (child instanceof IrBGP) {
                    return GroupUnionOfSameGraphBranchesTransform.apply((IrBGP)child);
                }
                return child;
            });
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrNode rewriteUnion(IrUnion u) {
        if (!u.isNewScope()) {
            return u;
        }
        int n = u.getBranches().size();
        HashMap<String, List> byKey = new HashMap<String, List>();
        HashMap<String, Var> keyVar = new HashMap<String, Var>();
        for (int i = 0; i < n; ++i) {
            IrBGP b = u.getBranches().get(i);
            if (b.getLines().size() != 1 || !(b.getLines().get(0) instanceof IrGraph)) continue;
            IrGraph g = (IrGraph)b.getLines().get(0);
            Var v = g.getGraph();
            String key = GroupUnionOfSameGraphBranchesTransform.graphKey(v);
            byKey.computeIfAbsent(key, k -> new ArrayList()).add(i);
            keyVar.putIfAbsent(key, v);
        }
        boolean hasAnyGroup = byKey.values().stream().anyMatch(list -> list.size() >= 2);
        if (!hasAnyGroup) {
            IrUnion u2 = new IrUnion(u.isNewScope());
            for (IrBGP b : u.getBranches()) {
                u2.addBranch(GroupUnionOfSameGraphBranchesTransform.apply(b));
            }
            u2.setNewScope(u.isNewScope());
            return u2;
        }
        HashSet<Integer> consumed = new HashSet<Integer>();
        IrUnion u2 = new IrUnion(u.isNewScope());
        for (int i = 0; i < n; ++i) {
            IrGraph g;
            String key;
            List group;
            if (consumed.contains(i)) continue;
            IrBGP branch = u.getBranches().get(i);
            if (branch.getLines().size() == 1 && branch.getLines().get(0) instanceof IrGraph && (group = (List)byKey.get(key = GroupUnionOfSameGraphBranchesTransform.graphKey((g = (IrGraph)branch.getLines().get(0)).getGraph()))) != null && group.size() >= 2) {
                IrUnion inner = new IrUnion(u.isNewScope());
                Iterator iterator = group.iterator();
                while (iterator.hasNext()) {
                    int idx = (Integer)iterator.next();
                    consumed.add(idx);
                    IrBGP irBGP = u.getBranches().get(idx);
                    IrBGP body = ((IrGraph)irBGP.getLines().get(0)).getWhere();
                    if (irBGP.isNewScope()) {
                        body = new IrBGP(body, true);
                    }
                    inner.addBranch(GroupUnionOfSameGraphBranchesTransform.apply(body));
                }
                IrBGP graphWhere = new IrBGP(false);
                graphWhere.add(inner);
                IrGraph mergedGraph = new IrGraph((Var)keyVar.get(key), graphWhere, g.isNewScope());
                IrBGP newBranch = new IrBGP(false);
                newBranch.add(mergedGraph);
                u2.addBranch(newBranch);
                continue;
            }
            u2.addBranch(GroupUnionOfSameGraphBranchesTransform.apply(branch));
        }
        u2.setNewScope(u.isNewScope());
        if (u2.getBranches().size() == 1) {
            IrBGP only = u2.getBranches().get(0);
            if (only.getLines().size() == 1) {
                return only.getLines().get(0);
            }
            return only;
        }
        return u2;
    }

    private static String graphKey(Var v) {
        if (v == null) {
            return "<null>";
        }
        if (v.hasValue() && v.getValue() != null) {
            return "val:" + v.getValue().stringValue();
        }
        return "var:" + v.getName();
    }
}

