/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.PathTextUtils;

public final class SimplifyPathParensTransform
extends BaseTransform {
    private static final Pattern DOUBLE_WRAP_NPS = Pattern.compile("\\(\\(\\(!\\([^()]*\\)\\)\\)\\)");
    private static final Pattern TRIPLE_WRAP_OPTIONAL = Pattern.compile("\\(\\(\\(([^()]+)\\)\\)\\?\\)\\)");
    private static final Pattern DOUBLE_PARENS_SEGMENT = Pattern.compile("\\(\\(([^()]+)\\)\\)");
    private static final Pattern PARENS_AROUND_SEQ_BEFORE_SLASH = Pattern.compile("\\(([^()|]+/[^()|]+)\\)(?=/)");
    private static final Pattern PARENS_AROUND_ATOMIC = Pattern.compile("\\(([^()|/]+[?+*]?)\\)");
    private static final Pattern COMPACT_NPS_SINGLE_INVERSE = Pattern.compile("!\\(\\s*(\\^\\s*(?:<[^>]+>|[^()|/\\s]+))\\s*\\)");
    private static final Pattern COMPACT_NPS_SINGLE = Pattern.compile("!\\(\\s*((?:<[^>]+>|[^()|/\\s]+))\\s*\\)");
    private static final Pattern COMPACT_PARENED_NEGATED_TOKEN = Pattern.compile("\\((!\\s*(?:<[^>]+>|[^()|/\\s]+))\\)");
    private static final Pattern SIMPLE_ALT_GROUP = Pattern.compile("(?<!!)\\(\\s*([^()]+\\|[^()]+)\\s*\\)");
    private static final Pattern NPS_PARENS_SPACING = Pattern.compile("!\\(\\s*([^()]+?)\\s*\\)");

    private SimplifyPathParensTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)n;
                String ptxt = pt.getPathText();
                String rew = SimplifyPathParensTransform.simplify(ptxt);
                if (!rew.equals(ptxt)) {
                    IrPathTriple np = new IrPathTriple(pt.getSubject(), pt.getSubjectOverride(), rew, pt.getObject(), pt.getObjectOverride(), pt.getPathVars(), pt.isNewScope());
                    m = np;
                }
            } else if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                m = new IrGraph(g.getGraph(), SimplifyPathParensTransform.apply(g.getWhere()), g.isNewScope());
            } else if (n instanceof IrBGP) {
                m = SimplifyPathParensTransform.apply((IrBGP)n);
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(SimplifyPathParensTransform.apply(o.getWhere()), o.isNewScope());
                m = no;
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(SimplifyPathParensTransform.apply(mi.getWhere()), mi.isNewScope());
            } else if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    u2.addBranch(SimplifyPathParensTransform.apply(b));
                }
                m = u2;
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                m = new IrService(s.getServiceRefText(), s.isSilent(), SimplifyPathParensTransform.apply(s.getWhere()), s.isNewScope());
            } else if (n instanceof IrSubSelect) {
                // empty if block
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    public static String simplify(String s) {
        String prev;
        if (s == null) {
            return null;
        }
        String cur = s;
        int guard = 0;
        do {
            prev = cur;
            cur = DOUBLE_WRAP_NPS.matcher(cur).replaceAll("(!$1)");
            cur = TRIPLE_WRAP_OPTIONAL.matcher(cur).replaceAll("(($1)?)");
            cur = DOUBLE_PARENS_SEGMENT.matcher(cur).replaceAll("($1)");
            cur = PARENS_AROUND_SEQ_BEFORE_SLASH.matcher(cur).replaceAll("$1");
            cur = PARENS_AROUND_ATOMIC.matcher(cur).replaceAll("$1");
            cur = COMPACT_NPS_SINGLE_INVERSE.matcher(cur).replaceAll("!$1");
            cur = COMPACT_NPS_SINGLE.matcher(cur).replaceAll("!$1");
            cur = SimplifyPathParensTransform.dedupeParenedAlternations(cur);
            cur = SimplifyPathParensTransform.flattenNestedAlternationGroups(cur);
            cur = COMPACT_PARENED_NEGATED_TOKEN.matcher(cur).replaceAll("$1");
            cur = SimplifyPathParensTransform.normalizeBangAlternationToNps(cur);
            cur = SimplifyPathParensTransform.normalizeParenBangAlternationGroups(cur);
            cur = cur.replaceAll("\\((\\S)", "($1");
            cur = cur.replaceAll("(\\S)\\)", "$1)");
            cur = SimplifyPathParensTransform.groupNegatedMembersInSimpleGroup(cur);
            cur = SIMPLE_ALT_GROUP.matcher(cur).replaceAll("($1)");
        } while (!(cur = NPS_PARENS_SPACING.matcher(cur).replaceAll("!($1)")).equals(prev) && ++guard < 5);
        cur = SimplifyPathParensTransform.unwrapWholeAlternationGroup(cur);
        return cur;
    }

    private static String unwrapWholeAlternationGroup(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        String inner = PathTextUtils.trimSingleOuterParens(t);
        if (Objects.equals(inner, t)) {
            return s;
        }
        List<String> alts = PathTextUtils.splitTopLevel(inner, '|');
        if (alts.size() <= 1) {
            return s;
        }
        List<String> seqCheck = PathTextUtils.splitTopLevel(inner, '/');
        if (seqCheck.size() > 1) {
            return s;
        }
        return inner;
    }

    private static String groupNegatedMembersInSimpleGroup(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int open = s.indexOf(40, i);
            if (open < 0) {
                out.append(s.substring(i));
                break;
            }
            out.append(s, i, open);
            int j = open + 1;
            int depth = 1;
            while (j < s.length() && depth > 0) {
                char c;
                if ((c = s.charAt(j++)) == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                --depth;
            }
            if (depth != 0) {
                out.append(s.substring(open));
                break;
            }
            int close = j - 1;
            String inner = s.substring(open + 1, close);
            if (inner.indexOf(40) >= 0 || inner.indexOf(41) >= 0) {
                out.append('(').append(inner).append(')');
                i = close + 1;
                continue;
            }
            String[] toks = inner.split("\\|");
            StringBuilder rebuilt = new StringBuilder(inner.length());
            StringBuilder neg = new StringBuilder();
            boolean insertedGroup = false;
            for (int k = 0; k < toks.length; ++k) {
                boolean isNeg;
                String tok = toks[k].trim();
                if (tok.isEmpty()) continue;
                boolean bl = isNeg = tok.startsWith("!") && (tok.length() == 1 || tok.charAt(1) != '(');
                if (isNeg) {
                    String member = tok.substring(1).trim();
                    if (neg.length() > 0) {
                        neg.append('|');
                    }
                    neg.append(member);
                    continue;
                }
                if (neg.length() > 0 && !insertedGroup) {
                    if (rebuilt.length() > 0) {
                        rebuilt.append('|');
                    }
                    rebuilt.append("!(").append((CharSequence)neg).append(")");
                    neg.setLength(0);
                    insertedGroup = true;
                }
                if (rebuilt.length() > 0) {
                    rebuilt.append('|');
                }
                rebuilt.append(tok);
            }
            if (neg.length() > 0) {
                if (rebuilt.length() > 0) {
                    rebuilt.append('|');
                }
                rebuilt.append("!(").append((CharSequence)neg).append(")");
            }
            out.append('(').append((CharSequence)rebuilt).append(')');
            i = close + 1;
        }
        return out.toString();
    }

    private static String flattenNestedAlternationGroups(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int open = s.indexOf(40, i);
            if (open < 0) {
                out.append(s.substring(i));
                break;
            }
            out.append(s, i, open);
            int j = open + 1;
            int depth = 1;
            while (j < s.length() && depth > 0) {
                char c;
                if ((c = s.charAt(j++)) == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                --depth;
            }
            if (depth != 0) {
                out.append(s.substring(open));
                break;
            }
            int close = j - 1;
            String inner = s.substring(open + 1, close);
            String innerFlat = SimplifyPathParensTransform.flattenNestedAlternationGroups(inner);
            List<String> parts = PathTextUtils.splitTopLevel(innerFlat, '|');
            if (parts.size() >= 2) {
                ArrayList<String> members = new ArrayList<String>();
                boolean changed = false;
                for (String seg : parts) {
                    String u = seg.trim();
                    String uw = PathTextUtils.trimSingleOuterParens(u);
                    if (uw.indexOf(40) < 0 && uw.indexOf(41) < 0 && uw.indexOf(124) >= 0) {
                        for (String tok : uw.split("\\|")) {
                            String t = tok.trim();
                            if (t.isEmpty()) continue;
                            members.add(t);
                        }
                        changed = true;
                        continue;
                    }
                    members.add(u);
                }
                if (changed) {
                    out.append('(').append(String.join((CharSequence)"|", members)).append(')');
                    i = close + 1;
                    continue;
                }
            }
            out.append('(').append(innerFlat).append(')');
            i = close + 1;
        }
        return out.toString();
    }

    private static String normalizeBangAlternationToNps(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        if (t.isEmpty()) {
            return s;
        }
        String tw = PathTextUtils.trimSingleOuterParens(t);
        List<String> parts = PathTextUtils.splitTopLevel(tw, '|');
        if (parts.size() < 2) {
            return s;
        }
        ArrayList<String> members = new ArrayList<String>();
        for (String seg : parts) {
            String u = seg.trim();
            if (!(u = PathTextUtils.trimSingleOuterParens(u)).startsWith("!")) {
                return s;
            }
            if ((u = u.substring(1).trim()).isEmpty()) {
                return s;
            }
            members.add(u);
        }
        return "!(" + String.join((CharSequence)"|", members) + ")";
    }

    private static String dedupeParenedAlternations(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int open = s.indexOf(40, i);
            if (open < 0) {
                out.append(s.substring(i));
                break;
            }
            out.append(s, i, open);
            int j = open + 1;
            int depth = 1;
            while (j < s.length() && depth > 0) {
                char c;
                if ((c = s.charAt(j++)) == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                --depth;
            }
            if (depth != 0) {
                out.append(s.substring(open));
                break;
            }
            int close = j - 1;
            String inner = s.substring(open + 1, close);
            out.append('(').append(inner).append(')');
            i = close + 1;
        }
        return out.toString();
    }

    private static String normalizeParenBangAlternationGroups(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int open = s.indexOf(40, i);
            if (open < 0) {
                out.append(s.substring(i));
                break;
            }
            out.append(s, i, open);
            int j = open + 1;
            int depth = 1;
            while (j < s.length() && depth > 0) {
                char c;
                if ((c = s.charAt(j++)) == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                --depth;
            }
            if (depth != 0) {
                out.append(s.substring(open));
                break;
            }
            int close = j - 1;
            String inner = s.substring(open + 1, close).trim();
            String normalizedInner = SimplifyPathParensTransform.normalizeParenBangAlternationGroups(inner);
            List<String> segs = PathTextUtils.splitTopLevel(normalizedInner, '|');
            if (segs.size() >= 2) {
                boolean allNeg = true;
                ArrayList<String> members = new ArrayList<String>();
                for (String seg : segs) {
                    String u = seg.trim();
                    if (!(u = PathTextUtils.trimSingleOuterParens(u).trim()).startsWith("!")) {
                        allNeg = false;
                        break;
                    }
                    if ((u = u.substring(1).trim()).isEmpty()) {
                        allNeg = false;
                        break;
                    }
                    members.add(u);
                }
                if (allNeg) {
                    out.append("!(").append(String.join((CharSequence)"|", members)).append(')');
                    i = close + 1;
                    continue;
                }
            }
            out.append('(').append(normalizedInner).append(')');
            i = close + 1;
        }
        return out.toString();
    }
}

