/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;

class NamespaceStore
implements Iterable<SimpleNamespace> {
    private static final String FILE_NAME = "namespaces.dat";
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 110, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private final File file;
    private final Map<String, SimpleNamespace> namespacesMap;
    private volatile boolean contentsChanged;

    public NamespaceStore(File dataDir) throws IOException {
        this.file = new File(dataDir, FILE_NAME);
        this.namespacesMap = new LinkedHashMap<String, SimpleNamespace>(16);
        if (this.file.exists()) {
            this.readNamespacesFromFile();
        } else {
            this.writeNamespacesToFile();
        }
        this.contentsChanged = false;
    }

    public String getNamespace(String prefix) {
        String result = null;
        SimpleNamespace namespace = this.namespacesMap.get(prefix);
        if (namespace != null) {
            result = namespace.getName();
        }
        return result;
    }

    public void setNamespace(String prefix, String name) {
        SimpleNamespace ns = this.namespacesMap.get(prefix);
        if (ns != null) {
            if (!ns.getName().equals(name)) {
                ns.setName(name);
                this.contentsChanged = true;
            }
        } else {
            this.namespacesMap.put(prefix, new SimpleNamespace(prefix, name));
            this.contentsChanged = true;
        }
    }

    public void removeNamespace(String prefix) {
        SimpleNamespace ns = this.namespacesMap.remove(prefix);
        if (ns != null) {
            this.contentsChanged = true;
        }
    }

    @Override
    public Iterator<SimpleNamespace> iterator() {
        return this.namespacesMap.values().iterator();
    }

    public void clear() {
        if (!this.namespacesMap.isEmpty()) {
            this.namespacesMap.clear();
            this.contentsChanged = true;
        }
    }

    public void sync() throws IOException {
        if (this.contentsChanged) {
            this.writeNamespacesToFile();
            this.contentsChanged = false;
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNamespacesToFile() throws IOException {
        File file = this.file;
        synchronized (file) {
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.file));){
                out.write(MAGIC_NUMBER);
                out.writeByte(1);
                for (Namespace namespace : this.namespacesMap.values()) {
                    out.writeUTF(namespace.getName());
                    out.writeUTF(namespace.getPrefix());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNamespacesFromFile() throws IOException {
        File file = this.file;
        synchronized (file) {
            DataInputStream in = new DataInputStream(new FileInputStream(this.file));
            try {
                byte[] magicNumber = IOUtil.readBytes((InputStream)in, (int)MAGIC_NUMBER.length);
                if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
                    throw new IOException("File doesn't contain compatible namespace data");
                }
                byte version = in.readByte();
                if (version > 1) {
                    throw new IOException("Unable to read namespace file; it uses a newer file format");
                }
                if (version != 1) {
                    throw new IOException("Unable to read namespace file; invalid file format version: " + version);
                }
                try {
                    while (true) {
                        String name = in.readUTF();
                        String prefix = in.readUTF();
                        SimpleNamespace ns = new SimpleNamespace(prefix, name);
                        this.namespacesMap.put(prefix, ns);
                    }
                }
                catch (EOFException e) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        NamespaceStore nsStore = new NamespaceStore(new File(args[0]));
        for (Namespace ns : nsStore) {
            System.out.println(ns.getPrefix() + " = " + ns.getName());
        }
    }
}

