/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;

public class LimitIteration<E>
extends IterationWrapper<E> {
    private final long limit;
    private long returnCount;

    public LimitIteration(CloseableIteration<? extends E> iter, long limit) {
        super(iter);
        assert (limit >= 0L);
        this.limit = limit;
        this.returnCount = 0L;
    }

    @Override
    public boolean hasNext() {
        boolean underLimit;
        if (this.isClosed()) {
            return false;
        }
        boolean bl = underLimit = this.returnCount < this.limit;
        if (!underLimit) {
            this.close();
            return false;
        }
        return super.hasNext();
    }

    @Override
    public E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        if (this.returnCount >= this.limit) {
            this.close();
            throw new NoSuchElementException("limit reached");
        }
        ++this.returnCount;
        return super.next();
    }
}

