/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnorderedSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(UnorderedSelect.class);
    private final SailConnection connection;
    private final boolean includeInferredStatements;
    private final Resource subject;
    private final IRI predicate;
    private final Value object;
    private final Resource[] dataGraph;
    private final BiFunction<Statement, Resource[], ValidationTuple> mapper;
    private final Function<Statement, Boolean> filter;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public UnorderedSelect(SailConnection connection, Resource subject, IRI predicate, Value object, Resource[] dataGraph, BiFunction<Statement, Resource[], ValidationTuple> mapper, Function<Statement, Boolean> filter, boolean includeInferredStatements) {
        this.connection = connection;
        assert (this.connection != null);
        this.includeInferredStatements = includeInferredStatements;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.dataGraph = dataGraph;
        this.mapper = mapper;
        this.filter = filter;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends Statement> statements;

            @Override
            protected void init() {
                assert (this.statements == null);
                this.statements = UnorderedSelect.this.filter != null ? new FilterIteration<Statement>(UnorderedSelect.this.connection.getStatements(UnorderedSelect.this.subject, UnorderedSelect.this.predicate, UnorderedSelect.this.object, UnorderedSelect.this.includeInferredStatements, UnorderedSelect.this.dataGraph)){

                    @Override
                    protected boolean accept(Statement st) {
                        return UnorderedSelect.this.filter.apply(st);
                    }

                    @Override
                    protected void handleClose() {
                    }
                } : UnorderedSelect.this.connection.getStatements(UnorderedSelect.this.subject, UnorderedSelect.this.predicate, UnorderedSelect.this.object, UnorderedSelect.this.includeInferredStatements, UnorderedSelect.this.dataGraph);
            }

            @Override
            public void localClose() {
                if (this.statements != null) {
                    this.statements.close();
                }
            }

            @Override
            protected boolean localHasNext() {
                return this.statements.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() {
                return UnorderedSelect.this.mapper.apply((Statement)this.statements.next(), UnorderedSelect.this.dataGraph);
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "UnorderedSelect{subject=" + Formatter.prefix(this.subject) + ", predicate=" + Formatter.prefix(this.predicate) + ", object=" + Formatter.prefix(this.object) + "}";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnorderedSelect that = (UnorderedSelect)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && Objects.equals(this.subject, that.subject) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.object, that.object) && Arrays.equals(this.dataGraph, that.dataGraph) && this.mapper.equals(that.mapper) && Objects.equals(this.filter, that.filter);
        }
        return Objects.equals(this.connection, that.connection) && Objects.equals(this.subject, that.subject) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.object, that.object) && Arrays.equals(this.dataGraph, that.dataGraph) && this.mapper.equals(that.mapper) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(((MemoryStoreConnection)this.connection).getSail(), this.subject, this.predicate, this.object, this.mapper, Arrays.hashCode(this.dataGraph));
        }
        return Objects.hash(this.connection, this.subject, this.predicate, this.object, this.mapper, Arrays.hashCode(this.dataGraph));
    }

    public static class Mapper {

        public static class SubjectObjectPropertyShapeMapper
        implements BiFunction<Statement, Resource[], ValidationTuple> {
            static SubjectObjectPropertyShapeMapper instance = new SubjectObjectPropertyShapeMapper();

            private SubjectObjectPropertyShapeMapper() {
            }

            @Override
            public ValidationTuple apply(Statement s, Resource[] dataGraph) {
                return new ValidationTuple(s.getSubject(), s.getObject(), ConstraintComponent.Scope.propertyShape, true, dataGraph);
            }

            public int hashCode() {
                return 35972357;
            }

            public boolean equals(Object obj) {
                return obj == this;
            }

            public static SubjectObjectPropertyShapeMapper getFunction() {
                return instance;
            }
        }

        public static class ObjectScopedMapper
        implements BiFunction<Statement, Resource[], ValidationTuple> {
            private final ConstraintComponent.Scope scope;
            static ObjectScopedMapper nodeShapeInstance = new ObjectScopedMapper(ConstraintComponent.Scope.nodeShape);
            static ObjectScopedMapper propertyShapeInstance = new ObjectScopedMapper(ConstraintComponent.Scope.propertyShape);
            static ObjectScopedMapper noneInstance = new ObjectScopedMapper(ConstraintComponent.Scope.none);

            private ObjectScopedMapper(ConstraintComponent.Scope scope) {
                this.scope = scope;
            }

            @Override
            public ValidationTuple apply(Statement s, Resource[] dataGraph) {
                return new ValidationTuple(s.getObject(), this.scope, false, dataGraph);
            }

            public int hashCode() {
                return 25482634 + this.scope.hashCode();
            }

            public boolean equals(Object obj) {
                return obj == this;
            }

            public static ObjectScopedMapper getFunction(ConstraintComponent.Scope scope) {
                switch (scope) {
                    case none: {
                        return noneInstance;
                    }
                    case nodeShape: {
                        return nodeShapeInstance;
                    }
                    case propertyShape: {
                        return propertyShapeInstance;
                    }
                }
                throw new IllegalStateException("Unknown scope: " + String.valueOf((Object)scope));
            }
        }

        public static class SubjectScopedMapper
        implements BiFunction<Statement, Resource[], ValidationTuple> {
            private final ConstraintComponent.Scope scope;
            static SubjectScopedMapper nodeShapeInstance = new SubjectScopedMapper(ConstraintComponent.Scope.nodeShape);
            static SubjectScopedMapper propertyShapeInstance = new SubjectScopedMapper(ConstraintComponent.Scope.propertyShape);
            static SubjectScopedMapper noneInstance = new SubjectScopedMapper(ConstraintComponent.Scope.none);

            private SubjectScopedMapper(ConstraintComponent.Scope scope) {
                this.scope = scope;
            }

            @Override
            public ValidationTuple apply(Statement s, Resource[] dataGraph) {
                return new ValidationTuple(s.getSubject(), this.scope, false, dataGraph);
            }

            public int hashCode() {
                return 72706357 + this.scope.hashCode();
            }

            public boolean equals(Object obj) {
                return obj == this;
            }

            public static SubjectScopedMapper getFunction(ConstraintComponent.Scope scope) {
                switch (scope) {
                    case none: {
                        return noneInstance;
                    }
                    case nodeShape: {
                        return nodeShapeInstance;
                    }
                    case propertyShape: {
                        return propertyShapeInstance;
                    }
                }
                throw new IllegalStateException("Unknown scope: " + String.valueOf((Object)scope));
            }
        }
    }
}

