/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.AbstractList;
import java.util.List;

public class ModifiableJsonArray
extends AbstractList<JsonValue>
implements JsonArray {
    private final List<JsonValue> valueList;
    private int hashCode;
    private BloomFilter<Integer> filter;

    public ModifiableJsonArray(List<JsonValue> valueList) {
        this.valueList = valueList;
        if (valueList.size() > 1000) {
            this.filter = BloomFilter.create((Funnel)Funnels.integerFunnel(), (int)5000, (double)0.01);
            for (JsonValue value : valueList) {
                this.filter.put((Object)value.hashCode());
            }
        }
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    public JsonObject getJsonObject(int index) {
        return (JsonObject)this.valueList.get(index);
    }

    public JsonArray getJsonArray(int index) {
        return (JsonArray)this.valueList.get(index);
    }

    public JsonNumber getJsonNumber(int index) {
        return (JsonNumber)this.valueList.get(index);
    }

    public JsonString getJsonString(int index) {
        return (JsonString)this.valueList.get(index);
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.valueList;
    }

    public String getString(int index) {
        return this.getJsonString(index).getString();
    }

    public String getString(int index, String defaultValue) {
        try {
            return this.getString(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(int index) {
        return this.getJsonNumber(index).intValue();
    }

    public int getInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == JsonValue.TRUE) {
            return true;
        }
        if (jsonValue == JsonValue.FALSE) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean isNull(int index) {
        return this.valueList.get(index).equals((Object)JsonValue.NULL);
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public JsonValue get(int index) {
        return this.valueList.get(index);
    }

    @Override
    public boolean add(JsonValue value) {
        if (this.filter != null) {
            this.filter.put((Object)value.hashCode());
        }
        return this.valueList.add(value);
    }

    @Override
    public boolean contains(Object o) {
        JsonValue jsonValue;
        boolean mightContain;
        if (this.valueList.isEmpty()) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (this.filter == null && this.valueList.size() > 100) {
            this.filter = BloomFilter.create((Funnel)Funnels.integerFunnel(), (int)100000, (double)0.01);
            for (JsonValue value : this.valueList) {
                this.filter.put((Object)value.hashCode());
            }
        }
        if (this.filter != null && !(mightContain = this.filter.mightContain((Object)o.hashCode()))) {
            return false;
        }
        int oHashCode = o.hashCode();
        if (this.valueList.size() == 1 && oHashCode == (jsonValue = this.valueList.get(0)).hashCode() && jsonValue.equals(o)) {
            return true;
        }
        for (JsonValue value : this.valueList) {
            if (value.hashCode() != oHashCode || !value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        return "ModifiableJsonArray{valueList=" + String.valueOf(this.valueList) + "}";
    }

    public JsonArray asJsonArray() {
        return this;
    }
}

