/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.outgoing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URLConnection;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.SendFileTransferException;
import org.eclipse.ecf.filetransfer.service.ISendFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.outgoing.AbstractOutgoingFileTransfer;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractUrlConnectionOutgoingFileTransfer
extends AbstractOutgoingFileTransfer
implements ISendFileTransfer {
    private static final int OK_RESPONSE_CODE = 200;
    protected URLConnection urlConnection;
    protected long lastModifiedTime = 0L;
    protected int httpVersion = 1;
    protected int responseCode = -1;
    protected String responseMessage = null;
    private JREProxyHelper proxyHelper = new JREProxyHelper();

    protected abstract void connect() throws IOException;

    protected boolean isConnected() {
        return this.urlConnection != null;
    }

    public int getResponseCode() {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        if (this.isHTTP()) {
            int last;
            String response = this.urlConnection.getHeaderField(0);
            if (response == null) {
                this.responseCode = -1;
                this.httpVersion = 1;
                return this.responseCode;
            }
            if (response == null || !response.startsWith("HTTP/")) {
                return -1;
            }
            response.trim();
            int mark = response.indexOf(" ") + 1;
            if (mark == 0) {
                return -1;
            }
            if (response.charAt(mark - 2) != '1') {
                this.httpVersion = 0;
            }
            if ((last = mark + 3) > response.length()) {
                last = response.length();
            }
            this.responseCode = Integer.parseInt(response.substring(mark, last));
            if (last + 1 <= response.length()) {
                this.responseMessage = response.substring(last + 1);
            }
        } else {
            this.responseCode = 200;
            this.responseMessage = "OK";
        }
        return this.responseCode;
    }

    private boolean isHTTP() {
        String protocol = this.getRemoteFileURL().getProtocol();
        return protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https");
    }

    @Override
    protected void setupProxy(Proxy proxy2) {
        this.proxyHelper.setupProxy(proxy2);
    }

    @Override
    protected void openStreams() throws SendFileTransferException {
        try {
            File localFile = this.getFileTransferInfo().getFile();
            this.setInputStream(new BufferedInputStream(new FileInputStream(localFile)));
            this.connect();
            this.setOutputStream(this.urlConnection.getOutputStream());
        }
        catch (Exception e) {
            throw new SendFileTransferException(NLS.bind((String)Messages.UrlConnectionOutgoingFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)this.getRemoteFileURL().toString()), (Throwable)e);
        }
    }

    @Override
    protected void hardClose() {
        super.hardClose();
        int rCode = this.getResponseCode();
        if (rCode != 200) {
            this.exception = new ProtocolException(NLS.bind((String)"{0} {1}", (Object)rCode, (Object)this.responseMessage));
        }
        this.urlConnection = null;
        if (this.proxyHelper != null) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }
}

