/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import javafx.beans.value.ObservableValue;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class GridBehavior
extends AbstractBehavior {
    @Override
    protected void doActivate() {
        GridModel gridModel = (GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class);
        if (gridModel == null) {
            throw new IllegalStateException("Unable to retrieve GridModel viewer adapter. Please check your adapter bindings.");
        }
        InfiniteCanvas canvas = this.getCanvas();
        canvas.showGridProperty().bind((ObservableValue)gridModel.showGridProperty());
        canvas.zoomGridProperty().bind((ObservableValue)gridModel.zoomGridProperty());
        canvas.gridCellWidthProperty().bind((ObservableValue)gridModel.gridCellWidthProperty());
        canvas.gridCellHeightProperty().bind((ObservableValue)gridModel.gridCellHeightProperty());
    }

    @Override
    protected void doDeactivate() {
        InfiniteCanvas canvas = this.getCanvas();
        canvas.showGridProperty().unbind();
        canvas.zoomGridProperty().unbind();
        canvas.gridCellWidthProperty().unbind();
        canvas.gridCellHeightProperty().unbind();
    }

    protected InfiniteCanvas getCanvas() {
        return ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas();
    }
}

