/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractDebuggerConfiguration
implements IDebuggerConfiguration {
    protected IEclipsePreferences preferences;
    protected IEclipsePreferences defaultPreferences;
    protected static final int INST_PREF = 0;
    protected static final int DEF_PREF = 1;
    private HashMap<String, String> attributes = new HashMap();
    private ICommunicationDaemon communicationDaemon;
    private static final String EMPTY_STRING = "";

    public AbstractDebuggerConfiguration() {
        this.preferences = PHPDebugPlugin.getInstancePreferences();
        this.defaultPreferences = PHPDebugPlugin.getDefaultPreferences();
        Platform.getPreferencesService();
    }

    public void setAttribute(String id, String value) {
        if (EMPTY_STRING.equals(this.defaultPreferences.get(id, EMPTY_STRING))) {
            this.attributes.put(id, value);
        } else {
            this.preferences.put(id, value);
        }
    }

    @Override
    public String getAttribute(String id) {
        String attribute = this.attributes.get(id);
        if (attribute == null) {
            attribute = Platform.getPreferencesService().getString("org.eclipse.php.debug.core", id, null, null);
        }
        return attribute;
    }

    public void setDebuggerId(String id) {
        this.attributes.put("id", id);
    }

    @Override
    public String getDebuggerId() {
        return this.getAttribute("id");
    }

    public void setName(String name) {
        this.attributes.put("name", name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    public abstract void setPort(int var1);

    @Override
    public abstract int getPort();

    public abstract String getModuleId();

    public ICommunicationDaemon getCommunicationDaemon() {
        return this.communicationDaemon;
    }

    public void setCommunicationDaemon(ICommunicationDaemon communicationDaemon) {
        this.communicationDaemon = communicationDaemon;
    }

    @Override
    public void save() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    public abstract void applyDefaults();

    public abstract IStatus validate(PHPexeItem var1);

    protected boolean isInstalled(PHPexeItem exeItem, String extensionId) {
        return PHPExeUtil.hasModule(exeItem, extensionId);
    }
}

