/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.model.reference.StringReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.CheckboxTreeViewerWrapper;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ICheckboxViewerWrapper;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveDecoratingLabelProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.beans.ElPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ElPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ChooseClassAndPropertiesConfiguration;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ElPropertyUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiConfiguration;

public abstract class ChooseClassAndPropertiesUiContentProvider
extends org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesUiContentProvider {
    private CheckboxTreeViewer m_treeViewer;
    private ElPropertyUiContentProvider m_elPropertyUIContentProvider;
    private boolean m_elProperty;
    private final ChooseClassAndPropertiesConfiguration m_configuration;

    public ChooseClassAndPropertiesUiContentProvider(ChooseClassAndPropertiesConfiguration configuration) {
        super((org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassAndPropertiesConfiguration)configuration);
        this.m_configuration = configuration;
    }

    public void createContent(Composite parent, int columns) {
        super.createContent(parent, columns);
        if (this.m_configuration.isWorkWithELProperty()) {
            ElPropertyUiConfiguration configuration = new ElPropertyUiConfiguration();
            configuration.setTitle(Messages.ChooseClassAndPropertiesUiContentProvider_title);
            this.m_elPropertyUIContentProvider = new ElPropertyUiContentProvider(configuration, null);
            this.m_elPropertyUIContentProvider.setCompleteListener(new ICompleteListener(){

                public void calculateFinish() {
                    ChooseClassAndPropertiesUiContentProvider.this.calculateSubFinish();
                }
            });
            this.m_elPropertyUIContentProvider.createContent(parent, columns);
            this.m_treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    ChooseClassAndPropertiesUiContentProvider.this.handleELProperty();
                }
            });
        }
    }

    protected ICheckboxViewerWrapper createPropertiesViewer(Composite parent) {
        this.m_treeViewer = new CheckboxTreeViewer(parent, 68352);
        this.m_treeViewer.setContentProvider((IContentProvider)new PropertyAdapterContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new PropertyAdapterLabelProvider((TreeViewer)this.m_treeViewer));
        return new CheckboxTreeViewerWrapper(this.m_treeViewer);
    }

    protected void calculateFinish() {
        super.calculateFinish();
        if (this.getErrorMessage() == null && this.m_elProperty) {
            this.setErrorMessage(this.m_elPropertyUIContentProvider.getErrorMessage());
        }
    }

    private void calculateSubFinish() {
        if (this.m_elProperty) {
            this.setErrorMessage(this.m_elPropertyUIContentProvider.getErrorMessage());
        }
    }

    private void handleELProperty() {
        try {
            ObservePropertyAdapter adapter;
            Object[] elements = this.m_treeViewer.getCheckedElements();
            if (this.m_elProperty) {
                ObservePropertyAdapter adapter2;
                if (elements.length == 1 && (adapter2 = (ObservePropertyAdapter)((Object)elements[0])).getProperty() instanceof ElPropertyObserveInfo) {
                    this.m_elPropertyUIContentProvider.setProperty((ElPropertyInfo)this.convertAdapterToProperty(new BeanSupport(), this.m_choosenClass, adapter2));
                    return;
                }
                this.m_elProperty = false;
                this.m_elPropertyUIContentProvider.setProperty(null);
            } else if (elements.length == 1 && (adapter = (ObservePropertyAdapter)((Object)elements[0])).getProperty() instanceof ElPropertyObserveInfo) {
                this.m_elProperty = true;
                this.m_elPropertyUIContentProvider.setProperty((ElPropertyInfo)this.convertAdapterToProperty(new BeanSupport(), this.m_choosenClass, adapter));
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    protected List<PropertyAdapter> getProperties(Class<?> choosenClass) throws Exception {
        ArrayList<PropertyAdapter> adapters = new ArrayList<PropertyAdapter>();
        BeanSupport beanSupport = new BeanSupport();
        beanSupport.doAddELProperty(this.m_configuration.isWorkWithELProperty());
        ClassGenericType objectType = new ClassGenericType(choosenClass, null, null);
        for (ObserveInfo property : beanSupport.createProperties(null, objectType)) {
            adapters.add(new ObservePropertyAdapter(null, property));
        }
        return adapters;
    }

    private PropertyInfo convertAdapterToProperty(BeanSupport beanSupport, Class<?> objectClass, ObservePropertyAdapter adapter) throws Exception {
        ClassGenericType objectType = new ClassGenericType(objectClass, null, null);
        SubBeanObserveInfo observe = new SubBeanObserveInfo(beanSupport, null, objectType, StringReferenceProvider.EMPTY);
        return adapter.getProperty().createProperty(observe);
    }

    private ObservePropertyAdapter convertPropertyToAdapter(BeanSupport beanSupport, Class<?> objectClass, PropertyInfo property) throws Exception {
        ClassGenericType objectType = new ClassGenericType(objectClass, null, null);
        ObserveInfo observe = property.getObserveProperty(new SubBeanObserveInfo(beanSupport, null, objectType, StringReferenceProvider.EMPTY));
        Assert.isNotNull((Object)observe);
        return this.convertObserveToAdapter(observe);
    }

    private ObservePropertyAdapter convertObserveToAdapter(ObserveInfo observe) throws Exception {
        if (observe != null) {
            ObservePropertyAdapter adapter = new ObservePropertyAdapter(this.convertObserveToAdapter((ObserveInfo)observe.getParent()), observe);
            adapter.addToParent();
            return adapter;
        }
        return null;
    }

    protected final void setClassNameAndProperty(String className, PropertyInfo property) throws Exception {
        this.setClassName(className);
        if (this.m_configuration.isWorkWithELProperty()) {
            this.m_elProperty = property instanceof ElPropertyInfo;
            this.m_elPropertyUIContentProvider.setProperty(this.m_elProperty ? (ElPropertyInfo)property : null);
        }
        this.setCheckedAdExpand(new Object[]{this.convertPropertyToAdapter(new BeanSupport(), this.loadClass(className), property)});
        this.calculatePropertiesFinish();
    }

    protected final void setClassNameAndProperties0(String className, List<PropertyInfo> properties) throws Exception {
        this.setClassName(className);
        BeanSupport beanSupport = new BeanSupport();
        Class objectClass = this.loadClass(className);
        Object[] adapters = new Object[properties.size()];
        int i = 0;
        while (i < adapters.length) {
            adapters[i] = this.convertPropertyToAdapter(beanSupport, objectClass, properties.get(i));
            ++i;
        }
        this.setCheckedAdExpand(adapters);
        this.calculatePropertiesFinish();
    }

    private void setCheckedAdExpand(Object[] adapters) {
        int i = 0;
        while (i < adapters.length) {
            this.m_treeViewer.expandToLevel(adapters[i], 0);
            ++i;
        }
        this.m_treeViewer.setCheckedElements(adapters);
        if (adapters.length > 0) {
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection(adapters[0]), true);
        }
    }

    protected final void saveToObject(Class<?> choosenClass, List<PropertyAdapter> choosenAdapters) throws Exception {
        BeanSupport beanSupport = new BeanSupport();
        ArrayList<PropertyInfo> choosenProperties = new ArrayList<PropertyInfo>();
        if (this.m_elProperty) {
            this.m_elPropertyUIContentProvider.saveToObject();
            choosenProperties.add(this.m_elPropertyUIContentProvider.getProperty());
        } else {
            for (PropertyAdapter propertyAdapter : choosenAdapters) {
                choosenProperties.add(this.convertAdapterToProperty(beanSupport, choosenClass, (ObservePropertyAdapter)propertyAdapter));
            }
        }
        this.saveToObject0(choosenClass, choosenProperties);
    }

    protected abstract void saveToObject0(Class<?> var1, List<PropertyInfo> var2) throws Exception;

    private static ObservePropertyAdapter getAdapter(Object element) {
        return (ObservePropertyAdapter)((Object)element);
    }

    private static ObserveInfo getAdapterProperty(Object element) {
        return ChooseClassAndPropertiesUiContentProvider.getAdapter(element).getProperty();
    }

    private static class ObservePropertyAdapter
    extends PropertyAdapter {
        private final ObservePropertyAdapter m_parent;
        private final ObserveInfo m_property;
        private List<ObservePropertyAdapter> m_children;

        public ObservePropertyAdapter(ObservePropertyAdapter parent, ObserveInfo property) throws Exception {
            super(property.getPresentation().getText(), property.getObjectClass());
            this.m_parent = parent;
            this.m_property = property;
        }

        public ObservePropertyAdapter getParent() {
            return this.m_parent;
        }

        public ObserveInfo getProperty() {
            return this.m_property;
        }

        public List<ObservePropertyAdapter> getChildren() {
            if (this.m_children == null) {
                this.m_children = new ArrayList<ObservePropertyAdapter>();
                List properties = CoreUtils.cast((List)this.m_property.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
                for (ObserveInfo property : properties) {
                    try {
                        this.m_children.add(new ObservePropertyAdapter(this, property));
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
            }
            return this.m_children;
        }

        public void addToParent() {
            if (this.m_parent != null) {
                this.m_parent.m_children = new ArrayList<ObservePropertyAdapter>();
                this.m_parent.m_children.add(this);
            }
        }

        public int hashCode() {
            int parentHash = this.m_parent == null ? 1 : this.m_parent.hashCode();
            return parentHash * super.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ObservePropertyAdapter) {
                ObservePropertyAdapter adapter = (ObservePropertyAdapter)((Object)object);
                if (this.m_parent != null || adapter.m_parent != null) {
                    if (this.m_parent != null && adapter.m_parent == null || this.m_parent == null && adapter.m_parent != null) {
                        return false;
                    }
                    if (this.m_parent != null && adapter.m_parent != null && !this.m_parent.equals((Object)adapter.m_parent)) {
                        return false;
                    }
                }
                return this.m_name.equals(adapter.m_name) && this.m_type == adapter.m_type;
            }
            return false;
        }
    }

    private static class PropertyAdapterContentProvider
    implements ITreeContentProvider {
        private PropertyAdapterContentProvider() {
        }

        public Object[] getElements(Object input) {
            return ((List)input).toArray();
        }

        public Object getParent(Object element) {
            return ChooseClassAndPropertiesUiContentProvider.getAdapter(element).getParent();
        }

        public boolean hasChildren(Object element) {
            return !ChooseClassAndPropertiesUiContentProvider.getAdapter(element).getChildren().isEmpty();
        }

        public Object[] getChildren(Object element) {
            return ChooseClassAndPropertiesUiContentProvider.getAdapter(element).getChildren().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class PropertyAdapterLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        private final ObserveDecoratingLabelProvider m_labelProvider;
        private final ResourceManager m_resourceManager;

        public PropertyAdapterLabelProvider(TreeViewer viewer) {
            this.m_labelProvider = new ObserveDecoratingLabelProvider((StructuredViewer)viewer);
            this.m_resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }

        public void dispose() {
            super.dispose();
            this.m_labelProvider.dispose();
            this.m_resourceManager.dispose();
        }

        public String getText(Object element) {
            return ChooseClassAndPropertiesUiContentProvider.getAdapter(element).getName();
        }

        public Image getImage(Object element) {
            try {
                return (Image)this.m_resourceManager.create((DeviceResourceDescriptor)ChooseClassAndPropertiesUiContentProvider.getAdapterProperty(element).getPresentation().getImageDescriptor());
            }
            catch (Throwable throwable) {
                return super.getImage(element);
            }
        }

        public Color getForeground(Object element) {
            return this.m_labelProvider.getForeground((Object)ChooseClassAndPropertiesUiContentProvider.getAdapterProperty(element));
        }

        public Color getBackground(Object element) {
            return this.m_labelProvider.getBackground((Object)ChooseClassAndPropertiesUiContentProvider.getAdapterProperty(element));
        }

        public Font getFont(Object element) {
            return this.m_labelProvider.getFont((Object)ChooseClassAndPropertiesUiContentProvider.getAdapterProperty(element));
        }
    }

    private static class SubBeanObserveInfo
    extends BeanObserveInfo {
        public SubBeanObserveInfo(BeanSupport beanSupport, ObserveInfo parent, IGenericType objectType, IReferenceProvider referenceProvider) {
            super(beanSupport, parent, objectType, referenceProvider);
        }

        public IObservePresentation getPresentation() {
            return null;
        }
    }
}

