/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.jface.resource.AbstractContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceRegistryInfo;

public final class RegistryContainerInfo
extends AbstractContainerInfo {
    public static RegistryContainerInfo get(JavaInfo root) throws Exception {
        return RegistryContainerInfo.get(root, new RegistryContainerInfo());
    }

    public static <T extends ResourceRegistryInfo> List<T> getRegistries(JavaInfo root, Class<T> componentClass) throws Exception {
        RegistryContainerInfo container = RegistryContainerInfo.findContainer(root, RegistryContainerInfo.class);
        if (container != null) {
            return container.getChildren(componentClass);
        }
        return Collections.emptyList();
    }

    public static ResourceRegistryInfo getRegistry(JavaInfo root, ASTNode node) throws Exception {
        RegistryContainerInfo container = RegistryContainerInfo.findContainer(root, RegistryContainerInfo.class);
        Assert.isNotNull((Object)((Object)container));
        for (ResourceRegistryInfo registry : container.getChildren(ResourceRegistryInfo.class)) {
            if (!registry.isRepresentedBy(node)) continue;
            return registry;
        }
        Assert.fail((String)MessageFormat.format(ModelMessages.RegistryContainerInfo_unknownRegistry, root, node));
        return null;
    }

    public IObjectPresentation getPresentation() {
        return new DefaultObjectPresentation(this){

            public String getText() throws Exception {
                return ModelMessages.RegistryContainerInfo_jfaceRegistries;
            }

            public ImageDescriptor getIcon() throws Exception {
                return CoreImages.FOLDER_OPEN;
            }
        };
    }
}

