"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
const vue_autoinsert_dotvalue_1 = require("./vue-autoinsert-dotvalue");
function create() {
    return {
        name: 'vue-complete-define-assignment',
        capabilities: {
            completionProvider: {},
        },
        create(context) {
            return {
                isAdditionalCompletion: true,
                async provideCompletionItems(document) {
                    if (!(0, vue_autoinsert_dotvalue_1.isTsDocument)(document)) {
                        return;
                    }
                    const enabled = await context.env.getConfiguration?.('vue.complete.defineAssignment') ?? true;
                    if (!enabled) {
                        return;
                    }
                    const uri = vscode_uri_1.URI.parse(document.uri);
                    const decoded = context.decodeEmbeddedDocumentUri(uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!sourceScript?.generated || !virtualCode) {
                        return;
                    }
                    const root = sourceScript.generated.root;
                    if (!(root instanceof language_core_1.VueVirtualCode)) {
                        return;
                    }
                    const codegen = language_core_1.tsCodegen.get(root._sfc);
                    const scriptSetup = root._sfc.scriptSetup;
                    const scriptSetupRanges = codegen?.scriptSetupRanges.get();
                    if (!scriptSetup || !scriptSetupRanges) {
                        return;
                    }
                    const result = [];
                    const mappings = [...context.language.maps.forEach(virtualCode)];
                    addDefineCompletionItem(scriptSetupRanges.defineProps?.statement, scriptSetupRanges.withDefaults?.exp ?? scriptSetupRanges.defineProps?.exp, 'props');
                    addDefineCompletionItem(scriptSetupRanges.defineEmits?.statement, scriptSetupRanges.defineEmits?.exp, 'emit');
                    addDefineCompletionItem(scriptSetupRanges.defineSlots?.statement, scriptSetupRanges.defineSlots?.exp, 'slots');
                    return {
                        isIncomplete: false,
                        items: result
                    };
                    function addDefineCompletionItem(statement, exp, name) {
                        if (!exp || exp.start !== statement?.start) {
                            return;
                        }
                        let offset;
                        for (const [, map] of mappings) {
                            for (const [generatedOffset] of map.toGeneratedLocation(scriptSetup.startTagEnd + exp.start)) {
                                offset = generatedOffset;
                                break;
                            }
                        }
                        if (offset === undefined) {
                            return;
                        }
                        const pos = document.positionAt(offset);
                        result.push({
                            label: name,
                            kind: 6,
                            commitCharacters: ['.', ',', ';'],
                            additionalTextEdits: [{
                                    newText: `const ${name} = `,
                                    range: {
                                        start: pos,
                                        end: pos
                                    }
                                }]
                        });
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-complete-define-assignment.js.map