/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Grouping;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementSublist;
import org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.OrderingSpecType;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryResultSpecification;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementExpression;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementSublist;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupType;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.emf.common.util.EList;

public class SelectHelper {
    public static void refresh(QuerySelectStatement stmt) {
        QueryExpressionRoot queryExpr;
        if (stmt != null && (queryExpr = stmt.getQueryExpr()) != null) {
            QueryExpressionBody queryBody = queryExpr.getQuery();
            queryExpr.setQuery(queryBody);
            stmt.setQueryExpr(queryExpr);
        }
    }

    public static void refresh(QuerySelect stmt) {
        QueryStatement qStmt = StatementHelper.getQueryStatementForTableReference((TableReference)stmt);
        if (qStmt instanceof QuerySelectStatement) {
            QuerySelectStatement selectstmt = (QuerySelectStatement)qStmt;
            SelectHelper.refresh(selectstmt);
            stmt.setWhereClause(stmt.getWhereClause());
        } else if (qStmt instanceof QueryInsertStatement) {
            QueryInsertStatement insertStmt = (QueryInsertStatement)qStmt;
            QueryExpressionRoot sourceQuery = insertStmt.getSourceQuery();
            if (sourceQuery != null) {
                insertStmt.setSourceQuery(sourceQuery);
            }
        } else if (qStmt instanceof QueryUpdateStatement) {
            stmt.setWhereClause(stmt.getWhereClause());
        }
    }

    public static void refresh(SQLQueryObject stmt) {
        if (stmt instanceof QuerySelect) {
            SelectHelper.refresh((QuerySelect)stmt);
        } else if (stmt instanceof QuerySelectStatement) {
            SelectHelper.refresh((QuerySelectStatement)stmt);
        }
    }

    public static void moveOrderByToPosition(OrderBySpecification orderBy, List orderByList, int position) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{orderBy, orderByList, position});
        }
        if (orderBy != null && position != -1) {
            orderByList.remove(orderBy);
            orderByList.add(position, orderBy);
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addTableToStatementAtPosition(SQLQueryObject stmt, TableExpression tableExpr, int position) {
        EList tableExprList = null;
        if (stmt instanceof QuerySelectStatement) {
            QuerySelect qSelect;
            QueryExpressionRoot queryExpr = ((QuerySelectStatement)stmt).getQueryExpr();
            if (queryExpr != null && (qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)stmt)) != null) {
                tableExprList = qSelect.getFromClause();
            }
        } else if (stmt instanceof QuerySelect) {
            tableExprList = ((QuerySelect)stmt).getFromClause();
        }
        if (tableExprList != null && position <= tableExprList.size()) {
            tableExprList.add(position, tableExpr);
        }
    }

    public static void addTableToStatement(QuerySelectStatement stmt, TableExpression tableExpr) {
        QueryExpressionRoot queryExpr;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{stmt, tableExpr});
        }
        if ((queryExpr = stmt.getQueryExpr()) != null) {
            QuerySelect qSelect = SelectHelper.getQuerySelect(stmt);
            if (qSelect != null) {
                EList tableExprList = qSelect.getFromClause();
                tableExprList.add(tableExpr);
            }
        } else {
            queryExpr = StatementHelper.createQueryExpressionRoot();
            QuerySelect qSelect = StatementHelper.createQuerySelect();
            EList tableExprList = qSelect.getFromClause();
            tableExprList.add(tableExpr);
            queryExpr.setQuery((QueryExpressionBody)qSelect);
            stmt.setQueryExpr(queryExpr);
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)stmt));
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addTableToStatement(QuerySelect qSelect, TableExpression tableExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{qSelect, tableExpr});
        }
        if (qSelect != null) {
            EList tableExprList = qSelect.getFromClause();
            tableExprList.add(tableExpr);
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)qSelect));
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void setChildForQueryCombined(QueryCombined combined, QueryExpressionBody child) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{combined, child});
        }
        if (combined != null && child != null) {
            QueryExpressionBody left = combined.getLeftQuery();
            if (left == null) {
                combined.setLeftQuery(child);
            } else {
                combined.setRightQuery(child);
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static boolean isNodeFull(QueryCombined node) {
        boolean isFull = true;
        if (node != null && (node.getLeftQuery() == null || node.getRightQuery() == null)) {
            isFull = false;
        }
        return isFull;
    }

    public static boolean hasChild(QueryCombined node) {
        boolean hasChild = false;
        if (node != null && (node.getLeftQuery() != null || node.getRightQuery() != null)) {
            hasChild = true;
        }
        return hasChild;
    }

    public static void initSelectStmt(QuerySelectStatement stmt) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{stmt});
        }
        if (stmt != null) {
            QueryExpressionRoot queryExpr = stmt.getQueryExpr();
            if (queryExpr == null) {
                queryExpr = StatementHelper.createQueryExpressionRoot();
            }
            if (queryExpr.getQuery() == null) {
                QuerySelect qSelect = StatementHelper.createQuerySelect();
                queryExpr.setQuery((QueryExpressionBody)qSelect);
                stmt.setQueryExpr(queryExpr);
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static boolean removeTableFromStatement(QuerySelectStatement stmt, TableExpression tableExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{stmt, tableExpr});
        }
        boolean retVal = false;
        QueryExpressionRoot queryExpr = stmt.getQueryExpr();
        if (queryExpr != null) {
            QueryExpressionBody query = queryExpr.getQuery();
            if (query != null) {
                retVal = SelectHelper.removeTableFromQueryExpressionBody(query, tableExpr);
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)stmt));
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    private static boolean removeTableFromQueryExpressionBody(QueryExpressionBody query, TableExpression tableExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{query, tableExpr});
        }
        boolean retVal = false;
        if (query != null) {
            QuerySelect querySelect;
            EList tableExprList;
            if (query instanceof QuerySelect && (tableExprList = (querySelect = (QuerySelect)query).getFromClause()) != null && !tableExprList.isEmpty()) {
                retVal = tableExprList.remove(tableExpr);
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)query));
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static void clearStatementContents(QuerySelectStatement stmt) {
        if (stmt != null) {
            stmt.setQueryExpr(null);
            stmt.getOrderByClause().clear();
            stmt.setSourceInfo(null);
            stmt.setName(null);
            stmt.setLabel(null);
        }
    }

    public static void replaceStatementContents(QuerySelectStatement oldStmt, QuerySelectStatement newStmt) {
        if (oldStmt != null && newStmt != null) {
            QueryExpressionBody qBody;
            oldStmt.setLabel(newStmt.getLabel());
            oldStmt.setName(newStmt.getName());
            oldStmt.setSourceInfo(newStmt.getSourceInfo());
            oldStmt.setQueryExpr(newStmt.getQueryExpr());
            QueryExpressionRoot expr = oldStmt.getQueryExpr();
            if (expr != null && (qBody = expr.getQuery()) instanceof QueryCombined) {
                ((QueryCombined)qBody).setLeftQuery(((QueryCombined)qBody).getLeftQuery());
            }
            oldStmt.getOrderByClause().clear();
            oldStmt.getOrderByClause().addAll((Collection)newStmt.getOrderByClause());
        }
    }

    public static QueryExpressionBody getQueryExpressionBody(QuerySelectStatement stmt) {
        QueryExpressionBody body = null;
        QueryExpressionRoot qRoot = stmt.getQueryExpr();
        if (qRoot != null) {
            body = qRoot.getQuery();
        }
        return body;
    }

    public static QuerySelectStatement getQuerySelectStatement(QueryExpressionBody queryExprBody) {
        QueryExpressionRoot exprRoot;
        QuerySelectStatement statement = null;
        if (queryExprBody != null && (exprRoot = queryExprBody.getQueryExpression()) != null) {
            statement = exprRoot.getSelectStatement();
        }
        return statement;
    }

    public static String getCombinedOperatorStringConstant(String inString) {
        String opString = "";
        if (inString.equals("UNION")) {
            opString = "UNION";
        } else if (inString.equals("UNION ALL")) {
            opString = "UNION_ALL";
        } else if (inString.equals("INTERSECT")) {
            opString = "INTERSECT";
        } else if (inString.equals("INTERSECT ALL")) {
            opString = "INTERSECT_ALL";
        } else if (inString.equals("EXCEPT")) {
            opString = "EXCEPT";
        } else if (inString.equals("EXCEPT ALL")) {
            opString = "EXCEPT_ALL";
        }
        return opString;
    }

    public static String getCombinedOperatorSQLString(String inString) {
        String opString = "";
        if (inString.equals("UNION")) {
            opString = "UNION";
        } else if (inString.equals("UNION_ALL")) {
            opString = "UNION ALL";
        } else if (inString.equals("INTERSECT")) {
            opString = "INTERSECT";
        } else if (inString.equals("INTERSECT_ALL")) {
            opString = "INTERSECT ALL";
        } else if (inString.equals("EXCEPT")) {
            opString = "EXCEPT";
        } else if (inString.equals("EXCEPT_ALL")) {
            opString = "EXCEPT ALL";
        }
        return opString;
    }

    public static QuerySelect getQuerySelect(QuerySelectStatement stmt) {
        QueryExpressionRoot qRoot;
        QuerySelect qSelect = null;
        if (stmt != null && (qRoot = stmt.getQueryExpr()) != null && qRoot.getQuery() instanceof QuerySelect) {
            qSelect = (QuerySelect)qRoot.getQuery();
        }
        return qSelect;
    }

    public static ResultColumn appendResultColumn(SQLQueryObject selectStmt, QueryValueExpression colExpr, String alias) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, colExpr, alias});
        }
        ResultColumn resCol = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        resCol = factory.createResultColumn();
        if (colExpr != null) {
            if (SelectHelper.getOrderByColIndexFromValueExpr(selectStmt, colExpr) >= 0) {
                SelectHelper.removeColumnFromOrderBy(selectStmt, colExpr);
            }
            resCol.setValueExpr(colExpr);
        }
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)new Object[]{selectStmt});
        }
        resCol = SelectHelper.appendResultColumn(selectStmt, resCol, alias);
        return (ResultColumn)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)resCol);
    }

    public static ResultColumn appendResultColumn(SQLQueryObject selectStmt, ResultColumn resCol, String alias) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol, alias});
        }
        if (resCol != null) {
            if (alias != null && alias.trim().length() > 0) {
                resCol.setName(alias);
            }
            QuerySelect qSelect = null;
            if (selectStmt instanceof QuerySelectStatement) {
                qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
            } else if (selectStmt instanceof QuerySelect) {
                qSelect = (QuerySelect)selectStmt;
            }
            if (qSelect != null) {
                EList qColList = qSelect.getSelectClause();
                QueryValueExpression resColValExpr = resCol.getValueExpr();
                if (resColValExpr instanceof ValueExpressionColumn) {
                    ValueExpressionColumn resColValExprCol = (ValueExpressionColumn)resColValExpr;
                    TableExpression resultColTableExpr = resColValExprCol.getTableExpr();
                    Iterator qColListIter = qColList.iterator();
                    while (qColListIter.hasNext()) {
                        ResultTableAllColumns qResultAllCols;
                        TableExpression qResultAllColsTableExpr;
                        QueryResultSpecification qResultSpec = (QueryResultSpecification)qColListIter.next();
                        if (!(qResultSpec instanceof ResultTableAllColumns) || (qResultAllColsTableExpr = (qResultAllCols = (ResultTableAllColumns)qResultSpec).getTableExpr()) != resultColTableExpr) continue;
                        qColListIter.remove();
                    }
                }
                qColList.add(resCol);
            }
        }
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)new Object[]{selectStmt});
        }
        return (ResultColumn)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)resCol);
    }

    public static OrderByValueExpression appendOrderByColumn(QuerySelectStatement selectStmt, QueryValueExpression colExpr, String sortType) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, colExpr, sortType});
        }
        OrderByValueExpression ordValExpr = null;
        if (colExpr != null) {
            int resColIdx = SelectHelper.getOrderByColIndexFromValueExpr((SQLQueryObject)selectStmt, colExpr);
            if (resColIdx < 0) {
                SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
                ordValExpr = factory.createOrderByValueExpression();
                ordValExpr.setValueExpr(colExpr);
                if (sortType.equalsIgnoreCase("ASC")) {
                    ordValExpr.setDescending(false);
                    ordValExpr.setOrderingSpecOption(OrderingSpecType.get((int)1));
                } else {
                    ordValExpr.setDescending(true);
                    ordValExpr.setOrderingSpecOption(OrderingSpecType.get((int)2));
                }
                selectStmt.getOrderByClause().add((Object)ordValExpr);
            } else {
                OrderBySpecification ordSpec = (OrderBySpecification)selectStmt.getOrderByClause().get(resColIdx);
                if (sortType.equalsIgnoreCase("ASC")) {
                    ordSpec.setDescending(false);
                    ordSpec.setOrderingSpecOption(OrderingSpecType.get((int)1));
                } else {
                    ordSpec.setDescending(true);
                    ordSpec.setOrderingSpecOption(OrderingSpecType.get((int)2));
                }
            }
        }
        return (OrderByValueExpression)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(ordValExpr);
    }

    public static OrderByResultColumn appendOrderByColumn(QuerySelectStatement selectStmt, ResultColumn resCol, String alias, String sortType) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol, alias, sortType});
        }
        OrderByResultColumn ordResultCol = null;
        if (resCol != null) {
            int resColIdx = SelectHelper.getOrderByColIndexFromValueExpr((SQLQueryObject)selectStmt, resCol.getValueExpr());
            if (resColIdx < 0) {
                if (alias != null && alias.trim().length() > 0) {
                    resCol.setName(alias);
                }
                SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
                ordResultCol = factory.createOrderByResultColumn();
                ordResultCol.setResultCol(resCol);
                if (sortType.equalsIgnoreCase("ASC")) {
                    ordResultCol.setDescending(false);
                    ordResultCol.setOrderingSpecOption(OrderingSpecType.get((int)1));
                } else {
                    ordResultCol.setDescending(true);
                    ordResultCol.setOrderingSpecOption(OrderingSpecType.get((int)2));
                }
                selectStmt.getOrderByClause().add((Object)ordResultCol);
            } else if (selectStmt.getOrderByClause().get(resColIdx) instanceof OrderByResultColumn) {
                if (alias != null && alias.trim().length() > 0) {
                    resCol.setName(alias);
                }
                ordResultCol = (OrderByResultColumn)selectStmt.getOrderByClause().get(resColIdx);
                ordResultCol.setResultCol(resCol);
                if (sortType.equalsIgnoreCase("ASC")) {
                    ordResultCol.setDescending(false);
                    ordResultCol.setOrderingSpecOption(OrderingSpecType.get((int)1));
                } else {
                    ordResultCol.setDescending(true);
                    ordResultCol.setOrderingSpecOption(OrderingSpecType.get((int)2));
                }
            } else {
                selectStmt.getOrderByClause().remove(resColIdx);
                ordResultCol = SelectHelper.appendOrderByColumn(selectStmt, resCol, alias, sortType);
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
        return ordResultCol;
    }

    public static boolean isResultColumn(SQLQueryObject selectStmt, ResultColumn resCol) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol});
        }
        boolean retVal = false;
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            for (Object col : qColList) {
                ResultColumn currCol;
                if (!(col instanceof ResultColumn) || (currCol = (ResultColumn)col) != resCol) continue;
                retVal = true;
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static boolean isResultColumn(QuerySelect qSelect, ResultColumn resCol) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{qSelect, resCol});
        }
        boolean retVal = false;
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            for (Object col : qColList) {
                ResultColumn currCol;
                if (!(col instanceof ResultColumn) || (currCol = (ResultColumn)col) != resCol) continue;
                retVal = true;
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static boolean isResultColumn(SQLQueryObject selectStmt, ValueExpressionColumn resColExpr) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resColExpr});
        }
        boolean retVal = false;
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && resColExpr != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty() && !qColList.isEmpty()) {
            TableExpression resColTableExpr = ExpressionHelper.getTableExprForValueExpressionColumn(resColExpr);
            for (Object col : qColList) {
                if (!(col instanceof ResultColumn)) continue;
                ResultColumn currCol = (ResultColumn)col;
                if (currCol.getValueExpr() instanceof ValueExpressionColumn) {
                    ValueExpressionColumn currColExpr = (ValueExpressionColumn)currCol.getValueExpr();
                    TableExpression currColTableExpr = ExpressionHelper.getTableExprForValueExpressionColumn(currColExpr);
                    if (resColTableExpr != currColTableExpr || !currColExpr.getName().equalsIgnoreCase(resColExpr.getName())) continue;
                    retVal = true;
                    continue;
                }
                if (currCol.getValueExpr() != resColExpr) continue;
                retVal = true;
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static boolean isResultColumn(QuerySelect qSelect, ValueExpressionColumn resColExpr) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{qSelect, resColExpr});
        }
        boolean retVal = false;
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty() && !qColList.isEmpty()) {
            TableExpression resColTableExpr = ExpressionHelper.getTableExprForValueExpressionColumn(resColExpr);
            for (Object col : qColList) {
                if (!(col instanceof ResultColumn)) continue;
                ResultColumn currCol = (ResultColumn)col;
                if (currCol.getValueExpr() instanceof ValueExpressionColumn) {
                    ValueExpressionColumn currColExpr = (ValueExpressionColumn)currCol.getValueExpr();
                    TableExpression currColTableExpr = ExpressionHelper.getTableExprForValueExpressionColumn(currColExpr);
                    if (resColTableExpr != currColTableExpr || !currColExpr.getName().equalsIgnoreCase(resColExpr.getName())) continue;
                    retVal = true;
                    continue;
                }
                if (currCol.getValueExpr() != resColExpr) continue;
                retVal = true;
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static boolean isSelectStarQuery(QuerySelect querySelect) {
        boolean isSelectStar = false;
        EList selectClauseList = querySelect.getSelectClause();
        isSelectStar = selectClauseList.isEmpty();
        return isSelectStar;
    }

    public static boolean moveColumnInStatement(QuerySelectStatement selectStmt, ResultColumn aResultColumn, int movePosition) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, aResultColumn, movePosition});
        }
        boolean moved = false;
        QuerySelect qSelect = SelectHelper.getQuerySelect(selectStmt);
        if (qSelect != null && aResultColumn != null && movePosition != 0) {
            int columnIndex;
            EList qColList = qSelect.getSelectClause();
            if (qColList != null && !qColList.isEmpty() && (columnIndex = qColList.indexOf(aResultColumn)) > -1 && columnIndex + movePosition >= 0 && columnIndex + movePosition < qColList.size()) {
                QueryValueExpression exp = aResultColumn.getValueExpr();
                SelectHelper.removeColumnFromResultColumns((SQLQueryObject)selectStmt, exp);
                SelectHelper.addResultColumn(selectStmt, aResultColumn, null, columnIndex + movePosition);
                moved = true;
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(moved);
    }

    public static void addResultColumn(QuerySelectStatement selectStmt, ResultColumn aResultColumn, String alias, int index) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, aResultColumn, alias});
        }
        if (aResultColumn != null && index > -1) {
            if (alias != null && alias.trim().length() > 0) {
                aResultColumn.setName(alias);
            }
            QuerySelect qSelect = SelectHelper.getQuerySelect(selectStmt);
            EList qColList = qSelect.getSelectClause();
            qColList.add(index, aResultColumn);
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addOrderByColumn(QuerySelectStatement selectStmt, QueryValueExpression anExpr, String sortType, int position) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, anExpr, sortType});
        }
        OrderByValueExpression ordValExpr = null;
        if (anExpr != null && position > -1) {
            SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
            ordValExpr = factory.createOrderByValueExpression();
            ordValExpr.setValueExpr(anExpr);
            if ("ASC".equalsIgnoreCase(sortType)) {
                ordValExpr.setDescending(false);
                ordValExpr.setOrderingSpecOption(OrderingSpecType.get((int)1));
            } else {
                ordValExpr.setDescending(true);
                ordValExpr.setOrderingSpecOption(OrderingSpecType.get((int)2));
            }
            selectStmt.getOrderByClause().add(position, (Object)ordValExpr);
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static boolean moveOrderByInStatement(QuerySelectStatement selectStmt, OrderBySpecification anExpr, int movePosition) {
        int columnIndex;
        EList orderList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, anExpr, movePosition});
        }
        boolean moved = false;
        if (selectStmt != null && anExpr != null && movePosition != 0 && (orderList = selectStmt.getOrderByClause()) != null && !orderList.isEmpty() && (columnIndex = orderList.indexOf(anExpr)) > -1 && columnIndex + movePosition >= 0 && columnIndex + movePosition < orderList.size()) {
            QueryValueExpression value = ((OrderByValueExpression)anExpr).getValueExpr();
            String sortType = "ASC";
            if (((OrderByValueExpression)anExpr).isDescending()) {
                sortType = "DESC";
            }
            SelectHelper.removeColumnFromOrderBy((SQLQueryObject)selectStmt, value);
            SelectHelper.addOrderByColumn(selectStmt, value, sortType, columnIndex + movePosition);
            moved = true;
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(moved);
    }

    public static void removeColumnFromResultColumns(SQLQueryObject selectStmt, QueryValueExpression sqlExpr) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, sqlExpr});
        }
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            Iterator cols = qColList.iterator();
            while (cols.hasNext()) {
                ResultColumn resCol;
                Object col = cols.next();
                if (!(col instanceof ResultColumn) || (resCol = (ResultColumn)col).getValueExpr() != sqlExpr) continue;
                SelectHelper.removeColumnFromOrderBy(selectStmt, resCol);
                cols.remove();
            }
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void removeColumnFromOrderBy(SQLQueryObject selectStmt, ResultColumn resCol) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol});
        }
        EList ordByColList = new ArrayList();
        QuerySelectStatement sStmt = null;
        if (selectStmt instanceof QuerySelect) {
            QueryStatement qStmt = StatementHelper.getQueryStatementForTableReference((TableReference)((QuerySelect)selectStmt));
            if (qStmt != null && qStmt instanceof QuerySelectStatement) {
                sStmt = (QuerySelectStatement)qStmt;
                ordByColList = sStmt.getOrderByClause();
            }
        } else if (selectStmt != null && selectStmt instanceof QuerySelectStatement) {
            sStmt = (QuerySelectStatement)selectStmt;
            ordByColList = sStmt.getOrderByClause();
        }
        if (ordByColList != null && !ordByColList.isEmpty()) {
            Iterator cols = ordByColList.iterator();
            boolean deleted = false;
            while (cols.hasNext() && !deleted) {
                OrderByResultColumn rstCol;
                Object col = cols.next();
                if (!(col instanceof OrderByResultColumn) || (rstCol = (OrderByResultColumn)col).getResultCol() != resCol) continue;
                cols.remove();
                deleted = true;
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void removeColumnFromOrderBy(SQLQueryObject selectStmt, QueryValueExpression sqlExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, sqlExpr});
        }
        EList ordByColList = new ArrayList();
        QuerySelectStatement sStmt = null;
        if (selectStmt instanceof QuerySelect) {
            QueryStatement qStmt = StatementHelper.getQueryStatementForTableReference((TableReference)((QuerySelect)selectStmt));
            if (qStmt != null && qStmt instanceof QuerySelectStatement) {
                sStmt = (QuerySelectStatement)qStmt;
                ordByColList = sStmt.getOrderByClause();
            }
        } else if (selectStmt != null && selectStmt instanceof QuerySelectStatement) {
            sStmt = (QuerySelectStatement)selectStmt;
            ordByColList = sStmt.getOrderByClause();
        }
        if (ordByColList != null && !ordByColList.isEmpty()) {
            Iterator cols = ordByColList.iterator();
            boolean deleted = false;
            while (cols.hasNext() && !deleted) {
                OrderByResultColumn rstCol;
                Object col = cols.next();
                if (col instanceof OrderByValueExpression) {
                    OrderByValueExpression ordCol = (OrderByValueExpression)col;
                    if (ordCol.getValueExpr() != sqlExpr) continue;
                    ordByColList.remove(col);
                    deleted = true;
                    continue;
                }
                if (!(col instanceof OrderByResultColumn) || (rstCol = (OrderByResultColumn)col).getResultCol().getValueExpr() != sqlExpr) continue;
                ordByColList.remove(col);
                deleted = true;
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static boolean repositionColumnInOrderBy(SQLQueryObject selectStmt, QueryValueExpression sqlExpr, int position) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, sqlExpr});
        }
        EList ordByColList = new ArrayList();
        QuerySelectStatement sStmt = null;
        if (selectStmt instanceof QuerySelect) {
            QueryStatement qStmt = StatementHelper.getQueryStatementForTableReference((TableReference)((QuerySelect)selectStmt));
            if (qStmt != null && qStmt instanceof QuerySelectStatement) {
                sStmt = (QuerySelectStatement)qStmt;
                ordByColList = sStmt.getOrderByClause();
            }
        } else if (selectStmt != null && selectStmt instanceof QuerySelectStatement) {
            sStmt = (QuerySelectStatement)selectStmt;
            ordByColList = sStmt.getOrderByClause();
        }
        boolean moved = false;
        if (ordByColList != null && !ordByColList.isEmpty()) {
            Iterator cols = ordByColList.iterator();
            while (cols.hasNext() && !moved) {
                OrderByResultColumn rstCol;
                Object col = cols.next();
                if (col instanceof OrderByValueExpression) {
                    OrderByValueExpression ordCol = (OrderByValueExpression)col;
                    if (ordCol.getValueExpr() != sqlExpr) continue;
                    ordByColList.remove(ordCol);
                    ordByColList.add(position, ordCol);
                    moved = true;
                    continue;
                }
                if (!(col instanceof OrderByResultColumn) || (rstCol = (OrderByResultColumn)col).getResultCol().getValueExpr() != sqlExpr) continue;
                ordByColList.remove(rstCol);
                ordByColList.add(position, rstCol);
                moved = true;
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
        return moved;
    }

    public static boolean replaceColumnValueExpr(QuerySelectStatement selectStmt, ResultColumn resCol, QueryValueExpression newValExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol, newValExpr});
        }
        boolean retVal = false;
        QuerySelect qSelect = SelectHelper.getQuerySelect(selectStmt);
        EList qColList = qSelect.getSelectClause();
        if (qColList != null && !qColList.isEmpty()) {
            for (Object col : qColList) {
                ResultColumn currCol;
                if (!(col instanceof ResultColumn) || (currCol = (ResultColumn)col) != resCol) continue;
                currCol.setValueExpr(newValExpr);
                retVal = true;
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static boolean replaceColumnValueExpr(SQLQueryObject selectStmt, ResultColumn resCol, QueryValueExpression newValExpr) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol, newValExpr});
        }
        boolean retVal = false;
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            for (Object col : qColList) {
                ResultColumn currCol;
                if (!(col instanceof ResultColumn) || (currCol = (ResultColumn)col) != resCol) continue;
                currCol.setValueExpr(newValExpr);
                retVal = true;
            }
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static boolean replaceColumnValueExprForOrderBy(QuerySelectStatement selectStmt, ResultColumn resCol, QueryValueExpression newValExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, resCol, newValExpr});
        }
        boolean retVal = false;
        EList qColList = selectStmt.getOrderByClause();
        if (qColList != null && !qColList.isEmpty()) {
            for (Object ordCol : qColList) {
                ResultColumn currCol;
                if (ordCol instanceof OrderByValueExpression) {
                    QueryValueExpression valExpr = ((OrderByValueExpression)ordCol).getValueExpr();
                    if (valExpr != resCol.getValueExpr()) continue;
                    ((OrderByValueExpression)ordCol).setValueExpr(newValExpr);
                    retVal = true;
                    continue;
                }
                if (!(ordCol instanceof OrderByResultColumn) || (currCol = ((OrderByResultColumn)ordCol).getResultCol()) != resCol) continue;
                currCol.setValueExpr(newValExpr);
                retVal = true;
            }
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static int getOrderByColIndexFromValueExpr(SQLQueryObject selectStmt, QueryValueExpression searchValExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, searchValExpr});
        }
        int retVal = -1;
        EList qColList = new ArrayList();
        QuerySelectStatement sStmt = null;
        if (selectStmt instanceof QuerySelect) {
            QueryStatement qStmt = StatementHelper.getQueryStatementForTableReference((TableReference)((QuerySelect)selectStmt));
            if (qStmt != null && qStmt instanceof QuerySelectStatement) {
                sStmt = (QuerySelectStatement)qStmt;
                qColList = sStmt.getOrderByClause();
            }
        } else if (selectStmt != null && selectStmt instanceof QuerySelectStatement) {
            sStmt = (QuerySelectStatement)selectStmt;
            qColList = sStmt.getOrderByClause();
        }
        if (qColList != null && !qColList.isEmpty()) {
            Iterator cols = qColList.iterator();
            int currIndex = 0;
            while (cols.hasNext() && retVal < 0) {
                ResultColumn currCol;
                Object ordCol = cols.next();
                if (ordCol instanceof OrderByValueExpression) {
                    QueryValueExpression valExpr = ((OrderByValueExpression)ordCol).getValueExpr();
                    if (valExpr == searchValExpr) {
                        retVal = currIndex;
                    }
                } else if (ordCol instanceof OrderByResultColumn && (currCol = ((OrderByResultColumn)ordCol).getResultCol()) != null && currCol.getValueExpr() == searchValExpr) {
                    retVal = currIndex;
                }
                ++currIndex;
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retVal);
    }

    public static void setResultColumnAlias(ResultColumn resultColumn, String alias) {
        if (alias.trim().length() > 0) {
            resultColumn.setName(alias);
        } else {
            resultColumn.setName(null);
        }
    }

    public static ValueExpressionColumn getSelectColumnFromColumnName(SQLQueryObject selectStmt, String columnName) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, columnName});
        }
        ValueExpressionColumn colExpr = null;
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            for (Object col : qColList) {
                ValueExpressionColumn tmpColExpr;
                ResultColumn currCol;
                if (!(col instanceof ResultColumn) || !((currCol = (ResultColumn)col).getValueExpr() instanceof ValueExpressionColumn) || !(tmpColExpr = (ValueExpressionColumn)currCol.getValueExpr()).getName().equalsIgnoreCase(columnName)) continue;
                colExpr = tmpColExpr;
            }
        }
        return (ValueExpressionColumn)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(colExpr);
    }

    public static void removeAllColumnFromOrderBy(QuerySelectStatement selectStmt, QueryValueExpression sqlExpr) {
        EList ordByColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, sqlExpr});
        }
        if ((ordByColList = selectStmt.getOrderByClause()) != null && !ordByColList.isEmpty()) {
            Iterator cols = ordByColList.iterator();
            boolean deleted = false;
            while (cols.hasNext() && !deleted) {
                ValueExpressionColumn colExpr;
                OrderByResultColumn rstCol;
                Object col = cols.next();
                if (!(col instanceof OrderByResultColumn) || !((rstCol = (OrderByResultColumn)col).getResultCol().getValueExpr() instanceof ValueExpressionColumn) || !(sqlExpr instanceof ValueExpressionColumn) || !(colExpr = (ValueExpressionColumn)rstCol.getResultCol().getValueExpr()).getName().equalsIgnoreCase(sqlExpr.getName()) || ExpressionHelper.getTableExprForValueExpressionColumn(colExpr) != ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)sqlExpr)) continue;
                ordByColList.remove(col);
                deleted = true;
            }
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void removeAllColumnFromResultColumns(SQLQueryObject selectStmt, QueryValueExpression sqlExpr) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, sqlExpr});
        }
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            Iterator cols = qColList.iterator();
            while (cols.hasNext()) {
                ValueExpressionColumn colExpr;
                ResultColumn resCol;
                Object col = cols.next();
                if (!(col instanceof ResultColumn) || !((resCol = (ResultColumn)col).getValueExpr() instanceof ValueExpressionColumn) || !(sqlExpr instanceof ValueExpressionColumn) || !(colExpr = (ValueExpressionColumn)resCol.getValueExpr()).getName().equalsIgnoreCase(sqlExpr.getName()) || ExpressionHelper.getTableExprForValueExpressionColumn(colExpr) != ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)sqlExpr)) continue;
                SelectHelper.removeColumnFromOrderBy(selectStmt, resCol);
                cols.remove();
            }
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void removeColFunctionsForTable(SQLQueryObject selectStmt, TableReference aRef) {
        EList qColList;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{selectStmt, aRef});
        }
        aRef.getName();
        QuerySelect qSelect = null;
        if (selectStmt instanceof QuerySelectStatement) {
            qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)selectStmt);
        } else if (selectStmt instanceof QuerySelect) {
            qSelect = (QuerySelect)selectStmt;
        }
        if (qSelect != null && (qColList = qSelect.getSelectClause()) != null && !qColList.isEmpty()) {
            Iterator cols = qColList.iterator();
            block0: while (cols.hasNext()) {
                ResultColumn resCol;
                Object col = cols.next();
                if (!(col instanceof ResultColumn) || !((resCol = (ResultColumn)col).getValueExpr() instanceof ValueExpressionFunction)) continue;
                ValueExpressionFunction colFunc = (ValueExpressionFunction)resCol.getValueExpr();
                for (Object obj : colFunc.getParameterList()) {
                    ValueExpressionColumn colExpr;
                    if (!(obj instanceof ValueExpressionColumn) || ExpressionHelper.getTableExprForValueExpressionColumn(colExpr = (ValueExpressionColumn)obj) != aRef) continue;
                    SelectHelper.removeColumnFromOrderBy(selectStmt, resCol);
                    cols.remove();
                    continue block0;
                }
            }
            if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)selectStmt));
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static GroupingExpression createGroupingExpression(QueryValueExpression valExpr) {
        GroupingExpression retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createGroupingExpression();
        retExpr.setValueExpr(valExpr);
        return retExpr;
    }

    public static SuperGroup createSuperGroup(int superGroupType) {
        SuperGroup retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createSuperGroup();
        retExpr.setSuperGroupType(SuperGroupType.get((int)superGroupType));
        return retExpr;
    }

    public static SuperGroupElementExpression createSuperGroupElementExpression(QueryValueExpression valExpr) {
        SuperGroupElementExpression retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createSuperGroupElementExpression();
        GroupingExpression grpExpr = SelectHelper.createGroupingExpression(valExpr);
        retExpr.setGroupingExpr(grpExpr);
        return retExpr;
    }

    public static SuperGroupElementSublist createSuperGroupElementSublist() {
        SuperGroupElementSublist retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createSuperGroupElementSublist();
        return retExpr;
    }

    public static GroupingSets createGroupingSets() {
        GroupingSets retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createGroupingSets();
        return retExpr;
    }

    public static GroupingSetsElementExpression createGroupingSetsElementExpression(QueryValueExpression valExpr) {
        GroupingSetsElementExpression retExpr = null;
        retExpr = SelectHelper.createGroupingSetsElementExpression();
        GroupingExpression grpExpr = SelectHelper.createGroupingExpression(valExpr);
        retExpr.setGrouping((Grouping)grpExpr);
        return retExpr;
    }

    public static GroupingSetsElementExpression createGroupingSetsElementExpression() {
        GroupingSetsElementExpression retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createGroupingSetsElementExpression();
        return retExpr;
    }

    public static GroupingSetsElementSublist createGroupingSetsElementSublist() {
        GroupingSetsElementSublist retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createGroupingSetsElementSublist();
        return retExpr;
    }

    public static WithTableSpecification createWithTableSpecification() {
        WithTableSpecification retExpr = null;
        SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
        retExpr = factory.createWithTableSpecification();
        return retExpr;
    }
}

