/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.application;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.PlatformUI;

public class CDOExplorerPerspective
implements IPerspectiveFactory {
    public static final String ID = "org.eclipse.emf.cdo.explorer.CDOExplorerPerspective";
    private static final String CHECKOUT_AREA = "checkoutArea";
    private static final String AUDITING_AREA = "auditingArea";
    private static final String REPOSITORY_AREA = "repositoryArea";
    private static final String PROPERTIES_AREA = "propertiesArea";
    private static final String OUTLINE_AREA = "outlineArea";
    private IPageLayout pageLayout;

    public IPageLayout getPageLayout() {
        return this.pageLayout;
    }

    public void createInitialLayout(IPageLayout pageLayout) {
        this.pageLayout = pageLayout;
        this.addViews();
        this.addPerspectiveShortcuts();
        this.addViewShortcuts();
    }

    protected void addViews() {
        IFolderLayout checkoutArea = this.pageLayout.createFolder(CHECKOUT_AREA, 1, 0.3f, this.pageLayout.getEditorArea());
        checkoutArea.addView("org.eclipse.ui.navigator.ProjectExplorer");
        IFolderLayout repositoryArea = this.pageLayout.createFolder(REPOSITORY_AREA, 4, 0.7f, CHECKOUT_AREA);
        repositoryArea.addView("org.eclipse.emf.cdo.explorer.ui.CDORepositoriesView");
        IFolderLayout propertiesArea = this.pageLayout.createFolder(PROPERTIES_AREA, 4, 0.7f, this.pageLayout.getEditorArea());
        propertiesArea.addView("org.eclipse.ui.views.PropertySheet");
        propertiesArea.addView("org.eclipse.team.ui.GenericHistoryView");
        propertiesArea.addView("org.eclipse.emf.cdo.ui.CDOWatchListView");
        propertiesArea.addView("org.eclipse.emf.cdo.ui.CDORemoteSessionsView");
        IFolderLayout outlineArea = this.pageLayout.createFolder(OUTLINE_AREA, 2, 0.7f, this.pageLayout.getEditorArea());
        outlineArea.addView("org.eclipse.ui.views.ContentOutline");
        IPlaceholderFolderLayout auditingArea = this.pageLayout.createPlaceholderFolder(AUDITING_AREA, 4, 0.84f, this.pageLayout.getEditorArea());
        auditingArea.addPlaceholder("org.eclipse.emf.cdo.ui.CDOTimeMachineView");
    }

    protected void addViewShortcuts() {
        this.pageLayout.addShowViewShortcut("org.eclipse.emf.cdo.ui.CDORemoteSessionsView");
        this.pageLayout.addShowViewShortcut("org.eclipse.emf.cdo.explorer.ui.CDORepositoriesView");
        this.pageLayout.addShowViewShortcut("org.eclipse.emf.cdo.ui.CDOSessionsView");
        this.pageLayout.addShowViewShortcut("org.eclipse.emf.cdo.ui.CDOTimeMachineView");
        this.pageLayout.addShowViewShortcut("org.eclipse.emf.cdo.ui.CDOWatchListView");
        this.pageLayout.addShowViewShortcut("org.eclipse.team.ui.GenericHistoryView");
        this.pageLayout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        this.pageLayout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        this.pageLayout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
    }

    protected void addPerspectiveShortcuts() {
        this.pageLayout.addPerspectiveShortcut(ID);
    }

    public static boolean isCurrent() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals(ID);
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

