/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.impl.AbstractFeature;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AbstractLayoutFeature
extends AbstractFeature
implements ILayoutFeature {
    private static final String NAME = Messages.AbstractLayoutFeature_0_xfld;

    public AbstractLayoutFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public final boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof ILayoutContext) {
            ILayoutContext layoutSemanticsContext = (ILayoutContext)context;
            ret = this.canLayout(layoutSemanticsContext);
        }
        return ret;
    }

    @Override
    public void execute(IContext context) {
        if (context instanceof ILayoutContext) {
            this.layout((ILayoutContext)context);
        }
    }

    protected boolean canLayoutPictogramElement(PictogramElement pe) {
        return this.getFeatureProvider().canLayout(new LayoutContext(pe)).toBoolean();
    }

    protected void resizeShape(Shape shape) {
        ResizeShapeContext resizeShapeContext = new ResizeShapeContext(shape);
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        resizeShapeContext.setWidth(ga.getWidth());
        resizeShapeContext.setHeight(ga.getHeight());
        IResizeShapeFeature resizeShapeFeature = this.getFeatureProvider().getResizeShapeFeature(resizeShapeContext);
        if (resizeShapeFeature != null && resizeShapeFeature.canResizeShape(resizeShapeContext)) {
            resizeShapeFeature.resizeShape(resizeShapeContext);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

