/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModularClassFile;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JEClasspathEntry;
import org.eclipse.jdt.jeview.views.JEJarEntryResource;
import org.eclipse.jdt.jeview.views.JEMemberValuePair;
import org.eclipse.jdt.jeview.views.JEResource;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.jeview.views.Null;
import org.eclipse.jdt.ui.JavaElementLabels;

public class JavaElement
extends JEAttribute {
    private static final long LABEL_OPTIONS = 283710660625569L;
    private final JEAttribute fParent;
    private final String fName;
    private final IJavaElement fJavaElement;

    public JavaElement(JEAttribute parent, String name, IJavaElement element) {
        this.fParent = parent;
        this.fName = name;
        this.fJavaElement = element;
    }

    public JavaElement(JEAttribute parent, IJavaElement element) {
        this(parent, null, element);
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    public IJavaElement getJavaElement() {
        return this.fJavaElement;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaElement other = (JavaElement)obj;
        if (!Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        if (!Objects.equals(this.fName, other.fName)) {
            return false;
        }
        return Objects.equals(this.fJavaElement, other.fJavaElement);
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0) + (this.fJavaElement != null ? this.fJavaElement.hashCode() : 0);
    }

    @Override
    public Object getWrappedObject() {
        return this.fJavaElement;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.fName != null) {
            sb.append(this.fName).append(": ");
        }
        if (this.fJavaElement == null) {
            sb.append("java element: null");
        } else {
            String classname = this.fJavaElement.getClass().getName();
            sb.append(classname.substring(classname.lastIndexOf(46) + 1)).append(": ");
            sb.append(JavaElementLabels.getElementLabel((IJavaElement)this.fJavaElement, (long)283710660625569L));
            if (!this.fJavaElement.exists()) {
                sb.append(" (does not exist)");
            }
        }
        return sb.toString();
    }

    @Override
    public JEAttribute[] getChildren() {
        if (this.fJavaElement == null) {
            return EMPTY;
        }
        ArrayList<JEAttribute> result = new ArrayList<JEAttribute>();
        if (this.fJavaElement instanceof IParent) {
            this.addParentChildren(result, (IParent)this.fJavaElement);
        }
        this.addJavaElementChildren(result, this.fJavaElement);
        if (this.fJavaElement instanceof IJavaModel) {
            this.addJavaModelChildren(result, (IJavaModel)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IJavaProject) {
            this.addJavaProjectChildren(result, (IJavaProject)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IPackageFragmentRoot) {
            this.addPackageFragmentRootChildren(result, (IPackageFragmentRoot)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IPackageFragment) {
            this.addPackageFragmentChildren(result, (IPackageFragment)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ITypeRoot) {
            this.addTypeRootChildren(result, (ITypeRoot)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IOrdinaryClassFile) {
            this.addClassFileChildren(result, (IOrdinaryClassFile)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IModularClassFile) {
            this.addModularClassFileChildren(result, (IModularClassFile)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ICompilationUnit) {
            this.addCompilationUnitChildren(result, (ICompilationUnit)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IType) {
            this.addTypeChildren(result, (IType)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IMethod) {
            this.addMethodChildren(result, (IMethod)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IMember) {
            this.addMemberChildren(result, (IMember)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ITypeParameter) {
            this.addTypeParameterChildren(result, (ITypeParameter)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ILocalVariable) {
            this.addLocalVariableChildren(result, (ILocalVariable)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IAnnotation) {
            this.addAnnotationChildren(result, (IAnnotation)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IAnnotatable) {
            this.addAnnotatableChildren(result, (IAnnotatable)this.fJavaElement);
        }
        return result.toArray(new JEAttribute[result.size()]);
    }

    private void addParentChildren(ArrayList<JEAttribute> result, final IParent parent) {
        result.add(new JavaElementChildrenProperty(this, "CHILDREN"){

            @Override
            public JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, parent.getChildren());
            }
        });
    }

    private void addJavaElementChildren(ArrayList<JEAttribute> result, IJavaElement javaElement) {
        result.add(new JavaElement(this, "PARENT", javaElement.getParent()));
        result.add(new JavaElement(this, "PRIMARY ELEMENT", javaElement.getPrimaryElement()));
        result.add(new JavaElement(this, "JAVA MODEL", (IJavaElement)javaElement.getJavaModel()));
        result.add(new JavaElement(this, "JAVA PROJECT", (IJavaElement)javaElement.getJavaProject()));
        result.add(JEResource.create(this, "RESOURCE", javaElement.getResource()));
        result.add(JEResource.compute(this, "CORRESPONDING RESOURCE", () -> javaElement.getCorrespondingResource()));
        result.add(JEResource.compute(this, "UNDERLYING RESOURCE", () -> javaElement.getUnderlyingResource()));
    }

    private void addJavaModelChildren(ArrayList<JEAttribute> result, final IJavaModel javaModel) {
        result.add(new JavaElementChildrenProperty(this, "JAVA PROJECTS"){

            @Override
            public JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])javaModel.getJavaProjects());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            @Override
            public JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, javaModel.getNonJavaResources());
            }
        });
    }

    private void addJavaProjectChildren(ArrayList<JEAttribute> result, final IJavaProject project) {
        result.add(new JavaElementChildrenProperty(this, "ALL PACKAGE FRAGMENT ROOTS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])project.getAllPackageFragmentRoots());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PACKAGE FRAGMENT ROOTS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])project.getPackageFragmentRoots());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PACKAGE FRAGMENTS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])project.getPackageFragments());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, project.getNonJavaResources());
            }
        });
        result.add(JEResource.create(this, "PROJECT", (IResource)project.getProject()));
        result.add(new JavaElementChildrenProperty(this, "REQUIRED PROJECT NAMES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, project.getRequiredProjectNames());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "OPTIONS(FALSE)"){

            @Override
            protected JEAttribute[] computeChildren() {
                return JavaElement.createOptions(this, project.getOptions(false));
            }
        });
        result.add(new JavaElementChildrenProperty(this, "OPTIONS(TRUE)"){

            @Override
            protected JEAttribute[] computeChildren() {
                return JavaElement.createOptions(this, project.getOptions(true));
            }
        });
        result.add(new JavaElementChildrenProperty(this, "RAW CLASSPATH"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createCPEntries(this, project.getRawClasspath());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "REFERENCED CLASSPATH ENTRIES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createCPEntries(this, project.getReferencedClasspathEntries());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "RESOLVED CLASSPATH"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createCPEntries(this, project.getResolvedClasspath(false));
            }
        });
    }

    private void addPackageFragmentRootChildren(ArrayList<JEAttribute> result, final IPackageFragmentRoot packageFragmentRoot) {
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, packageFragmentRoot.getNonJavaResources());
            }
        });
        result.add(JEClasspathEntry.compute(this, "RAW CLASSPATH ENTRY", () -> packageFragmentRoot.getRawClasspathEntry()));
        result.add(JEClasspathEntry.compute(this, "RESOLVED CLASSPATH ENTRY", () -> packageFragmentRoot.getResolvedClasspathEntry()));
    }

    private void addPackageFragmentChildren(ArrayList<JEAttribute> result, final IPackageFragment packageFragment) {
        result.add(new JavaElementChildrenProperty(this, "COMPILATION UNITS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])packageFragment.getCompilationUnits());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "CLASS FILES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])packageFragment.getAllClassFiles());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, packageFragment.getNonJavaResources());
            }
        });
    }

    private void addTypeRootChildren(ArrayList<JEAttribute> result, ITypeRoot typeRoot) {
        result.add(JavaElement.compute(this, "FIND PRIMARY TYPE", () -> typeRoot.findPrimaryType()));
    }

    private void addClassFileChildren(ArrayList<JEAttribute> result, IOrdinaryClassFile classFile) {
        result.add(JavaElement.compute(this, "TYPE", () -> classFile.getType()));
    }

    private void addModularClassFileChildren(ArrayList<JEAttribute> result, IModularClassFile classFile) {
        result.add(JavaElement.compute(this, "MODULE", () -> classFile.getModule()));
    }

    private void addCompilationUnitChildren(ArrayList<JEAttribute> result, final ICompilationUnit compilationUnit) {
        result.add(new JavaElement(this, "PRIMARY", (IJavaElement)compilationUnit.getPrimary()));
        result.add(new JavaElementChildrenProperty(this, "TYPES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getTypes());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "ALL TYPES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getAllTypes());
            }
        });
        result.add(new JavaElement(this, "IMPORT CONTAINER", (IJavaElement)compilationUnit.getImportContainer()));
        result.add(new JavaElementChildrenProperty(this, "IMPORTS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getImports());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PACKAGE DECLARATIONS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getPackageDeclarations());
            }
        });
    }

    private void addMemberChildren(ArrayList<JEAttribute> result, final IMember member) {
        result.add(new JavaElement(this, "CLASS FILE", (IJavaElement)member.getClassFile()));
        result.add(new JavaElement(this, "COMPILATION UNIT", (IJavaElement)member.getCompilationUnit()));
        result.add(new JavaElement(this, "TYPE ROOT", (IJavaElement)member.getTypeRoot()));
        result.add(new JavaElement(this, "DECLARING TYPE", (IJavaElement)member.getDeclaringType()));
        result.add(new JavaElementChildrenProperty(this, "CATEGORIES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, member.getCategories());
            }
        });
    }

    private void addAnnotationChildren(ArrayList<JEAttribute> result, final IAnnotation annotation) {
        result.add(new JavaElementChildrenProperty(this, "MEMBER VALUE PAIRS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
                return JavaElement.createMemberValuePairs(this, memberValuePairs);
            }
        });
    }

    private void addAnnotatableChildren(ArrayList<JEAttribute> result, final IAnnotatable annotatable) {
        result.add(new JavaElementChildrenProperty(this, "ANNOTATIONS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                IAnnotation[] annotations = annotatable.getAnnotations();
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])annotations);
            }
        });
    }

    private void addTypeChildren(ArrayList<JEAttribute> result, final IType type) {
        result.add(new JavaElementProperty(this, "IS RESOLVED", type.isResolved()));
        result.add(new JavaElementProperty(this, "KEY", type.getKey()));
        result.add(new JavaElement(this, "PACKAGE FRAGMENT", (IJavaElement)type.getPackageFragment()));
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETERS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getTypeParameters());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETER SIGNATURES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, type.getTypeParameterSignatures());
            }
        });
        result.add(new JavaElementProperty(this, "SUPERCLASS NAME"){

            @Override
            protected Object computeValue() throws Exception {
                return type.getSuperclassName();
            }
        });
        result.add(new JavaElementProperty(this, "SUPERCLASS TYPE SIGNATURE"){

            @Override
            protected Object computeValue() throws Exception {
                return type.getSuperclassTypeSignature();
            }
        });
        result.add(new JavaElementChildrenProperty(this, "SUPER INTERFACE NAMES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, type.getSuperInterfaceNames());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "SUPER INTERFACE TYPE SIGNATURES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, type.getSuperInterfaceTypeSignatures());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "FIELDS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getFields());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "INITIALIZERS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getInitializers());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "METHODS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getMethods());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getTypes());
            }
        });
    }

    private void addMethodChildren(ArrayList<JEAttribute> result, final IMethod method) {
        result.add(new JavaElementChildrenProperty(this, "EXCEPTION TYPES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getExceptionTypes());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PARAMETERS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])method.getParameters());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PARAMETER NAMES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getParameterNames());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PARAMETER TYPES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getParameterTypes());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETERS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])method.getTypeParameters());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETER SIGNATURES"){

            @Override
            @Deprecated
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getTypeParameterSignatures());
            }
        });
        try {
            result.add(new JEMemberValuePair(this, "DEFAULT_VALUE", method.getDefaultValue()));
        }
        catch (JavaModelException e) {
            result.add(new Error(this, "DEFAULT_VALUE", (Exception)((Object)e)));
        }
    }

    private void addTypeParameterChildren(ArrayList<JEAttribute> result, final ITypeParameter typeParameter) {
        result.add(new JavaElement(this, "TYPE ROOT", (IJavaElement)typeParameter.getTypeRoot()));
        result.add(new JavaElement(this, "DECLARING MEMBER", (IJavaElement)typeParameter.getDeclaringMember()));
        result.add(new JavaElementChildrenProperty(this, "BOUNDS"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, typeParameter.getBounds());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "BOUNDS SIGNATURES"){

            @Override
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, typeParameter.getBoundsSignatures());
            }
        });
    }

    private void addLocalVariableChildren(ArrayList<JEAttribute> result, ILocalVariable localVariable) {
        result.add(new JavaElement(this, "TYPE ROOT", (IJavaElement)localVariable.getTypeRoot()));
        result.add(new JavaElement(this, "DECLARING MEMBER", (IJavaElement)localVariable.getDeclaringMember()));
    }

    static JavaElement[] createJavaElements(JEAttribute parent, Object[] javaElements) {
        JavaElement[] jeChildren = new JavaElement[javaElements.length];
        int i = 0;
        while (i < javaElements.length) {
            jeChildren[i] = new JavaElement(parent, (IJavaElement)javaElements[i]);
            ++i;
        }
        return jeChildren;
    }

    static JavaElement[] createJavaElements(JEAttribute parent, IJavaElement[] javaElements) {
        JavaElement[] jeChildren = new JavaElement[javaElements.length];
        int i = 0;
        while (i < javaElements.length) {
            jeChildren[i] = new JavaElement(parent, javaElements[i]);
            ++i;
        }
        return jeChildren;
    }

    static JEAttribute[] createResources(JEAttribute parent, Object[] resources) {
        JEAttribute[] resourceChildren = new JEAttribute[resources.length];
        int i = 0;
        while (i < resources.length) {
            Object resource = resources[i];
            resourceChildren[i] = resource instanceof IResource ? new JEResource(parent, null, (IResource)resource) : (resource instanceof IJarEntryResource ? new JEJarEntryResource(parent, null, (IJarEntryResource)resource) : new JavaElementProperty(parent, null, resource));
            ++i;
        }
        return resourceChildren;
    }

    static JEAttribute[] createMemberValuePairs(JEAttribute parent, IMemberValuePair[] mvPairs) {
        JEAttribute[] mvPairChildren = new JEAttribute[mvPairs.length];
        int i = 0;
        while (i < mvPairs.length) {
            IMemberValuePair mvPair = mvPairs[i];
            mvPairChildren[i] = new JEMemberValuePair(parent, mvPair);
            ++i;
        }
        return mvPairChildren;
    }

    static JEAttribute[] createCPEntries(JEAttribute parent, IClasspathEntry[] entries) {
        JEAttribute[] entryChildren = new JEAttribute[entries.length];
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            entryChildren[i] = new JEClasspathEntry(parent, null, entry);
            ++i;
        }
        return entryChildren;
    }

    static JEAttribute[] createOptions(JEAttribute parent, Map<String, String> options) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(options.entrySet());
        Collections.sort(entries, Comparator.comparing(Map.Entry::getKey));
        JEAttribute[] children = new JEAttribute[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            Map.Entry<String, String> entry = entries.get(i);
            children[i] = new JavaElementProperty(parent, entry.getKey(), entry.getValue());
            ++i;
        }
        return children;
    }

    static JEAttribute[] createStrings(JEAttribute parent, String[] strings) {
        JEAttribute[] children = new JEAttribute[strings.length];
        int i = 0;
        while (i < strings.length) {
            children[i] = new JavaElementProperty(parent, null, strings[i]);
            ++i;
        }
        return children;
    }

    public static JEAttribute compute(JEAttribute parent, String name, Callable<IJavaElement> computer) {
        try {
            IJavaElement javaElement = computer.call();
            return JavaElement.create(parent, name, javaElement);
        }
        catch (Exception e) {
            return new Error(parent, name, e);
        }
    }

    public static JEAttribute create(JEAttribute parent, String name, IJavaElement javaElement) {
        if (javaElement == null) {
            return new Null(parent, name);
        }
        return new JavaElement(parent, name, javaElement);
    }
}

