/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.target;

import java.util.ArrayList;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesViewComparator;
import org.eclipse.pde.internal.ui.views.target.StateViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.osgi.framework.Version;

public class StateTree
extends FilteredTree {
    public StateTree(Composite parent) {
        super(parent, 774, new PatternFilter(), true);
        TreeViewer fTreeViewer = this.getViewer();
        fTreeViewer.setContentProvider((IContentProvider)new StateContentProvider());
        fTreeViewer.setLabelProvider((IBaseLabelProvider)new StateLabelProvider());
        fTreeViewer.setComparator((ViewerComparator)DependenciesViewComparator.getViewerComparator());
        fTreeViewer.addDoubleClickListener(event -> this.handleDoubleClick());
    }

    protected void createControl(Composite parent, int treeStyle) {
        super.createControl(parent, treeStyle);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        if (this.showFilterControls) {
            FormData filterData = new FormData();
            filterData.top = new FormAttachment(0, 2);
            filterData.left = new FormAttachment(0, 2);
            filterData.right = new FormAttachment(100, -2);
            this.filterComposite.setLayoutData((Object)filterData);
            data.top = new FormAttachment((Control)this.filterComposite, 2);
        } else {
            data.top = new FormAttachment(0, 0);
        }
        this.treeComposite.setLayoutData((Object)data);
    }

    private static boolean isJREPackage(ExportPackageDescription supplier) {
        return (Integer)supplier.getDirective("x-equinox-ee") > 0;
    }

    protected void handleDoubleClick() {
        BundleDescription desc;
        ITreeSelection selection = this.getViewer().getStructuredSelection();
        if (selection.size() == 1 && (desc = this.getBundleDescription()) != null) {
            ManifestEditor.open(desc, false);
        }
    }

    public BundleDescription getBundleDescription() {
        ITreeSelection selection = this.getViewer().getStructuredSelection();
        if (selection.size() == 1) {
            Object obj = selection.getFirstElement();
            if (obj instanceof BundleSpecification) {
                obj = ((BundleSpecification)obj).getSupplier();
            } else if (obj instanceof ImportPackageSpecification) {
                obj = ((ImportPackageSpecification)obj).getSupplier().getSupplier();
            }
            if (obj instanceof BundleDescription) {
                return (BundleDescription)obj;
            }
        }
        return null;
    }

    public void setInput(State state) {
        TreeViewer viewer = this.getViewer();
        if (viewer.getControl().isDisposed()) {
            return;
        }
        viewer.setInput((Object)state);
    }

    private static class StateContentProvider
    implements ITreeContentProvider {
        private StateContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BundleDescription) {
                BundleDescription desc = (BundleDescription)parentElement;
                if (desc.isResolved()) {
                    Object[] required = this.getResolvedDependencies((VersionConstraint[])desc.getRequiredBundles());
                    Object[] imported = this.getResolvedDependencies((VersionConstraint[])desc.getImportPackages());
                    ArrayList<StateViewPage.DependencyGroup> list = new ArrayList<StateViewPage.DependencyGroup>(2);
                    if (required.length > 0) {
                        list.add(new StateViewPage.DependencyGroup(required));
                    }
                    if (imported.length > 0) {
                        list.add(new StateViewPage.DependencyGroup(imported));
                    }
                    return list.toArray();
                }
                return desc.getContainingState().getResolverErrors(desc);
            }
            if (parentElement instanceof StateViewPage.DependencyGroup) {
                return ((StateViewPage.DependencyGroup)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof State) {
                return ((State)inputElement).getBundles();
            }
            return new Object[0];
        }

        private Object[] getResolvedDependencies(VersionConstraint[] constraints) {
            ArrayList<VersionConstraint> list = new ArrayList<VersionConstraint>(constraints.length);
            VersionConstraint[] versionConstraintArray = constraints;
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                VersionConstraint constraint = versionConstraintArray[n2];
                if (constraint.isResolved()) {
                    list.add(constraint);
                }
                ++n2;
            }
            return list.toArray();
        }
    }

    private static class StateLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private final PDELabelProvider fSharedProvider = PDEPlugin.getDefault().getLabelProvider();

        public StateLabelProvider() {
            this.fSharedProvider.connect((Object)this);
        }

        public void dispose() {
            this.fSharedProvider.disconnect((Object)this);
            super.dispose();
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styledString = new StyledString();
            if (element instanceof ImportPackageSpecification) {
                ImportPackageSpecification spec = (ImportPackageSpecification)element;
                styledString.append(spec.getName());
                ExportPackageDescription supplier = (ExportPackageDescription)spec.getSupplier();
                if (StateTree.isJREPackage(supplier)) {
                    styledString.append(PDEUIMessages.StateViewPage_suppliedByJRE);
                } else {
                    styledString.append(PDEUIMessages.StateViewPage_suppliedBy);
                    this.getElementString(supplier.getSupplier(), styledString, false);
                }
            } else {
                this.getElementString(element, styledString, true);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(element));
            super.update(cell);
        }

        private void getElementString(Object element, StyledString styledString, boolean showLocation) {
            if (element instanceof BundleSpecification) {
                styledString.append(((BundleSpecification)element).getSupplier().toString());
            } else if (element instanceof BundleDescription) {
                BundleDescription description = (BundleDescription)element;
                styledString.append(this.fSharedProvider.getObjectText(description));
                Version version = description.getVersion();
                styledString.append(' ').append(PDELabelProvider.formatVersion(version.toString())).toString();
                if (showLocation && description.getLocation() != null) {
                    styledString.append(" - " + description.getLocation(), StyledString.DECORATIONS_STYLER);
                }
            } else {
                styledString.append(element.toString());
            }
        }

        public Image getImage(Object element) {
            if (element instanceof StateViewPage.DependencyGroup) {
                element = ((StateViewPage.DependencyGroup)element).getChildren()[0];
            }
            if (element instanceof BundleSpecification) {
                element = ((BundleSpecification)element).getSupplier();
            }
            if (element instanceof BundleDescription) {
                int flags = ((BundleDescription)element).isResolved() ? 0 : 1;
                return ((BundleDescription)element).getHost() == null ? this.fSharedProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ, flags) : this.fSharedProvider.get(PDEPluginImages.DESC_FRAGMENT_OBJ, flags);
            }
            if (element instanceof ImportPackageSpecification) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
            }
            if (element instanceof ResolverError) {
                if (((ResolverError)element).getType() == 8192) {
                    return this.fSharedProvider.get(PDEPluginImages.DESC_OPERATING_SYSTEM_OBJ);
                }
                return this.fSharedProvider.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            String result = element.toString();
            if (element instanceof ImportPackageSpecification) {
                ImportPackageSpecification spec = (ImportPackageSpecification)element;
                result = spec.getName();
            } else if (element instanceof BundleSpecification) {
                result = ((BundleSpecification)element).getSupplier().toString();
            } else if (element instanceof BundleDescription) {
                BundleDescription description = (BundleDescription)element;
                result = this.fSharedProvider.getObjectText(description);
            }
            return result;
        }
    }
}

