/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.Messages;
import org.eclipse.php.internal.ui.dialogs.PHPSourceActionDialog;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.editors.text.TextEditor;

public class GettersSettersDialog
extends PHPSourceActionDialog {
    private static final String SETTINGS_SORT_ORDER = "GettersSettersDialog.sortorder";
    private static final int SELECT_GETTERS_ID = 1025;
    private static final int SELECT_SETTERS_ID = 1026;
    private SettersForFinalFieldsFilter fSettersForFinalFieldsFilter;
    private ConstantFieldsFilter fConstantFieldFilter;
    private boolean fSortOrder;

    public GettersSettersDialog(Shell parent, ILabelProvider labelProvider, GettersSettersContentProvider contentProvider, IType textSelection, TextEditor editor) {
        super(parent, labelProvider, contentProvider, textSelection, editor);
        this.fSettersForFinalFieldsFilter = new SettersForFinalFieldsFilter(contentProvider);
        this.fConstantFieldFilter = new ConstantFieldsFilter();
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
        treeViewer.addFilter((ViewerFilter)this.fSettersForFinalFieldsFilter);
        treeViewer.addFilter((ViewerFilter)this.fConstantFieldFilter);
        return treeViewer;
    }

    private Composite addSortOrder(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.GettersSettersAction_56);
        GridData gd = new GridData(1808);
        label.setLayoutData((Object)gd);
        final Combo combo = new Combo(composite, 8);
        combo.setItems(new String[]{Messages.GettersSettersAction_57, Messages.GettersSettersAction_58});
        boolean methodIndex = true;
        int sort = this.getSortOrder() ? 1 : 0;
        combo.setText(combo.getItem(sort));
        gd = new GridData(1808);
        combo.setLayoutData((Object)gd);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GettersSettersDialog.this.setSortOrder(combo.getSelectionIndex() == 1);
            }
        });
        return composite;
    }

    @Override
    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = super.createSelectionButtons(composite);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        this.createButton(buttonComposite, 1025, Messages.GettersSettersAction_0, false);
        this.createButton(buttonComposite, 1026, Messages.GettersSettersAction_38, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        return buttonComposite;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        switch (buttonId) {
            case 1025: {
                this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(true));
                this.updateOKStatus();
                break;
            }
            case 1026: {
                this.getTreeViewer().setCheckedElements(this.getGetterSetterElements(false));
                this.updateOKStatus();
            }
        }
    }

    @Override
    protected Control createLinkControl(Composite composite) {
        Link link = new Link(composite, 64);
        link.setText(Messages.GettersSettersDialog_0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GettersSettersDialog.this.openCodeTempatePage("org.eclipse.php.ui.editor.templates.php.codetemplates.gettercomment");
            }
        });
        link.setToolTipText("");
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        link.setLayoutData((Object)gridData);
        return link;
    }

    @Override
    protected Composite createInsertPositionCombo(Composite composite) {
        Composite entryComposite = super.createInsertPositionCombo(composite);
        this.addSortOrder(entryComposite);
        this.addVisibilityAndModifiersChoices(entryComposite);
        return entryComposite;
    }

    private Object[] getGetterSetterElements(boolean isGetter) {
        Object[] allFields = this.fContentProvider.getElements(null);
        HashSet<GetterSetterEntry> result = new HashSet<GetterSetterEntry>();
        Object[] objectArray = allFields;
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            GetterSetterEntry[] entries;
            Object object = objectArray[n2];
            IField field = (IField)object;
            GetterSetterEntry[] getterSetterEntryArray = entries = this.getEntries(field);
            int n3 = entries.length;
            int n4 = 0;
            while (n4 < n3) {
                GetterSetterEntry entry = getterSetterEntryArray[n4];
                if (entry.isGetter == isGetter) {
                    result.add(entry);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray();
    }

    private GetterSetterEntry[] getEntries(IField field) {
        List<Object> result = Arrays.asList(this.fContentProvider.getChildren((Object)field));
        return result.toArray(new GetterSetterEntry[result.size()]);
    }

    public boolean getSortOrder() {
        return this.fSortOrder;
    }

    public void setSortOrder(boolean sort) {
        if (this.fSortOrder != sort) {
            this.fSortOrder = sort;
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().refresh();
            }
        }
    }

    @Override
    protected void restoreWidgetsValue(IMethod[] methods) throws ModelException {
        super.restoreWidgetsValue(methods);
        this.fSortOrder = this.asBoolean(this.fSettings.get(SETTINGS_SORT_ORDER), true);
    }

    @Override
    public boolean close() {
        boolean close = super.close();
        this.fSettings.put(SETTINGS_SORT_ORDER, this.getSortOrder());
        return close;
    }

    private static class ConstantFieldsFilter
    extends ViewerFilter {
        private ConstantFieldsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry getterSetterEntry = (GetterSetterEntry)element;
                return !getterSetterEntry.isConstant;
            }
            if (element instanceof IField) {
                IField field = (IField)element;
                try {
                    int flags = field.getFlags();
                    if (!PHPFlags.isConstant((int)flags)) {
                        return true;
                    }
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
            }
            return false;
        }
    }

    public static class GetterSetterEntry {
        public final IField field;
        public final boolean isGetter;
        public final boolean isFinal;
        public final boolean isConstant;

        public GetterSetterEntry(IField field, boolean isGetterEntry, boolean isFinal, boolean isConstant) {
            this.field = field;
            this.isGetter = isGetterEntry;
            this.isFinal = isFinal;
            this.isConstant = isConstant;
        }
    }

    public static class GetterSetterLabelProvider
    extends ModelElementLabelProvider {
        public String getText(Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry entry = (GetterSetterEntry)element;
                try {
                    if (entry.isGetter) {
                        return CodeGenerationUtils.getGetterName(entry.field) + "()";
                    }
                    return CodeGenerationUtils.getSetterName(entry.field) + "(" + entry.field.getElementName() + ")";
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                    return "";
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof GetterSetterEntry) {
                return PHPPluginImages.get("org.eclipse.php.ui.phpuservar_pub.png");
            }
            return super.getImage(element);
        }
    }

    public static class GettersSettersContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private Viewer fViewer;
        private Map<IField, GetterSetterEntry[]> fGetterSetterEntries;

        public GettersSettersContentProvider(Map<IField, GetterSetterEntry[]> entries) {
            this.fGetterSetterEntries = entries;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
        }

        public Viewer getViewer() {
            return this.fViewer;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                IField parentField = (IField)parentElement;
                try {
                    int flags = parentField.getFlags();
                    if (!PHPFlags.isConstant((int)flags)) {
                        return this.fGetterSetterEntries.get(parentElement);
                    }
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IMember) {
                return ((IMember)element).getDeclaringType();
            }
            if (element instanceof GetterSetterEntry) {
                return ((GetterSetterEntry)element).field;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fGetterSetterEntries.keySet().toArray();
        }

        public void dispose() {
        }
    }

    public static class GettersSettersSelectionStatusValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        public GettersSettersSelectionStatusValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            if (selection == null || selection.length == 0) {
                return new Status(4, "org.eclipse.php.ui", "");
            }
            HashSet<String> map = new HashSet<String>(selection.length);
            int count = 0;
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                try {
                    if (element instanceof GetterSetterEntry) {
                        String key;
                        IField getsetField = ((GetterSetterEntry)element).field;
                        if (((GetterSetterEntry)element).isGetter ? !map.add(CodeGenerationUtils.getGetterName(getsetField)) : !map.add(key = this.createSignatureKey(CodeGenerationUtils.getSetterName(getsetField), getsetField))) {
                            return new Status(2, "org.eclipse.php.ui", Messages.GettersSettersDialog_3);
                        }
                        ++count;
                    }
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
                ++n2;
            }
            if (count == 0) {
                return new Status(4, "org.eclipse.php.ui", "");
            }
            String message = MessageFormat.format(Messages.SourceActions_ValidatorText, String.valueOf(count), String.valueOf(fEntries));
            return new Status(1, "org.eclipse.php.ui", message);
        }

        private String createSignatureKey(String methodName, IField field) throws ModelException {
            StringBuilder buffer = new StringBuilder();
            buffer.append(methodName);
            buffer.append("#");
            String fieldType = field.getDeclaringType().getElementName();
            buffer.append(fieldType);
            return buffer.toString();
        }
    }

    private static class SettersForFinalFieldsFilter
    extends ViewerFilter {
        private final GettersSettersContentProvider fContentProvider;

        public SettersForFinalFieldsFilter(GettersSettersContentProvider contentProvider) {
            this.fContentProvider = contentProvider;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof GetterSetterEntry) {
                GetterSetterEntry getterSetterEntry = (GetterSetterEntry)element;
                return getterSetterEntry.isGetter || !getterSetterEntry.isFinal;
            }
            if (element instanceof IField) {
                Object[] children;
                Object[] objectArray = children = this.fContentProvider.getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element2 = objectArray[n2];
                    GetterSetterEntry curr = (GetterSetterEntry)element2;
                    if (curr.isGetter || !curr.isFinal) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return true;
        }
    }
}

