/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.tools.internal.MacGenerator;
import org.eclipse.swt.tools.internal.MacGeneratorUI;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MacGeneratorView
extends ViewPart {
    private Action generateAction;
    private MacGeneratorUI ui;
    private IResource root;
    IResourceChangeListener listener;
    private Job job;
    private String mainClassName = "org.eclipse.swt.internal.cocoa.OS";
    private String selectorEnumName = "org.eclipse.swt.internal.cocoa.Selector";

    public MacGeneratorView() {
        MacGenerator.BUILD_C_SOURCE = false;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject swtProject = workspaceRoot.getProject("org.eclipse.swt");
        if (swtProject == null) {
            throw new IllegalStateException("Project org.eclipse.swt not found in the workspace.");
        }
        Path rootPath = new Path("Eclipse SWT PI/cocoa");
        this.root = swtProject.findMember((IPath)rootPath);
        if (this.root == null) {
            throw new IllegalStateException("Path " + String.valueOf(rootPath) + " not found in the workspace.");
        }
        this.listener = event -> {
            if (this.job != null) {
                return;
            }
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta rootDelta = event.getDelta();
            IResourceDelta piDelta = rootDelta.findMember(this.root.getFullPath());
            if (piDelta == null) {
                return;
            }
            ArrayList changed = new ArrayList();
            IResourceDeltaVisitor visitor = delta -> {
                if (delta.getKind() != 4) {
                    return true;
                }
                if ((delta.getFlags() & 0x100) == 0) {
                    return true;
                }
                IResource resource = delta.getResource();
                if (resource.getType() == 1 && "extras".equalsIgnoreCase(resource.getFileExtension())) {
                    changed.add(resource);
                }
                return true;
            };
            try {
                piDelta.accept(visitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (changed.size() > 0) {
                this.ui.refresh();
            }
        };
        workspace.addResourceChangeListener(this.listener);
    }

    public void createPartControl(Composite parent) {
        MacGenerator gen = new MacGenerator();
        gen.setOutputDir(this.root.getLocation().toPortableString());
        gen.setMainClass(this.mainClassName);
        gen.setSelectorEnum(this.selectorEnumName);
        this.ui = new MacGeneratorUI(gen);
        this.ui.setActionsVisible(false);
        this.ui.open(parent);
        this.makeActions();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.listener);
        super.dispose();
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.generateAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.generateAction);
    }

    void refresh() {
        try {
            this.root.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    void generate() {
        if (this.job != null) {
            return;
        }
        this.job = new GenJob();
        this.job.schedule();
    }

    private void makeActions() {
        this.generateAction = new Action(){

            public void run() {
                MacGeneratorView.this.generate();
            }
        };
        this.generateAction.setText("Generate");
        this.generateAction.setToolTipText("Generate");
        this.generateAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
    }

    public void setFocus() {
        this.ui.setFocus();
    }

    class GenJob
    extends Job {
        public GenJob() {
            super("Mac Generator");
        }

        protected IStatus run(final IProgressMonitor monitor) {
            try {
                MacGeneratorView.this.ui.generate(new ProgressMonitor(){

                    @Override
                    public void setMessage(String message) {
                        monitor.subTask(message);
                    }

                    @Override
                    public void setTotal(int total) {
                        monitor.beginTask("Generating", total);
                    }

                    @Override
                    public void step() {
                        monitor.worked(1);
                    }
                });
                MacGeneratorView.this.refresh();
            }
            finally {
                monitor.done();
                MacGeneratorView.this.job = null;
            }
            return Status.OK_STATUS;
        }
    }
}

