/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd.CommonDnD;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.CommonNavigator;

public class FSDropAdapterAssistant
extends CommonDropAdapterAssistant {
    CommonDnD dnd = new CommonDnD();

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        boolean valid = false;
        if (target instanceof IFSTreeNode) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                int op = this.dnd.validateLocalSelectionDrop(target, operation, transferType);
                boolean bl = valid = op != 0;
                if (valid && op != operation) {
                    this.getCommonDropAdapter().overrideOperation(op);
                }
            } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
                valid = this.dnd.validateFilesDrop(target, operation, transferType);
            }
        }
        return valid ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        if (FileTransfer.getInstance().isSupportedType(aTransferType)) {
            return true;
        }
        return super.isSupportedType(aTransferType);
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        boolean sucess = false;
        TransferData transferType = aDropTargetEvent.currentDataType;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IStructuredSelection selection = (IStructuredSelection)aDropTargetEvent.data;
            int operations = aDropAdapter.getCurrentOperation();
            IFSTreeNode target = (IFSTreeNode)aTarget;
            sucess = this.dnd.dropLocalSelection(target, operations, selection);
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] files = (String[])aDropTargetEvent.data;
            int operations = aDropAdapter.getCurrentOperation();
            IFSTreeNode target = (IFSTreeNode)aTarget;
            sucess = this.dnd.dropFiles(this.getCommonViewer(), files, operations, target);
        }
        return sucess ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private TreeViewer getCommonViewer() {
        IViewReference[] references;
        Assert.isNotNull((Object)Display.getCurrent());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.isNotNull((Object)window);
        IViewReference[] iViewReferenceArray = references = window.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference reference = iViewReferenceArray[n2];
            if (reference.getId().equals("org.eclipse.tcf.te.ui.views.View")) {
                CommonNavigator navigator = (CommonNavigator)reference.getPart(true);
                return navigator.getCommonViewer();
            }
            ++n2;
        }
        return null;
    }
}

