/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.CallFrame;
import org.eclipse.wst.jsdt.chromium.ExceptionData;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumSourceDirector;
import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMap;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointInTargetMap;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumBreakpointAdapter;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumExceptionBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptThread;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchInitializationProcedure;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ResourceManager;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrame;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceRef;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMapBuilder;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMapping;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.extension.ISourceMapLanguageSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.extension.ISourceMapManager;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.core.util.JavaScriptRegExpSupport;

public class VProjectWorkspaceBridge
implements WorkspaceBridge {
    public static final String DEBUG_MODEL_ID = "org.eclipse.wst.jsdt.chromium.debug";
    private final IProject debugProject;
    private final JavascriptVm javascriptVm;
    private final ResourceManager resourceManager;
    private final ConnectedTargetData connectedTargetData;
    private final ChromiumSourceDirector sourceDirector;
    private final UpdateMappingVisitor updateMappingVisitor;
    private final VmResourceRef.Visitor<Collection<? extends VmResource>> RESOLVE_RESOURCE_VISITOR = new VmResourceRef.Visitor<Collection<? extends VmResource>>(){

        @Override
        public Collection<? extends VmResource> visitRegExpBased(ScriptNameManipulator.ScriptNamePattern scriptNamePattern) {
            Pattern pattern = JavaScriptRegExpSupport.convertToJavaPattern(scriptNamePattern);
            return VProjectWorkspaceBridge.this.resourceManager.findVmResources(pattern);
        }

        @Override
        public Collection<? extends VmResource> visitResourceId(VmResourceId resourceId) {
            VmResource vmResource = VProjectWorkspaceBridge.this.resourceManager.getVmResource(resourceId);
            if (vmResource == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(vmResource);
        }
    };
    private final BreakpointHandlerImpl breakpointHandler = new BreakpointHandlerImpl();
    private static final WorkspaceBridge.JsLabelProvider LABEL_PROVIDER = new WorkspaceBridge.JsLabelProvider(){
        private final JavascriptThread.StateVisitor<String> THREAD_DESCRIBE_VISITOR = new JavascriptThread.StateVisitor<String>(){

            @Override
            public String visitResumed(JavascriptThread.ResumeReason resumeReason) {
                return Messages.JsThread_ThreadLabelRunning;
            }

            @Override
            public String visitSuspended(IBreakpoint[] breakpoints, ExceptionData exceptionData) {
                if (exceptionData != null) {
                    return NLS.bind((String)Messages.JsThread_ThreadLabelSuspendedExceptionFormat, (Object)exceptionData.getExceptionMessage());
                }
                return Messages.JsThread_ThreadLabelSuspended;
            }
        };

        @Override
        public String getTargetLabel(DebugTargetImpl debugTarget) {
            String name = debugTarget.getName();
            String status = debugTarget.getVmStatus();
            if (status == null) {
                return name;
            }
            return NLS.bind((String)Messages.DebugTargetImpl_TARGET_NAME_PATTERN, (Object)name, (Object)status);
        }

        @Override
        public String getThreadLabel(JavascriptThread thread) {
            String url = thread.getConnectedData().getJavascriptEmbedder().getThreadName();
            return NLS.bind((String)Messages.JsThread_ThreadLabelFormat, (Object)this.getThreadStateLabel(thread), (Object)(url.length() > 0 ? " : " + url : ""));
        }

        private String getThreadStateLabel(JavascriptThread thread) {
            return thread.describeState(this.THREAD_DESCRIBE_VISITOR);
        }

        @Override
        public String getStackFrameLabel(StackFrame stackFrame) throws DebugException {
            CallFrame callFrame = stackFrame.getCallFrame();
            String name = callFrame.getFunctionName();
            Script script = callFrame.getScript();
            String scriptName = script == null ? Messages.StackFrame_UnknownScriptName : VmResourceId.forScript(script).getVisibleName();
            int line = stackFrame.getLineNumber();
            if (line != -1) {
                name = NLS.bind((String)Messages.StackFrame_NameFormat, (Object[])new Object[]{name, scriptName, line});
            }
            return name;
        }
    };

    public VProjectWorkspaceBridge(String projectName, ConnectedTargetData connectedTargetData, JavascriptVm javascriptVm) {
        this.connectedTargetData = connectedTargetData;
        this.javascriptVm = javascriptVm;
        this.debugProject = ChromiumDebugPluginUtil.createEmptyProject(projectName);
        this.resourceManager = new ResourceManager(this.debugProject);
        this.updateMappingVisitor = new UpdateMappingVisitor();
        ILaunch launch = connectedTargetData.getDebugTarget().getLaunch();
        this.sourceDirector = (ChromiumSourceDirector)launch.getSourceLocator();
        this.sourceDirector.initializeVProjectContainers(this.debugProject, this.resourceManager, connectedTargetData.getJavascriptEmbedder());
    }

    public BreakpointSynchronizer getBreakpointSynchronizer() {
        return new BreakpointSynchronizer(this.javascriptVm, this.sourceDirector, this.breakpointHandler, DEBUG_MODEL_ID);
    }

    @Override
    public void synchronizeBreakpoints(BreakpointSynchronizer.Direction direction, BreakpointSynchronizer.Callback callback) {
        this.getBreakpointSynchronizer().syncBreakpoints(direction, callback);
    }

    @Override
    public void startInitialization() {
        LaunchInitializationProcedure.startAsync(this, this.connectedTargetData.getDebugTarget().getPresetSyncDirection());
    }

    @Override
    public void launchRemoved() {
        if (this.debugProject != null) {
            ChromiumDebugPluginUtil.deleteVirtualProjectAsync(this.debugProject);
        }
    }

    @Override
    public void beforeDetach() {
    }

    @Override
    public void handleVmResetEvent() {
        this.resourceManager.clear();
    }

    @Override
    public void scriptLoaded(Script newScript) {
        this.resourceManager.addScript(newScript);
    }

    @Override
    public void scriptCollected(Script script) {
        this.resourceManager.scriptCollected(script);
    }

    public void reloadScriptsAtStart() {
        this.javascriptVm.getScripts(new JavascriptVm.ScriptsCallback(){

            public void failure(String errorMessage) {
                ChromiumDebugPlugin.logError(errorMessage, new Object[0]);
            }

            public void success(Collection<Script> scripts) {
                if (!VProjectWorkspaceBridge.this.javascriptVm.isAttached()) {
                    return;
                }
                for (Script script : scripts) {
                    VProjectWorkspaceBridge.this.resourceManager.addScript(script);
                }
            }
        });
    }

    @Override
    public Collection<? extends VmResource> findVmResourcesFromWorkspaceFile(IFile resource) throws CoreException {
        VmResourceRef vmResourceRef = this.findVmResourceRefFromWorkspaceFile(resource);
        if (vmResourceRef == null) {
            return null;
        }
        return vmResourceRef.accept(this.RESOLVE_RESOURCE_VISITOR);
    }

    @Override
    public VmResource getVProjectVmResource(IFile file) {
        VmResourceId resourceId = this.resourceManager.getResourceId(file);
        if (resourceId == null) {
            return null;
        }
        return this.resourceManager.getVmResource(resourceId);
    }

    @Override
    public VmResource createTemporaryFile(VmResource.Metadata metadata, String proposedFileName) {
        return this.resourceManager.createTemporaryFile(metadata, proposedFileName);
    }

    private VmResourceRef findVmResourceRefFromWorkspaceFile(IFile resource) throws CoreException {
        return this.sourceDirector.findVmResourceRef(resource);
    }

    @Override
    public void reloadScript(Script script) {
        this.resourceManager.reloadScript(script);
    }

    @Override
    public WorkspaceBridge.BreakpointHandler getBreakpointHandler() {
        return this.breakpointHandler;
    }

    public ConnectedTargetData getConnectedTargetData() {
        return this.connectedTargetData;
    }

    private static SourcePositionMapBuilder.ResourceSection create(IFile file, VmResourceId resourceId) {
        IDocument document = VProjectWorkspaceBridge.getDocument(file);
        int endLine = document.getNumberOfLines();
        if (endLine > 0) {
            --endLine;
        }
        int endColumn = 0;
        try {
            endColumn = document.getLineLength(endLine);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return new SourcePositionMapBuilder.ResourceSection(resourceId, 0, 0, endLine, endColumn);
    }

    private static IDocument getDocument(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath location = file.getLocation();
        boolean connected = false;
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer(location, LocationKind.NORMALIZE);
            if (buffer == null) {
                manager.connect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                connected = true;
                buffer = manager.getTextFileBuffer(location, LocationKind.NORMALIZE);
                if (buffer == null) {
                    return null;
                }
            }
            IDocument iDocument = buffer.getDocument();
            return iDocument;
        }
        catch (CoreException ce) {
            ChromiumDebugPlugin.log(ce);
            return null;
        }
        finally {
            if (connected) {
                try {
                    manager.disconnect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(e);
                }
            }
        }
    }

    private class BreakpointHandlerImpl
    implements WorkspaceBridge.BreakpointHandler,
    BreakpointSynchronizer.BreakpointHelper {
        private volatile JavascriptVm.ExceptionCatchMode breakExceptionMode = null;
        private final LineBreakpointHandler lineBreakpointHandler = new LineBreakpointHandler();
        private final ExceptionBreakpointHandler exceptionBreakpointHandler = new ExceptionBreakpointHandler();
        private final List<BreakpointMapperBase<?, ?>> allHandlers = new ArrayList(2);

        private BreakpointHandlerImpl() {
            this.allHandlers.add(this.lineBreakpointHandler);
            this.allHandlers.add(this.exceptionBreakpointHandler);
        }

        @Override
        public void initBreakpointManagerListenerState(IBreakpointManager breakpointManager) {
            for (BreakpointMapperBase<?, ?> handler : this.allHandlers) {
                handler.initEnablement(breakpointManager);
            }
        }

        @Override
        public boolean supportsBreakpoint(IBreakpoint breakpoint) {
            for (BreakpointMapperBase<?, ?> handler : this.allHandlers) {
                Object res = handler.tryCastBreakpoint(breakpoint);
                if (res == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Breakpoint getSdkBreakpoint(ChromiumLineBreakpoint chromiumLineBreakpoint) {
            return this.lineBreakpointHandler.getSdkBreakpoint(chromiumLineBreakpoint);
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
            for (BreakpointMapperBase<?, ?> handler : this.allHandlers) {
                boolean res = handler.breakpointAdded(breakpoint);
                if (!res) continue;
                return;
            }
        }

        @Override
        public RelayOk createBreakpointOnRemote(ChromiumLineBreakpoint lineBreakpoint, VmResourceRef vmResourceRef, BreakpointSynchronizer.BreakpointHelper.CreateCallback createCallback, SyncCallback syncCallback) throws CoreException {
            vmResourceRef.accept(VProjectWorkspaceBridge.this.updateMappingVisitor);
            return this.lineBreakpointHandler.createBreakpointOnRemote(lineBreakpoint, vmResourceRef, createCallback, syncCallback);
        }

        @Override
        public BreakpointInTargetMap<Breakpoint, ChromiumLineBreakpoint> getLineBreakpointMap() {
            return this.lineBreakpointHandler.getMap();
        }

        @Override
        public void registerExceptionBreakpoint(Collection<ChromiumExceptionBreakpoint> collection) {
            this.exceptionBreakpointHandler.registerLocalBreakpoints(collection);
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            for (BreakpointMapperBase<?, ?> handler : this.allHandlers) {
                boolean res = handler.breakpointChanged(breakpoint, delta);
                if (!res) continue;
                return;
            }
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
            for (BreakpointMapperBase<?, ?> handler : this.allHandlers) {
                boolean res = handler.breakpointRemoved(breakpoint, delta);
                if (!res) continue;
                return;
            }
        }

        public synchronized void breakpointManagerEnablementChanged(boolean enabled) {
            for (BreakpointMapperBase<?, ?> handler : this.allHandlers) {
                handler.breakpointManagerEnablementChanged(enabled);
            }
        }

        @Override
        public Collection<? extends IBreakpoint> breakpointsHit(Collection<? extends Breakpoint> breakpointsHit) {
            return this.lineBreakpointHandler.handleBreakpointsHit(breakpointsHit);
        }

        @Override
        public Collection<? extends IBreakpoint> exceptionBreakpointHit(boolean isUncaught) {
            return this.exceptionBreakpointHandler.getHitBreakpoints(isUncaught);
        }

        private String getTargetNameSafe() {
            try {
                return VProjectWorkspaceBridge.this.connectedTargetData.getDebugTarget().getLaunch().getLaunchConfiguration().getName();
            }
            catch (RuntimeException runtimeException) {
                return "<unknown>";
            }
        }

        private abstract class BreakpointMapperBase<SDK, UI> {
            private final BreakpointInTargetMap<SDK, UI> map = new BreakpointInTargetMap();

            private BreakpointMapperBase() {
            }

            boolean breakpointAdded(IBreakpoint breakpoint) {
                UI castBreakpoint = this.tryCastBreakpointOnAddition(breakpoint);
                if (castBreakpoint == null) {
                    return false;
                }
                this.breakpointAdded(castBreakpoint);
                return true;
            }

            boolean breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
                UI castBreakpoint = this.tryCastBreakpoint(breakpoint);
                if (castBreakpoint == null) {
                    return false;
                }
                this.breakpointChanged(castBreakpoint, delta);
                return true;
            }

            boolean breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
                UI castBreakpoint = this.tryCastBreakpointOnRemoval(breakpoint);
                if (castBreakpoint == null) {
                    return false;
                }
                this.breakpointRemoved(castBreakpoint, delta);
                return true;
            }

            abstract void initEnablement(IBreakpointManager var1);

            abstract void breakpointManagerEnablementChanged(boolean var1);

            abstract void breakpointAdded(UI var1);

            abstract void breakpointChanged(UI var1, IMarkerDelta var2);

            abstract void breakpointRemoved(UI var1, IMarkerDelta var2);

            abstract UI tryCastBreakpoint(IBreakpoint var1);

            abstract UI tryCastBreakpointOnAddition(IBreakpoint var1);

            abstract UI tryCastBreakpointOnRemoval(IBreakpoint var1);

            protected BreakpointInTargetMap<SDK, UI> getMap() {
                return this.map;
            }
        }

        private class ExceptionBreakpointHandler
        extends BreakpointMapperBase<FakeSdkBreakpoint, ChromiumExceptionBreakpoint> {
            private final List<FakeSdkBreakpoint> breakpoints = new ArrayList<FakeSdkBreakpoint>(2);
            private JavascriptVm.ExceptionCatchMode currentRemoteFlag = null;
            private boolean breakpointsEnabled;

            private ExceptionBreakpointHandler() {
            }

            @Override
            synchronized void breakpointManagerEnablementChanged(boolean enabled) {
                this.breakpointsEnabled = enabled;
                this.updateRemoteState();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Collection<? extends IBreakpoint> getHitBreakpoints(boolean isUncaught) {
                ArrayList<ChromiumExceptionBreakpoint> result = new ArrayList<ChromiumExceptionBreakpoint>(2);
                ExceptionBreakpointHandler exceptionBreakpointHandler = this;
                synchronized (exceptionBreakpointHandler) {
                    for (FakeSdkBreakpoint sdkBreakpoint : this.breakpoints) {
                        ChromiumExceptionBreakpoint uiBreakpoint;
                        if (!isUncaught && !sdkBreakpoint.includeCaught || (uiBreakpoint = (ChromiumExceptionBreakpoint)((Object)this.getMap().getUiBreakpoint(sdkBreakpoint))) == null) continue;
                        result.add(uiBreakpoint);
                    }
                }
                return result;
            }

            @Override
            synchronized void initEnablement(IBreakpointManager breakpointManager) {
                this.breakpointsEnabled = breakpointManager.isEnabled();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registerLocalBreakpoints(Collection<ChromiumExceptionBreakpoint> collection) {
                ExceptionBreakpointHandler exceptionBreakpointHandler = this;
                synchronized (exceptionBreakpointHandler) {
                    for (ChromiumExceptionBreakpoint uiBreakpoint : collection) {
                        FakeSdkBreakpoint sdkBreakpoint = new FakeSdkBreakpoint();
                        sdkBreakpoint.initProperties(uiBreakpoint);
                        this.breakpoints.add(sdkBreakpoint);
                        this.getMap().add(sdkBreakpoint, uiBreakpoint);
                    }
                }
                this.updateRemoteState();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void breakpointAdded(ChromiumExceptionBreakpoint uiBreakpoint) {
                FakeSdkBreakpoint sdkBreakpoint = new FakeSdkBreakpoint();
                sdkBreakpoint.initProperties(uiBreakpoint);
                ExceptionBreakpointHandler exceptionBreakpointHandler = this;
                synchronized (exceptionBreakpointHandler) {
                    this.breakpoints.add(sdkBreakpoint);
                    this.getMap().add(sdkBreakpoint, uiBreakpoint);
                }
                this.updateRemoteState();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void breakpointChanged(ChromiumExceptionBreakpoint uiBreakpoint, IMarkerDelta delta) {
                boolean enabled;
                FakeSdkBreakpoint sdkBreakpoint = (FakeSdkBreakpoint)this.getMap().getSdkBreakpoint(uiBreakpoint);
                if (sdkBreakpoint == null) {
                    return;
                }
                boolean includeCaught = uiBreakpoint.getIncludeCaught();
                try {
                    enabled = uiBreakpoint.isEnabled();
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                boolean changed = false;
                ExceptionBreakpointHandler exceptionBreakpointHandler = this;
                synchronized (exceptionBreakpointHandler) {
                    if (includeCaught != sdkBreakpoint.includeCaught) {
                        changed = true;
                        sdkBreakpoint.includeCaught = includeCaught;
                    }
                    if (enabled != sdkBreakpoint.enabled) {
                        changed = true;
                        sdkBreakpoint.enabled = enabled;
                    }
                }
                if (changed) {
                    this.updateRemoteState();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void breakpointRemoved(ChromiumExceptionBreakpoint uiBreakpoint, IMarkerDelta delta) {
                FakeSdkBreakpoint sdkBreakpoint = (FakeSdkBreakpoint)this.getMap().getSdkBreakpoint(uiBreakpoint);
                if (sdkBreakpoint == null) {
                    return;
                }
                ExceptionBreakpointHandler exceptionBreakpointHandler = this;
                synchronized (exceptionBreakpointHandler) {
                    this.breakpoints.remove(sdkBreakpoint);
                    this.getMap().remove(uiBreakpoint);
                }
                this.updateRemoteState();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void updateRemoteState() {
                JavascriptVm.ExceptionCatchMode newRemoteFlag = JavascriptVm.ExceptionCatchMode.NONE;
                ExceptionBreakpointHandler exceptionBreakpointHandler = this;
                synchronized (exceptionBreakpointHandler) {
                    if (this.breakpointsEnabled) {
                        for (FakeSdkBreakpoint sdkBreakpoint : this.breakpoints) {
                            if (!sdkBreakpoint.enabled) continue;
                            if (sdkBreakpoint.includeCaught) {
                                newRemoteFlag = JavascriptVm.ExceptionCatchMode.ALL;
                                break;
                            }
                            newRemoteFlag = JavascriptVm.ExceptionCatchMode.UNCAUGHT;
                        }
                    }
                    if (newRemoteFlag != this.currentRemoteFlag) {
                        VProjectWorkspaceBridge.this.javascriptVm.setBreakOnException(newRemoteFlag, null, null);
                        this.currentRemoteFlag = newRemoteFlag;
                    }
                }
            }

            @Override
            ChromiumExceptionBreakpoint tryCastBreakpoint(IBreakpoint breakpoint) {
                if (VProjectWorkspaceBridge.this.connectedTargetData.getDebugTarget().isDisconnected()) {
                    return null;
                }
                return ChromiumExceptionBreakpoint.tryCastBreakpoint(breakpoint);
            }

            @Override
            ChromiumExceptionBreakpoint tryCastBreakpointOnAddition(IBreakpoint breakpoint) {
                return this.tryCastBreakpoint(breakpoint);
            }

            @Override
            ChromiumExceptionBreakpoint tryCastBreakpointOnRemoval(IBreakpoint breakpoint) {
                return this.tryCastBreakpoint(breakpoint);
            }

            class FakeSdkBreakpoint {
                boolean includeCaught;
                boolean enabled;

                FakeSdkBreakpoint() {
                }

                void initProperties(ChromiumExceptionBreakpoint uiBreakpoint) {
                    this.includeCaught = uiBreakpoint.getIncludeCaught();
                    try {
                        this.enabled = uiBreakpoint.isEnabled();
                    }
                    catch (CoreException e) {
                        ChromiumDebugPlugin.log(e);
                    }
                }
            }
        }

        private class LineBreakpointHandler
        extends BreakpointMapperBase<Breakpoint, ChromiumLineBreakpoint> {
            private final EnablementMonitor enablementMonitor = new EnablementMonitor();

            private LineBreakpointHandler() {
            }

            @Override
            void initEnablement(IBreakpointManager breakpointManager) {
                this.enablementMonitor.init(breakpointManager);
            }

            @Override
            void breakpointAdded(ChromiumLineBreakpoint lineBreakpoint) {
                VmResourceRef vmResourceRef;
                if (ChromiumLineBreakpoint.getIgnoreList().contains(lineBreakpoint)) {
                    return;
                }
                IFile file = (IFile)lineBreakpoint.getMarker().getResource();
                try {
                    vmResourceRef = VProjectWorkspaceBridge.this.findVmResourceRefFromWorkspaceFile(file);
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(new Exception("Failed to resolve script for the file " + file, e));
                    return;
                }
                if (vmResourceRef == null) {
                    return;
                }
                try {
                    this.createBreakpointOnRemote(lineBreakpoint, vmResourceRef, null, null);
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(new Exception("Failed to create breakpoint in " + BreakpointHandlerImpl.this.getTargetNameSafe(), e));
                    throw new RuntimeException(e);
                }
            }

            public Collection<? extends IBreakpoint> handleBreakpointsHit(Collection<? extends Breakpoint> sdkBreakpoints) {
                if (sdkBreakpoints.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<ChromiumLineBreakpoint> uiBreakpoints = new ArrayList<ChromiumLineBreakpoint>(sdkBreakpoints.size());
                for (Breakpoint breakpoint : sdkBreakpoints) {
                    ChromiumLineBreakpoint uiBreakpoint = (ChromiumLineBreakpoint)((Object)this.getMap().getUiBreakpoint(breakpoint));
                    if (uiBreakpoint == null) continue;
                    try {
                        uiBreakpoint.silentlyResetIgnoreCount();
                    }
                    catch (CoreException e) {
                        ChromiumDebugPlugin.log(new Exception("Failed to reset breakpoint ignore count", e));
                    }
                    uiBreakpoints.add(uiBreakpoint);
                }
                return uiBreakpoints;
            }

            public Breakpoint getSdkBreakpoint(ChromiumLineBreakpoint chromiumLineBreakpoint) {
                return (Breakpoint)this.getMap().getSdkBreakpoint(chromiumLineBreakpoint);
            }

            public RelayOk createBreakpointOnRemote(final ChromiumLineBreakpoint lineBreakpoint, VmResourceRef vmResourceRef, final BreakpointSynchronizer.BreakpointHelper.CreateCallback createCallback, SyncCallback syncCallback) throws CoreException {
                ChromiumLineBreakpoint.Helper.CreateOnRemoveCallback callback = new ChromiumLineBreakpoint.Helper.CreateOnRemoveCallback(){

                    @Override
                    public void success(Breakpoint breakpoint) {
                        LineBreakpointHandler.this.getMap().add(breakpoint, lineBreakpoint);
                        if (createCallback != null) {
                            createCallback.success();
                        }
                    }

                    @Override
                    public void failure(String errorMessage) {
                        if (createCallback == null) {
                            ChromiumDebugPlugin.logError(errorMessage, new Object[0]);
                        } else {
                            createCallback.failure(new Exception(errorMessage));
                        }
                    }
                };
                return ChromiumLineBreakpoint.Helper.createOnRemote(lineBreakpoint, vmResourceRef, VProjectWorkspaceBridge.this.connectedTargetData, callback, syncCallback);
            }

            @Override
            void breakpointChanged(ChromiumLineBreakpoint lineBreakpoint, IMarkerDelta delta) {
                if (ChromiumLineBreakpoint.getIgnoreList().contains(lineBreakpoint)) {
                    return;
                }
                Breakpoint sdkBreakpoint = (Breakpoint)this.getMap().getSdkBreakpoint(lineBreakpoint);
                if (sdkBreakpoint == null) {
                    return;
                }
                Set<ChromiumLineBreakpoint.MutableProperty> propertyDelta = lineBreakpoint.getChangedProperty(delta);
                if (propertyDelta.isEmpty()) {
                    return;
                }
                try {
                    ChromiumLineBreakpoint.Helper.updateOnRemote(sdkBreakpoint, lineBreakpoint, propertyDelta);
                }
                catch (RuntimeException e) {
                    ChromiumDebugPlugin.log(new Exception("Failed to change breakpoint in " + BreakpointHandlerImpl.this.getTargetNameSafe(), e));
                }
                catch (CoreException e) {
                    ChromiumDebugPlugin.log(new Exception("Failed to change breakpoint in " + BreakpointHandlerImpl.this.getTargetNameSafe(), e));
                }
            }

            @Override
            void breakpointRemoved(ChromiumLineBreakpoint lineBreakpoint, IMarkerDelta delta) {
                if (ChromiumLineBreakpoint.getIgnoreList().contains(lineBreakpoint)) {
                    return;
                }
                Breakpoint sdkBreakpoint = (Breakpoint)this.getMap().getSdkBreakpoint(lineBreakpoint);
                if (sdkBreakpoint == null) {
                    return;
                }
                if (!lineBreakpoint.isEnabled()) {
                    return;
                }
                JavascriptVm.BreakpointCallback callback = new JavascriptVm.BreakpointCallback(){

                    public void failure(String errorMessage) {
                        ChromiumDebugPlugin.log(new Exception("Failed to remove breakpoint in " + BreakpointHandlerImpl.this.getTargetNameSafe() + ": " + errorMessage));
                    }

                    public void success(Breakpoint breakpoint) {
                    }
                };
                try {
                    sdkBreakpoint.clear(callback, null);
                }
                catch (RuntimeException e) {
                    ChromiumDebugPlugin.log(new Exception("Failed to remove breakpoint in " + BreakpointHandlerImpl.this.getTargetNameSafe(), e));
                }
                this.getMap().remove(lineBreakpoint);
            }

            @Override
            void breakpointManagerEnablementChanged(boolean enabled) {
                this.enablementMonitor.setState(enabled);
            }

            @Override
            ChromiumLineBreakpoint tryCastBreakpoint(IBreakpoint breakpoint) {
                if (VProjectWorkspaceBridge.this.connectedTargetData.getDebugTarget().isDisconnected()) {
                    return null;
                }
                return ChromiumBreakpointAdapter.tryCastBreakpoint(breakpoint);
            }

            @Override
            ChromiumLineBreakpoint tryCastBreakpointOnAddition(IBreakpoint breakpoint) {
                if (VProjectWorkspaceBridge.this.connectedTargetData.getDebugTarget().isDisconnected()) {
                    return null;
                }
                return ChromiumBreakpointAdapter.tryCastBreakpointOnAddition(breakpoint);
            }

            @Override
            ChromiumLineBreakpoint tryCastBreakpointOnRemoval(IBreakpoint breakpoint) {
                if (VProjectWorkspaceBridge.this.connectedTargetData.getDebugTarget().isDisconnected()) {
                    return null;
                }
                return ChromiumBreakpointAdapter.tryCastBreakpointOnRemoval(breakpoint);
            }

            private class EnablementMonitor {
                private EnablementMonitor() {
                }

                synchronized void init(IBreakpointManager breakpointManager) {
                    this.sendRequest(breakpointManager.isEnabled());
                }

                synchronized void setState(boolean enabled) {
                    this.sendRequest(enabled);
                }

                private void sendRequest(boolean enabled) {
                    VProjectWorkspaceBridge.this.javascriptVm.enableBreakpoints(Boolean.valueOf(enabled), null, null);
                }
            }
        }
    }

    public static class FactoryImpl
    implements WorkspaceBridge.Factory {
        private final String projectNameBase;

        public FactoryImpl(String projectNameBase) {
            this.projectNameBase = projectNameBase;
        }

        @Override
        public WorkspaceBridge attachedToVm(ConnectedTargetData connectedTargetData, JavascriptVm javascriptVm) {
            return new VProjectWorkspaceBridge(this.projectNameBase, connectedTargetData, javascriptVm);
        }

        @Override
        public String getDebugModelIdentifier() {
            return VProjectWorkspaceBridge.DEBUG_MODEL_ID;
        }

        @Override
        public WorkspaceBridge.JsLabelProvider getLabelProvider() {
            return LABEL_PROVIDER;
        }
    }

    class UpdateMappingVisitor
    implements VmResourceRef.Visitor<Object> {
        UpdateMappingVisitor() {
        }

        @Override
        public Object visitRegExpBased(ScriptNameManipulator.ScriptNamePattern scriptNamePattern) {
            return null;
        }

        @Override
        public Object visitResourceId(final VmResourceId tsResourceId) {
            ISourceMapLanguageSupport support;
            String fileName;
            block5: {
                int index;
                block4: {
                    fileName = tsResourceId.getName();
                    index = fileName.lastIndexOf(46);
                    if (index != -1) break block4;
                    return null;
                }
                ISourceMapManager manager = ChromiumDebugPlugin.getSourceMapManager();
                String fileExtension = fileName.substring(index + 1, fileName.length());
                support = manager.getSourceMapLanguageSupport(fileExtension);
                if (support != null) break block5;
                return null;
            }
            try {
                Path tsFilePath = new Path(fileName);
                final IFile tsFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)tsFilePath)[0];
                IPath jsFilePath = support.getJsFile((IPath)tsFilePath);
                final IFile jsFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(jsFilePath)[0];
                IPath sourceMapFilePath = support.getSourceMapFile((IPath)tsFilePath);
                IFile sourceMapFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(sourceMapFilePath)[0];
                final SourceMap sourceMap = SourceMap.load(sourceMapFile.getContents());
                VmResourceRef jsRef = VProjectWorkspaceBridge.this.sourceDirector.findVmResourceRef(jsFile);
                jsRef.accept(new VmResourceRef.Visitor<Object>(){

                    @Override
                    public Object visitRegExpBased(ScriptNameManipulator.ScriptNamePattern scriptNamePattern) {
                        return null;
                    }

                    @Override
                    public Object visitResourceId(VmResourceId jsResourceId) {
                        SourcePositionMapBuilder.ResourceSection vmResourceSection = VProjectWorkspaceBridge.create(jsFile, jsResourceId);
                        SourcePositionMapBuilder.ResourceSection originalResourceSection = VProjectWorkspaceBridge.create(tsFile, tsResourceId);
                        try {
                            TextSectionMapping mapTable = sourceMap.getMapping(tsFile.getName());
                            VProjectWorkspaceBridge.this.connectedTargetData.getSourcePositionMapBuilder().addMapping(originalResourceSection, vmResourceSection, mapTable);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

