/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment;

import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDGroupAllFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDGroupChoiceFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDGroupChoiceRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDGroupSeqFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDGroupSeqRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDWildcard;

public class XSDParticleToFragmentMapper
extends XSDToFragmentMapper {
    public XSDParticleToFragmentMapper(XSDToFragmentController controller, WSDLPartsToXSDTypeMapper wsdlToXSDMapper) {
        super(controller, wsdlToXSDMapper);
    }

    @Override
    public IXSDFragment getFragment(XSDToFragmentConfiguration config, String id, String name) {
        XSDComponent component = config.getXSDComponent();
        Object xsdParticleContent = component instanceof XSDParticle ? ((XSDParticle)component).getContent() : (component instanceof XSDParticleContent ? (XSDParticleContent)component : null);
        if (xsdParticleContent != null) {
            if (xsdParticleContent instanceof XSDModelGroupDefinition) {
                return this.getXSDModelGroupDefFragment(config, id, name, (XSDModelGroupDefinition)xsdParticleContent);
            }
            if (xsdParticleContent instanceof XSDModelGroup) {
                return this.getXSDModelGroupFragment(config, id, name, (XSDModelGroup)xsdParticleContent);
            }
            if (xsdParticleContent instanceof XSDWildcard) {
                return this.getXSDWildcardFragment(config, id, name, (XSDWildcard)xsdParticleContent);
            }
            return this.getXSDDefaultFragment(config, id, name);
        }
        return this.getXSDDefaultFragment(config, id, name);
    }

    private IXSDFragment getXSDModelGroupDefFragment(XSDToFragmentConfiguration config, String id, String name, XSDModelGroupDefinition xsdModelGroupDef) {
        XSDModelGroup xsdModelGroup;
        XSDModelGroupDefinition resolvedXSDModelGroupDef = xsdModelGroupDef;
        if (xsdModelGroupDef.isModelGroupDefinitionReference()) {
            resolvedXSDModelGroupDef = xsdModelGroupDef.getResolvedModelGroupDefinition();
        }
        if ((xsdModelGroup = resolvedXSDModelGroupDef.getModelGroup()) == null) {
            return this.getXSDDefaultFragment(config, id, name);
        }
        return this.getXSDModelGroupFragment(config, id, name, xsdModelGroup);
    }

    private IXSDFragment getXSDModelGroupFragment(XSDToFragmentConfiguration config, String id, String name, XSDModelGroup xsdModelGroup) {
        int minOccurs = 1;
        int maxOccurs = 1;
        XSDConcreteComponent concreteComponent = xsdModelGroup.getContainer();
        if (concreteComponent != null && concreteComponent instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)concreteComponent;
            if (particle.isSetMinOccurs()) {
                minOccurs = particle.getMinOccurs();
            }
            if (particle.isSetMaxOccurs()) {
                maxOccurs = particle.getMaxOccurs();
            }
        }
        config.setMinOccurs(minOccurs);
        config.setMaxOccurs(maxOccurs);
        switch (xsdModelGroup.getCompositor().getValue()) {
            case 2: {
                if (minOccurs == maxOccurs) {
                    return new XSDGroupSeqFixFragment(id, name, config, this.getController(), xsdModelGroup);
                }
                return new XSDGroupSeqRangeFragment(id, name, config, this.getController(), xsdModelGroup);
            }
            case 1: {
                if (minOccurs == maxOccurs) {
                    return new XSDGroupChoiceFixFragment(id, name, config, this.getController(), xsdModelGroup);
                }
                return new XSDGroupChoiceRangeFragment(id, name, config, this.getController(), xsdModelGroup);
            }
            case 0: {
                return new XSDGroupAllFragment(id, name, config, this.getController(), xsdModelGroup);
            }
        }
        return this.getXSDDefaultFragment(config, id, name);
    }

    private IXSDFragment getXSDWildcardFragment(XSDToFragmentConfiguration config, String id, String name, XSDWildcard xsdParticleContent) {
        return this.getXSDDefaultFragment(config, id, name);
    }
}

