/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class VariableUtils {
    private final JavaInfo m_javaInfo;

    public VariableUtils(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
    }

    public String getUniqueFieldName(String localName, VariableDeclaration excludedVariable) {
        return this.convertName(-1, localName, 5, 2, excludedVariable);
    }

    public String convertName(int position, String name, int variableKind_source, int variableKind_target, VariableDeclaration excludedVariable) {
        String possibleNumber;
        int index = name.lastIndexOf(95);
        if (index != -1 && StringUtils.isNumeric((CharSequence)(possibleNumber = name.substring(index + 1)))) {
            name = name.substring(0, index);
        }
        name = this.stripPrefixSuffix(name, variableKind_source);
        name = this.addPrefixSuffix(name, variableKind_target);
        return this.m_javaInfo.getEditor().getUniqueVariableName(position, name, excludedVariable);
    }

    public String addPrefixSuffix(String name, int variableKind) {
        Assert.isNotNull((Object)name);
        IJavaProject javaProject = this.m_javaInfo.getEditor().getJavaProject();
        String[] variableNames = NamingConventions.suggestVariableNames((int)variableKind, (int)1, (String)name, (IJavaProject)javaProject, (int)0, null, (boolean)true);
        return variableNames[0];
    }

    public String stripPrefixSuffix(String name, int variableKind) {
        Assert.isNotNull((Object)name);
        IJavaProject javaProject = this.m_javaInfo.getEditor().getJavaProject();
        String baseName = NamingConventions.getBaseName((int)variableKind, (String)name, (IJavaProject)javaProject);
        return baseName;
    }
}

