/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.handles;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public abstract class Handle
extends Figure
implements AncestorListener,
org.eclipse.gef.Handle {
    private final GraphicalEditPart m_owner;
    private final Locator m_locator;
    private Tool m_dragTracker;

    public Handle(GraphicalEditPart owner, Locator locator) {
        this.m_owner = owner;
        this.m_locator = locator;
    }

    public void addNotify() {
        super.addNotify();
        this.getOwnerFigure().addAncestorListener((AncestorListener)this);
        this.revalidate();
    }

    public void removeNotify() {
        this.getOwnerFigure().removeAncestorListener((AncestorListener)this);
        super.removeNotify();
    }

    public void ancestorMoved(IFigure ancestor) {
        this.revalidate();
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorRemoved(IFigure ancestor) {
    }

    public void revalidate() {
        this.getLocator().relocate((IFigure)this);
    }

    protected final GraphicalEditPart getOwner() {
        return this.m_owner;
    }

    protected final IFigure getOwnerFigure() {
        return this.getOwner().getFigure();
    }

    protected final Locator getLocator() {
        return this.m_locator;
    }

    public Tool getDragTracker() {
        if (this.m_dragTracker == null) {
            this.m_dragTracker = this.createDragTrackerTool();
        }
        return this.m_dragTracker;
    }

    public void setDragTracker(Tool dragTracker) {
        this.m_dragTracker = dragTracker;
    }

    protected final Tool createDragTrackerTool() {
        return null;
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getCenter();
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    public String toString() {
        return "[%s] %s".formatted(((Object)((Object)this)).getClass().getSimpleName(), this.getBounds());
    }
}

