/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpaJpqlHyperlinkBuilder;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;

public abstract class JpaJpqlHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected JpaJpqlHyperlinkDetector() {
    }

    protected abstract JpaJpqlHyperlinkBuilder buildHyperlinkBuilder(JpaJpqlQueryHelper var1, NamedQuery var2, QueryPosition var3);

    public final IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        NamedQuery namedQuery = (NamedQuery)this.getAdapter(NamedQuery.class);
        JpaJpqlQueryHelper queryHelper = namedQuery.getPersistenceUnit().createJpqlQueryHelper();
        try {
            String jpqlQuery = textViewer.getTextWidget().getText();
            queryHelper.setQuery(namedQuery, jpqlQuery);
            QueryPosition queryPosition = queryHelper.getJPQLExpression().buildPosition(jpqlQuery, region.getOffset());
            JpaJpqlHyperlinkBuilder builder = this.buildHyperlinkBuilder(queryHelper, namedQuery, queryPosition);
            queryPosition.getExpression().accept((ExpressionVisitor)builder);
            IHyperlink[] iHyperlinkArray = builder.hyperlinks();
            return iHyperlinkArray;
        }
        finally {
            queryHelper.dispose();
        }
    }
}

