/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandContext;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.command.DeleteAttributeCommand;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class ClickRemoveAttributeButtonFeature
extends DefaultDeleteFeature {
    private String attrName = "";

    public ClickRemoveAttributeButtonFeature(IFeatureProvider provider) {
        super(provider);
    }

    protected String getQuestionToUser() {
        return MessageFormat.format(JPAEditorMessages.ClickRemoveAttributeButtonFeature_deleteAttributeQuestion, this.attrName);
    }

    public boolean canUndo(IContext context) {
        return false;
    }

    private String getAttrName(ContainerShape textShape) {
        String txt = ((Text)textShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getValue();
        String attrName = txt.substring(txt.indexOf(58) + 1);
        attrName = attrName.trim();
        return attrName;
    }

    private void deleteAttribute(ContainerShape pe, String attrName) {
        PersistentType jpt = (PersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pe.getContainer().getContainer());
        this.deleteFieldFromCompositePKClass(attrName, jpt);
        JpaArtifactFactory.instance().deleteAttribute(jpt, attrName, this.getFeatureProvider());
    }

    public void delete(IDeleteContext context) {
        this.delete(context, true);
    }

    public void preDelete(IDeleteContext context) {
        super.preDelete(context);
    }

    public void delete(IDeleteContext context, boolean haveToAsk) {
        String attrName;
        PictogramElementContext ctx = (PictogramElementContext)context;
        ContainerShape textShape = (ContainerShape)ctx.getPictogramElement();
        if (textShape == null || textShape.getGraphicsAlgorithm() == null) {
            return;
        }
        this.attrName = attrName = this.getAttrName(textShape);
        if (haveToAsk && !this.getUserDecision(context)) {
            return;
        }
        this.preDelete(context);
        if (textShape.getGraphicsAlgorithm() == null) {
            return;
        }
        this.deleteAttribute(textShape, attrName);
    }

    protected void deleteBusinessObjects(Object[] businessObjects) {
        if (businessObjects != null) {
            Object[] objectArray = businessObjects;
            int n = businessObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                this.deleteBusinessObject(bo);
                ++n2;
            }
        }
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public String getName() {
        return JPAEditorMessages.ClickRemoveAttributeButtonFeature_createAttributeButtonlabel;
    }

    public String getDescription() {
        return JPAEditorMessages.ClickRemoveAttributeButtonFeature_createAttributeButtonDescription;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private Set<PersistentType> getAllJPTWithSameIDClassOrEmbeddedId(PersistentType jpt, String fqn) {
        HashSet<PersistentType> persistentTypes = new HashSet<PersistentType>();
        ListIterator lit = jpt.getJpaProject().getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator();
        PersistenceUnit pu = (PersistenceUnit)lit.next();
        for (PersistentType persistentType : pu.getPersistentTypes()) {
            if (persistentType.getName().equals(jpt.getName()) || !this.hasSameEmbeddedId(persistentType, fqn) && !this.hasSameIdClass(persistentType, fqn)) continue;
            persistentTypes.add(persistentType);
        }
        return persistentTypes;
    }

    private boolean hasSameIdClass(PersistentType jpt, String fqn) {
        JpaArtifactFactory jpaFactory = JpaArtifactFactory.instance();
        return jpaFactory.hasIDClass(jpt) && jpaFactory.getIdType(jpt).equals(fqn);
    }

    private boolean hasSameEmbeddedId(PersistentType jpt, String fqn) {
        JpaArtifactFactory jpaFactory = JpaArtifactFactory.instance();
        for (PersistentAttribute jpa : jpt.getAttributes()) {
            if (!jpaFactory.isEmbeddedId(jpa) || !JPAEditorUtil.getAttributeTypeNameWithGenerics(jpa).equals(fqn)) continue;
            return true;
        }
        return false;
    }

    private void deleteFieldFromCompositePKClass(String attrName, PersistentType jpt) {
        PersistentAttribute jpa = jpt.getAttributeNamed(attrName);
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(jpa);
        if (attributeMapping instanceof SingleRelationshipMapping2_0) {
            DerivedIdentity2_0 derivedIdentity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity();
            if (derivedIdentity.usesIdDerivedIdentityStrategy()) {
                this.deleteFieldFromIdClassCompositePK(attrName, jpt);
            } else if (derivedIdentity.usesMapsIdDerivedIdentityStrategy()) {
                this.deleteFieldFromEmbeddedIDCompositePK(jpt, jpa);
            }
        }
    }

    private void deleteFieldFromEmbeddedIDCompositePK(PersistentType jpt, PersistentAttribute jpa) {
        DerivedIdentity2_0 derivedIdentity;
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(jpa);
        if (attributeMapping instanceof SingleRelationshipMapping2_0 && (derivedIdentity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity()).usesMapsIdDerivedIdentityStrategy()) {
            String attribName = derivedIdentity.getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName();
            if (attribName == null) {
                return;
            }
            JpaArtifactFactory jpaFactory = JpaArtifactFactory.instance();
            for (PersistentAttribute jpa1 : jpt.getAttributes()) {
                PersistentType embeddedJPT;
                String fqn;
                if (!jpaFactory.isEmbeddedId(jpa1) || !this.isDeleteAttributeAllowed(jpt, fqn = JPAEditorUtil.getAttributeTypeNameWithGenerics(jpa1)) || (embeddedJPT = jpaFactory.getContextPersistentType(jpt.getJpaProject(), fqn)) == null) continue;
                jpaFactory.deleteAttribute(embeddedJPT, attribName, this.getFeatureProvider());
            }
        }
    }

    private void deleteFieldFromIdClassCompositePK(String attrName, PersistentType jpt) {
        JpaArtifactFactory jpaFactory = JpaArtifactFactory.instance();
        JavaPersistentType idClassJPT = jpaFactory.getIdClassJPT(jpt);
        if (idClassJPT != null && this.isDeleteAttributeAllowed(jpt, idClassJPT.getName())) {
            DeleteAttributeCommand deleteAttributeCommand = new DeleteAttributeCommand((PersistentType)idClassJPT, attrName, this.getFeatureProvider());
            try {
                this.getJpaProjectManager().execute((Command)deleteAttributeCommand, SynchronousUiCommandContext.instance());
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Cannot delete attribute with name " + attrName, e);
            }
        }
    }

    private boolean isDeleteAttributeAllowed(PersistentType jpt, String fqn) {
        Set<PersistentType> jpts = this.getAllJPTWithSameIDClassOrEmbeddedId(jpt, fqn);
        for (PersistentType perType : jpts) {
            for (PersistentAttribute jpa : perType.getAttributes()) {
                DerivedIdentity2_0 derivedIdentity;
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(jpa);
                if (!(attributeMapping instanceof SingleRelationshipMapping2_0) || !(derivedIdentity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity()).usesIdDerivedIdentityStrategy() && !derivedIdentity.usesMapsIdDerivedIdentityStrategy()) continue;
                return false;
            }
        }
        return true;
    }

    private JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }
}

