/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.URIStorage;
import org.eclipse.emf.compare.utils.DelegatingURIConverter;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;

public class StorageURIConverter
extends DelegatingURIConverter {
    private Set<IStorage> loadedRevisions = Sets.newSetFromMap(new ConcurrentHashMap());

    public StorageURIConverter(URIConverter delegate) {
        super(delegate);
    }

    public Set<IStorage> getLoadedRevisions() {
        return this.loadedRevisions;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        return this.createInputStream(uri, Maps.newHashMap());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        URIHandler handler = this.getURIHandler(normalizedURI);
        if (uri.isPlatformResource()) {
            this.getLoadedRevisions().add(this.createStorage(uri, handler, (URIConverter)this));
        }
        LinkedHashMap actualOptions = Maps.newLinkedHashMap();
        actualOptions.put("URI_CONVERTER", this);
        if (options != null) {
            actualOptions.putAll(options);
        }
        return handler.createInputStream(normalizedURI, (Map)actualOptions);
    }

    protected IStorage createStorage(URI uri, URIHandler handler, URIConverter converter) {
        return new URIStorage(uri, handler, converter);
    }
}

