/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.DragPermissionRequest;
import org.eclipse.wb.gef.core.tools.SelectEditPartTracker;
import org.eclipse.wb.gef.core.tools.ToolUtilities;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.gef.core.IObjectInfoEditPart;
import org.eclipse.wb.internal.gef.core.SharedCursors;

public class DragEditPartTracker
extends SelectEditPartTracker {
    private boolean m_canMove;
    private boolean m_canReparent;
    private Collection<IFigure> m_exclusionSet;

    public DragEditPartTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.setDefaultCursor(SharedCursors.CURSOR_MOVE);
        this.setDisabledCursor(SharedCursors.CURSOR_NO);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.m_exclusionSet = null;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.m_state == 4) {
            List<Object> models = this.getOperationSetModels();
            this.eraseTargetFeedback();
            this.executeCommand();
            this.m_state = 0x40000000;
            this.restoreSelectionFromModels(models);
        } else {
            super.handleButtonUp(button);
        }
        return true;
    }

    @Override
    protected boolean handleDragStarted() {
        super.handleDragStarted();
        if (this.m_state == 4) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
        }
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.m_state == 4) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showTargetFeedback();
            this.updateCommand();
        }
        return true;
    }

    @Override
    protected Collection<IFigure> getExclusionSet() {
        if (this.m_exclusionSet == null) {
            List<? extends org.eclipse.gef.EditPart> set = this.getOperationSet();
            this.m_exclusionSet = new ArrayList<IFigure>(set.size());
            for (org.eclipse.gef.EditPart editPart : set) {
                GraphicalEditPart editpart = (GraphicalEditPart)editPart;
                this.m_exclusionSet.add(editpart.getFigure());
            }
        }
        return this.m_exclusionSet;
    }

    @Override
    protected EditPartViewer.Conditional getTargetingConditional() {
        if (!this.getCurrentViewer().getSelectedEditParts().isEmpty() && this.getOperationSet().isEmpty()) {
            return editPart -> false;
        }
        return super.getTargetingConditional();
    }

    @Override
    protected List<? extends org.eclipse.gef.EditPart> createOperationSet() {
        List<org.eclipse.gef.EditPart> operationSet = ToolUtilities.getSelectionWithoutDependants(this.getCurrentViewer());
        Object request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(operationSet);
        request = new DragPermissionRequest();
        for (org.eclipse.gef.EditPart editPart : operationSet) {
            editPart.performRequest((Request)request);
        }
        this.m_canMove = ((DragPermissionRequest)((Object)request)).canMove();
        this.m_canReparent = ((DragPermissionRequest)((Object)request)).canReparent();
        return operationSet;
    }

    @Override
    protected Request createTargetRequest() {
        return new ChangeBoundsRequest("move");
    }

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        request.setMoveDelta(new Point(this.getDragMoveDelta()));
        request.setLocation(this.getAbsoluteLocation());
    }

    @Override
    protected void updateTargetRequest(org.eclipse.gef.EditPart target) {
        super.updateTargetRequest(target);
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        List editParts = request.getEditParts();
        if (!editParts.isEmpty()) {
            if (((org.eclipse.gef.EditPart)editParts.get(0)).getParent() == target) {
                request.setType("move");
            } else {
                request.setType("add children");
            }
        }
    }

    private boolean isMove() {
        return this.getTargetRequest().getType() == "move";
    }

    private List<Object> getOperationSetModels() {
        ArrayList<Object> models = new ArrayList<Object>();
        for (org.eclipse.gef.EditPart editPart : this.getOperationSet()) {
            models.add(editPart.getModel());
        }
        return models;
    }

    private void restoreSelectionFromModels(List<Object> models) {
        if (models != null) {
            IEditPartViewer viewer = this.getCurrentViewer();
            ArrayList<org.eclipse.gef.EditPart> newEditParts = new ArrayList<org.eclipse.gef.EditPart>();
            for (Object model : models) {
                org.eclipse.gef.EditPart newEditPart = (org.eclipse.gef.EditPart)viewer.getEditPartRegistry().get(model);
                if (newEditPart == null) continue;
                newEditParts.add(newEditPart);
            }
            viewer.setSelection((ISelection)new StructuredSelection(newEditParts));
        }
    }

    @Override
    protected Command getCommand() {
        org.eclipse.gef.EditPart targetEditPart;
        Request request = this.getTargetRequest();
        List<? extends org.eclipse.gef.EditPart> operationSet = this.getOperationSet();
        if (this.isMove()) {
            if (this.m_canMove && !operationSet.isEmpty()) {
                org.eclipse.gef.EditPart firstPart = operationSet.get(0);
                return firstPart.getParent().getCommand(request);
            }
        } else if (this.m_canReparent && (targetEditPart = this.getTargetEditPart()) != null) {
            Command reparentCommand;
            CompoundCommand compoundCommand = new CompoundCommand();
            if (targetEditPart instanceof IObjectInfoEditPart) {
                IObjectInfoEditPart objectInfoEditPart = (IObjectInfoEditPart)targetEditPart;
                compoundCommand = objectInfoEditPart.createCompoundCommand();
            }
            if (!operationSet.isEmpty()) {
                org.eclipse.gef.EditPart firstPart = operationSet.get(0);
                GroupRequest orphanRequest = new GroupRequest((Object)"orphan");
                orphanRequest.setEditParts(operationSet);
                compoundCommand.add(firstPart.getParent().getCommand((Request)orphanRequest));
            }
            if ((reparentCommand = targetEditPart.getCommand(request)) != null) {
                compoundCommand.add(reparentCommand);
                return compoundCommand;
            }
        }
        return null;
    }
}

