/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.transport.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.ListenerKey;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.eclipse.wst.jsdt.debug.transport.socket.SocketConnection;
import org.eclipse.wst.jsdt.debug.transport.socket.SocketListenerKey;

public abstract class SocketTransportService
implements TransportService {
    private Map listeners = new HashMap();

    @Override
    public synchronized ListenerKey startListening(String address) throws IOException {
        String host = null;
        int port = 0;
        if (address != null) {
            String[] strings = address.split(":");
            if (strings.length == 2) {
                host = strings[0];
                port = Integer.parseInt(strings[1]);
            } else {
                port = Integer.parseInt(strings[0]);
            }
        }
        if (host == null) {
            host = "localhost";
        }
        SocketListenerKey key = new SocketListenerKey(String.valueOf(host) + ":" + port);
        ServerSocket serverSocket = new ServerSocket(port);
        this.listeners.put(key, serverSocket);
        return key;
    }

    @Override
    public void stopListening(ListenerKey key) throws IOException {
        ServerSocket serverSocket = (ServerSocket)this.listeners.remove(key);
        if (serverSocket != null) {
            serverSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerSocket getServerSocket(ListenerKey key) {
        Map map = this.listeners;
        synchronized (map) {
            return (ServerSocket)this.listeners.get(key);
        }
    }

    @Override
    public Connection accept(ListenerKey key, long attachTimeout, long handshakeTimeout) throws IOException {
        ServerSocket serverSocket = this.getServerSocket(key);
        if (serverSocket == null) {
            throw new IllegalStateException("Accept failed. Not listening for address: key.address()");
        }
        int timeout = (int)attachTimeout;
        if (timeout > 0) {
            if (timeout > Integer.MAX_VALUE) {
                timeout = Integer.MAX_VALUE;
            }
            serverSocket.setSoTimeout(timeout);
        }
        SocketConnection connection = this.getConnection(serverSocket.accept());
        this.handleAccept(connection);
        return connection;
    }

    public abstract void handleAccept(Connection var1) throws IOException;

    public abstract SocketConnection getConnection(Socket var1) throws IOException;

    @Override
    public Connection attach(String address, long attachTimeout, long handshakeTimeout) throws IOException {
        String host = null;
        int port = 0;
        if (address != null) {
            String[] strings = address.split(":");
            if (strings.length == 2) {
                host = strings[0];
                port = Integer.parseInt(strings[1]);
            } else {
                port = Integer.parseInt(strings[0]);
            }
        }
        if (host == null) {
            host = "localhost";
        }
        SocketConnection connection = this.getConnection(new Socket(host, port));
        this.handleAttach(connection);
        return connection;
    }

    public abstract void handleAttach(Connection var1) throws IOException;
}

