/*******************************************************************************
 * Copyright (c) 2011, 2025 Google, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Google, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.wb.internal.swing.preferences.layout;

import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.ui.AbstractBindingComposite;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.layout.LayoutNameSupport;
import org.eclipse.wb.internal.swing.preferences.IPreferenceConstants;
import org.eclipse.wb.internal.swing.preferences.Messages;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * Main {@link PreferencePage} for Layout Support.
 *
 * @author scheglov_ke
 * @author sablin_aa
 * @coverage swing.preferences.ui
 */
public final class LayoutsPreferencePage
extends
org.eclipse.wb.internal.core.preferences.LayoutsPreferencePage {
	////////////////////////////////////////////////////////////////////////////
	//
	// Constructor
	//
	////////////////////////////////////////////////////////////////////////////
	public LayoutsPreferencePage() {
		super(ToolkitProvider.DESCRIPTION);
	}

	@Override
	protected AbstractBindingComposite createBindingComposite(Composite parent) {
		return new ContentsCompositeEx(parent, m_bindManager, m_preferences);
	}

	////////////////////////////////////////////////////////////////////////////
	//
	// Contents
	//
	////////////////////////////////////////////////////////////////////////////
	protected class ContentsCompositeEx extends ContentsComposite {
		public ContentsCompositeEx(Composite parent,
				DataBindManager bindManager,
				IPreferenceStore preferences) {
			super(parent, bindManager, preferences);
			// layout variable name template
			{
				new Label(this, SWT.NONE).setText(Messages.LayoutsPreferencePage_layoutNamePattern);
				// control
				Combo templateCombo = new Combo(this, SWT.READ_ONLY);
				templateCombo.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
				templateCombo.setItems(LayoutNameSupport.TEMPLATES);
				// bind
				bindString(templateCombo, IPreferenceConstants.P_LAYOUT_NAME_TEMPLATE);
			}
		}
	}
}