/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.properties.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.eef.EEFContainerDescription;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFDynamicMappingFor;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EEFGroup;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.properties.api.EEFSectionDescriptor;
import org.eclipse.eef.ide.ui.properties.internal.RefreshIdsHolder;
import org.eclipse.eef.properties.ui.api.AbstractEEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFSectionDescriptor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFTabDescriptor
extends AbstractEEFTabDescriptor {
    private static final String DEFAULT_PAGE_LABEL = "General";
    private EEFPage eefPage;

    public EEFTabDescriptor(EEFPage eefPage) {
        this.eefPage = eefPage;
    }

    public String getId() {
        StringBuilder identifier = new StringBuilder();
        identifier.append(this.eefPage.getDescription().getIdentifier());
        List groups = this.eefPage.getGroups();
        for (EEFGroup eefGroup : groups) {
            identifier.append(eefGroup.getDescription().getIdentifier());
            Object groupSemanticElement = eefGroup.getVariableManager().getVariables().get("self");
            if (groupSemanticElement instanceof EObject) {
                identifier.append(this.getIdForEObject((EObject)groupSemanticElement));
            }
            identifier.append(groupSemanticElement.hashCode());
        }
        groups.stream().map(EEFGroup::getDescription).flatMap(description -> description.getControls().stream().flatMap(this::getDynamicMappingFors)).filter(EEFDynamicMappingFor::isForceRefresh).findFirst().ifPresent(control -> {
            StringBuilder stringBuilder2 = identifier.append(System.currentTimeMillis());
        });
        Object pageSemanticElement = this.eefPage.getVariableManager().getVariables().get("self");
        if (pageSemanticElement instanceof EObject) {
            identifier.append(this.getIdForEObject((EObject)pageSemanticElement));
        }
        identifier.append(System.identityHashCode(pageSemanticElement));
        return identifier.toString();
    }

    private Stream<EEFDynamicMappingFor> getDynamicMappingFors(EEFControlDescription eefControlDescription) {
        Stream<Object> stream = Stream.empty();
        if (eefControlDescription instanceof EEFDynamicMappingFor) {
            stream = Stream.of((EEFDynamicMappingFor)eefControlDescription);
        } else if (eefControlDescription instanceof EEFContainerDescription) {
            EEFContainerDescription eefContainerDescription = (EEFContainerDescription)eefControlDescription;
            stream = eefContainerDescription.getControls().stream().flatMap(this::getDynamicMappingFors);
        }
        return stream;
    }

    private Integer getIdForEObject(EObject eObject) {
        return RefreshIdsHolder.getOrCreateID(eObject);
    }

    public String getLabel() {
        String labelExpression = this.eefPage.getDescription().getLabelExpression();
        EAttribute eAttribute = EefPackage.Literals.EEF_PAGE_DESCRIPTION__LABEL_EXPRESSION;
        return (String)EvalFactory.of((IInterpreter)this.eefPage.getInterpreter(), (IVariableManager)this.eefPage.getVariableManager()).logIfBlank(eAttribute).logIfInvalidType(String.class).defaultValue((Object)DEFAULT_PAGE_LABEL).evaluate(labelExpression);
    }

    public List<IEEFSectionDescriptor> getSectionDescriptors() {
        ArrayList<IEEFSectionDescriptor> sectionDescriptors = new ArrayList<IEEFSectionDescriptor>();
        sectionDescriptors.add((IEEFSectionDescriptor)new EEFSectionDescriptor(this.eefPage));
        return sectionDescriptors;
    }

    public String getCategory() {
        return "EEF";
    }

    public boolean isIndented() {
        return this.eefPage.getDescription().isIndented();
    }
}

