/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;

public class ValidityNodeCheckStateListener
implements ICheckStateListener {
    private final @NonNull ValidityView validityView;

    public ValidityNodeCheckStateListener(@NonNull ValidityView validityView) {
        this.validityView = validityView;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        RootNode rootNode = this.validityView.getValidityManager().getRootNode();
        assert (rootNode != null);
        Object element = event.getElement();
        if (element instanceof AbstractNode) {
            AbstractNode abstractNode = (AbstractNode)element;
            boolean enabled = event.getChecked();
            abstractNode.setEnabled(enabled);
            this.updateEnabledState(abstractNode, enabled);
        }
        this.validityView.redraw();
    }

    private void updateEnabledState(@NonNull AbstractNode node, boolean enabled) {
        if (node instanceof ResultValidatableNode) {
            ResultConstrainingNode otherTreeNode = ((ResultValidatableNode)node).getResultConstrainingNode();
            otherTreeNode.setEnabled(enabled);
        } else if (node instanceof ResultConstrainingNode) {
            ResultValidatableNode otherTreeNode = ((ResultConstrainingNode)node).getResultValidatableNode();
            otherTreeNode.setEnabled(enabled);
        } else {
            for (AbstractNode child : node.getChildren()) {
                node.setEnabled(enabled);
                if (child == null) continue;
                this.updateEnabledState(child, enabled);
            }
        }
    }
}

