package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ServiceMode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServiceMode.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableServiceMode implements ServiceMode {
  private final @Nullable ReplicatedService replicated;
  private final @Nullable ReplicatedJob replicatedJob;
  private final @Nullable GlobalService global;
  private final @Nullable GlobalJob globalJob;

  private ImmutableServiceMode(
      @Nullable ReplicatedService replicated,
      @Nullable ReplicatedJob replicatedJob,
      @Nullable GlobalService global,
      @Nullable GlobalJob globalJob) {
    this.replicated = replicated;
    this.replicatedJob = replicatedJob;
    this.global = global;
    this.globalJob = globalJob;
  }

  /**
   * @return The value of the {@code replicated} attribute
   */
  @JsonProperty("Replicated")
  @Override
  public @Nullable ReplicatedService replicated() {
    return replicated;
  }

  /**
   * @return The value of the {@code replicatedJob} attribute
   */
  @JsonProperty("ReplicatedJob")
  @Override
  public @Nullable ReplicatedJob replicatedJob() {
    return replicatedJob;
  }

  /**
   * @return The value of the {@code global} attribute
   */
  @JsonProperty("Global")
  @Override
  public @Nullable GlobalService global() {
    return global;
  }

  /**
   * @return The value of the {@code globalJob} attribute
   */
  @JsonProperty("GlobalJob")
  @Override
  public @Nullable GlobalJob globalJob() {
    return globalJob;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceMode#replicated() replicated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for replicated (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableServiceMode withReplicated(@Nullable ReplicatedService value) {
    if (this.replicated == value) return this;
    return new ImmutableServiceMode(value, this.replicatedJob, this.global, this.globalJob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceMode#replicatedJob() replicatedJob} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for replicatedJob (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableServiceMode withReplicatedJob(@Nullable ReplicatedJob value) {
    if (this.replicatedJob == value) return this;
    return new ImmutableServiceMode(this.replicated, value, this.global, this.globalJob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceMode#global() global} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for global (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableServiceMode withGlobal(@Nullable GlobalService value) {
    if (this.global == value) return this;
    return new ImmutableServiceMode(this.replicated, this.replicatedJob, value, this.globalJob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ServiceMode#globalJob() globalJob} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for globalJob (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableServiceMode withGlobalJob(@Nullable GlobalJob value) {
    if (this.globalJob == value) return this;
    return new ImmutableServiceMode(this.replicated, this.replicatedJob, this.global, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServiceMode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServiceMode
        && equalsByValue((ImmutableServiceMode) another);
  }

  private boolean equalsByValue(ImmutableServiceMode another) {
    return Objects.equals(replicated, another.replicated)
        && Objects.equals(replicatedJob, another.replicatedJob)
        && Objects.equals(global, another.global)
        && Objects.equals(globalJob, another.globalJob);
  }

  /**
   * Computes a hash code from attributes: {@code replicated}, {@code replicatedJob}, {@code global}, {@code globalJob}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(replicated);
    h += (h << 5) + Objects.hashCode(replicatedJob);
    h += (h << 5) + Objects.hashCode(global);
    h += (h << 5) + Objects.hashCode(globalJob);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceMode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceMode{"
        + "replicated=" + replicated
        + ", replicatedJob=" + replicatedJob
        + ", global=" + global
        + ", globalJob=" + globalJob
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ServiceMode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ServiceMode instance
   */
  public static ImmutableServiceMode copyOf(ServiceMode instance) {
    if (instance instanceof ImmutableServiceMode) {
      return (ImmutableServiceMode) instance;
    }
    return ImmutableServiceMode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServiceMode ImmutableServiceMode}.
   * <pre>
   * ImmutableServiceMode.builder()
   *    .replicated(org.mandas.docker.client.messages.swarm.ReplicatedService | null) // nullable {@link ServiceMode#replicated() replicated}
   *    .replicatedJob(org.mandas.docker.client.messages.swarm.ReplicatedJob | null) // nullable {@link ServiceMode#replicatedJob() replicatedJob}
   *    .global(org.mandas.docker.client.messages.swarm.GlobalService | null) // nullable {@link ServiceMode#global() global}
   *    .globalJob(org.mandas.docker.client.messages.swarm.GlobalJob | null) // nullable {@link ServiceMode#globalJob() globalJob}
   *    .build();
   * </pre>
   * @return A new ImmutableServiceMode builder
   */
  public static ImmutableServiceMode.Builder builder() {
    return new ImmutableServiceMode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServiceMode ImmutableServiceMode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements ServiceMode.Builder {
    private ReplicatedService replicated;
    private ReplicatedJob replicatedJob;
    private GlobalService global;
    private GlobalJob globalJob;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceMode} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceMode instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable ReplicatedService replicatedValue = instance.replicated();
      if (replicatedValue != null) {
        replicated(replicatedValue);
      }
      @Nullable ReplicatedJob replicatedJobValue = instance.replicatedJob();
      if (replicatedJobValue != null) {
        replicatedJob(replicatedJobValue);
      }
      @Nullable GlobalService globalValue = instance.global();
      if (globalValue != null) {
        global(globalValue);
      }
      @Nullable GlobalJob globalJobValue = instance.globalJob();
      if (globalJobValue != null) {
        globalJob(globalJobValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceMode#replicated() replicated} attribute.
     * @param replicated The value for replicated (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Replicated")
    public final Builder replicated(@Nullable ReplicatedService replicated) {
      this.replicated = replicated;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceMode#replicatedJob() replicatedJob} attribute.
     * @param replicatedJob The value for replicatedJob (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ReplicatedJob")
    public final Builder replicatedJob(@Nullable ReplicatedJob replicatedJob) {
      this.replicatedJob = replicatedJob;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceMode#global() global} attribute.
     * @param global The value for global (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Global")
    public final Builder global(@Nullable GlobalService global) {
      this.global = global;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceMode#globalJob() globalJob} attribute.
     * @param globalJob The value for globalJob (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("GlobalJob")
    public final Builder globalJob(@Nullable GlobalJob globalJob) {
      this.globalJob = globalJob;
      return this;
    }

    /**
     * Builds a new {@link ImmutableServiceMode ImmutableServiceMode}.
     * @return An immutable instance of ServiceMode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServiceMode build() {
      return new ImmutableServiceMode(replicated, replicatedJob, global, globalJob);
    }
  }
}
