/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;

public class RelativeLocator
implements Locator {
    private double relativeX;
    private double relativeY;
    private IFigure reference;

    public RelativeLocator() {
        this.relativeX = 0.0;
        this.relativeY = 0.0;
    }

    public RelativeLocator(IFigure reference, int location) {
        this.setReferenceFigure(reference);
        this.relativeY = switch (location & 5) {
            case 1 -> 0.0;
            case 4 -> 1.0;
            default -> 0.5;
        };
        this.relativeX = switch (location & 0x18) {
            case 8 -> 0.0;
            case 16 -> 1.0;
            default -> 0.5;
        };
    }

    public RelativeLocator(IFigure reference, double relativeX, double relativeY) {
        this.setReferenceFigure(reference);
        this.relativeX = relativeX;
        this.relativeY = relativeY;
    }

    protected Rectangle getReferenceBox() {
        return this.getReferenceFigure().getBounds();
    }

    protected IFigure getReferenceFigure() {
        return this.reference;
    }

    @Override
    public void relocate(IFigure target) {
        IFigure reference = this.getReferenceFigure();
        PrecisionRectangle targetBounds = new PrecisionRectangle(this.getReferenceBox().getResized(-1, -1));
        reference.translateToAbsolute(targetBounds);
        target.translateToRelative(targetBounds);
        ((Rectangle)targetBounds).resize(1, 1);
        Dimension targetSize = target.getPreferredSize();
        targetBounds.x += (int)((double)targetBounds.width * this.relativeX - (double)((targetSize.width + 1) / 2));
        targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)((targetSize.height + 1) / 2));
        ((Rectangle)targetBounds).setSize(targetSize);
        target.setBounds(targetBounds);
    }

    public void setReferenceFigure(IFigure reference) {
        this.reference = reference;
    }
}

