/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSLong;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSInt
extends XSLong {
    private static final String XS_INT = "xs:int";

    public XSInt() {
        this(BigInteger.valueOf(0L));
    }

    public XSInt(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_INT;
    }

    @Override
    public String type_name() {
        return "int";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(Integer.MIN_VALUE);
            BigInteger max = BigInteger.valueOf(Integer.MAX_VALUE);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                DynamicError.throw_type_error();
            }
            return new XSInt(bigInt);
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_INT;
    }
}

