/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.error;

/**
 * Creates an error message indicating that an assertion that verifies a {@link CharSequence} is blank.
 */
public class ShouldBeBlank extends BasicErrorMessageFactory {

  /**
   * Creates a new <code>{@link ShouldBeBlank}</code>.
   * @param actual the actual value in the failed assertion.
   * @return the created {@code ErrorMessageFactory}.
   */
  public static ErrorMessageFactory shouldBeBlank(CharSequence actual) {
    return new ShouldBeBlank(actual);
  }

  private ShouldBeBlank(Object actual) {
    super("%nExpecting blank but was: %s", actual);
  }
}
