/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.DefaultDriver;
import io.github.toolfactory.jvm.function.catalog.AllocateInstanceFunction;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.GetFieldValueFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedClassesRetrieverFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedPackagesFunction;
import io.github.toolfactory.jvm.function.catalog.SetAccessibleFunction;
import io.github.toolfactory.jvm.function.catalog.SetFieldValueFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.util.Map;

public class NativeDriver
extends DefaultDriver {
    @Override
    protected Map<Object, Object> functionsToMap() {
        Map<Object, Object> context = super.functionsToMap();
        ObjectProvider objectProvider = ObjectProvider.get(context);
        objectProvider.markToBeInitializedViaExceptionHandler(ConsulterSupplier.class, context);
        ObjectProvider.get(context).markToBeInitializedViaExceptionHandler(ConsulterSupplyFunction.class, context);
        objectProvider.markToBeInitializedViaExceptionHandler(SetFieldValueFunction.class, context);
        objectProvider.markToBeInitializedViaExceptionHandler(AllocateInstanceFunction.class, context);
        objectProvider.markToBeInitializedViaExceptionHandler(GetFieldValueFunction.class, context);
        objectProvider.markToBeInitializedViaExceptionHandler(SetAccessibleFunction.class, context);
        objectProvider.markToBeInitializedViaExceptionHandler(GetLoadedPackagesFunction.class, context);
        objectProvider.markToBeInitializedViaExceptionHandler(GetLoadedClassesRetrieverFunction.class, context);
        ObjectProvider.setExceptionHandler(context, new ObjectProvider.ExceptionHandler(){

            @Override
            public <T> T handle(ObjectProvider objectProvider, Class<? super T> clazz, Map<Object, Object> context, ObjectProvider.BuildingException exception) {
                if (objectProvider.isMarkedToBeInitializedViaExceptionHandler(exception)) {
                    if (clazz.isAssignableFrom(NativeDriver.this.getConsulterSupplierFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getConsulterSupplierFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getConsulterSupplyFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getConsulterSupplyFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getThrowExceptionFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getThrowExceptionFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getSetFieldValueFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getSetFieldValueFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getAllocateInstanceFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getAllocateInstanceFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getSetAccessibleFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getSetAccessibleFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getGetFieldValueFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getGetFieldValueFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getGetLoadedClassesRetrieverFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getGetLoadedClassesRetrieverFunctionClass(), context);
                    }
                    if (clazz.isAssignableFrom(NativeDriver.this.getGetLoadedPackagesFunctionClass())) {
                        return (T)objectProvider.getOrBuildObject(NativeDriver.this.getGetLoadedPackagesFunctionClass(), context);
                    }
                }
                throw exception;
            }
        });
        return context;
    }

    protected Class<? extends ConsulterSupplier> getConsulterSupplierFunctionClass() {
        return ConsulterSupplier.Native.class;
    }

    @Override
    protected Class<? extends ConsulterSupplyFunction> getConsulterSupplyFunctionClass() {
        return ConsulterSupplyFunction.Native.class;
    }

    @Override
    protected Class<? extends GetLoadedPackagesFunction> getGetLoadedPackagesFunctionClass() {
        return GetLoadedPackagesFunction.Native.class;
    }

    @Override
    protected Class<? extends GetLoadedClassesRetrieverFunction> getGetLoadedClassesRetrieverFunctionClass() {
        return GetLoadedClassesRetrieverFunction.Native.class;
    }

    @Override
    protected Class<? extends SetFieldValueFunction> getSetFieldValueFunctionClass() {
        return SetFieldValueFunction.Native.class;
    }

    @Override
    protected Class<? extends GetFieldValueFunction> getGetFieldValueFunctionClass() {
        return GetFieldValueFunction.Native.class;
    }

    @Override
    protected Class<? extends AllocateInstanceFunction> getAllocateInstanceFunctionClass() {
        return AllocateInstanceFunction.Native.class;
    }

    @Override
    protected Class<? extends SetAccessibleFunction> getSetAccessibleFunctionClass() {
        return SetAccessibleFunction.Native.class;
    }
}

