/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.dltk.internal.ui.editor.SourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.text.hover.AnnotationExpandHover;
import org.eclipse.dltk.internal.ui.text.hover.AnnotationExpansionControl;
import org.eclipse.dltk.internal.ui.text.hover.ScriptHoverMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.editor.ScriptMarkerAnnotation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class ScriptExpandHover
extends AnnotationExpandHover {
    public static final String NO_BREAKPOINT_ANNOTATION = "org.eclipse.jdt.internal.ui.NoBreakpointAnnotation";
    private AnnotationPreferenceLookup fLookup = new AnnotationPreferenceLookup();
    private IPreferenceStore fStore = DLTKUIPlugin.getDefault().getPreferenceStore();

    public ScriptExpandHover(CompositeRuler ruler, IAnnotationAccess access, IDoubleClickListener doubleClickListener) {
        super(ruler, access, doubleClickListener);
    }

    @Override
    protected Object getHoverInfoForLine(ISourceViewer viewer, int line) {
        Annotation first;
        boolean showTemporaryProblems = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("ScriptEditor.ShowTemporaryProblem");
        IAnnotationModel model = viewer.getAnnotationModel();
        IDocument document = viewer.getDocument();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            String key;
            AnnotationPreference pref;
            Annotation annotation = (Annotation)e.next();
            if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && !((IAnnotationAccessExtension)this.fAnnotationAccess).isPaintable(annotation) || annotation instanceof IScriptAnnotation && !this.isIncluded((IScriptAnnotation)annotation, showTemporaryProblems) || (pref = this.fLookup.getAnnotationPreference(annotation)) != null && (key = pref.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key) || (position = model.getPosition(annotation)) == null || this.compareRulerLine(position, document, line) != 1 || this.isDuplicateMessage(messagesAtPosition, position, annotation.getText())) continue;
            exact.add(annotation);
        }
        this.sort(exact, model);
        if (exact.size() > 0) {
            this.setLastRulerMouseLocation(viewer, line);
        }
        if (exact.size() > 0 && !this.isBreakpointAnnotation(first = (Annotation)exact.get(0))) {
            exact.add(0, new NoBreakpointAnnotation());
        }
        if (exact.size() <= 1) {
            return null;
        }
        AnnotationExpansionControl.AnnotationHoverInput input = new AnnotationExpansionControl.AnnotationHoverInput();
        input.fAnnotations = exact.toArray(new Annotation[0]);
        input.fViewer = viewer;
        input.fRulerInfo = this.fCompositeRuler;
        input.fAnnotationListener = this.fgListener;
        input.fDoubleClickListener = this.fDblClickListener;
        input.redoAction = control -> control.setInput(this.getHoverInfoForLine(viewer, line));
        input.model = model;
        return input;
    }

    private boolean isIncluded(IScriptAnnotation annotation, boolean showTemporaryProblems) {
        if (annotation instanceof SourceModuleDocumentProvider.ProblemAnnotation && "org.eclipse.ui.workbench.texteditor.task".equals(annotation.getType())) {
            return false;
        }
        if (!annotation.isProblem()) {
            return true;
        }
        if (annotation.isMarkedDeleted() && !annotation.hasOverlay()) {
            return true;
        }
        if (annotation.hasOverlay() && !annotation.isMarkedDeleted()) {
            return true;
        }
        if (annotation.hasOverlay()) {
            return !this.isIncluded(annotation.getOverlay(), showTemporaryProblems);
        }
        return showTemporaryProblems;
    }

    @Override
    protected int getOrder(Annotation annotation) {
        if (this.isBreakpointAnnotation(annotation)) {
            return 1000;
        }
        return super.getOrder(annotation);
    }

    private boolean isBreakpointAnnotation(Annotation a) {
        if (a instanceof ScriptMarkerAnnotation) {
            ScriptMarkerAnnotation jma = (ScriptMarkerAnnotation)a;
            return jma.getType().equals("org.eclipse.debug.core.breakpoint");
        }
        return false;
    }

    private static class NoBreakpointAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        public NoBreakpointAnnotation() {
            super(ScriptExpandHover.NO_BREAKPOINT_ANNOTATION, false, ScriptHoverMessages.NoBreakpointAnnotation_addBreakpoint);
        }

        public void paint(GC gc, Canvas canvas, Rectangle bounds) {
            Image fImage = DLTKPluginImages.get("org.eclipse.dltk.ui.field_default_obj.png");
            ImageUtilities.drawImage((Image)fImage, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
        }

        public int getLayer() {
            return 0;
        }
    }
}

